/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxControllerFieldSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "execute"));
        }
        PsiElement elementToSearch = queryParameters.getElementToSearch();
        if (elementToSearch instanceof PsiField) {
            String qualifiedName;
            PsiField field = (PsiField)elementToSearch;
            PsiClass containingClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> field.getContainingClass());
            if (containingClass != null && (qualifiedName = (String)ApplicationManager.getApplication().runReadAction(() -> containingClass.getQualifiedName())) != null) {
                Project project = PsiUtilCore.getProjectInReadAction((PsiElement)containingClass);
                List<PsiFile> fxmlWithController = JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName);
                for (PsiFile file : fxmlWithController) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (queryParameters == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "lambda$execute$2"));
                        }
                        if (consumer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher", "lambda$execute$2"));
                        }
                        final String fieldName = field.getName();
                        if (fieldName == null) {
                            return;
                        }
                        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
                        if (searchScope.contains(virtualFile)) {
                            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                                public void visitXmlAttributeValue(XmlAttributeValue value) {
                                    XmlAttribute attribute;
                                    PsiElement parent;
                                    PsiElement resolve;
                                    PsiReference reference = value.getReference();
                                    if (reference != null && (resolve = reference.resolve()) instanceof XmlAttributeValue && (parent = resolve.getParent()) instanceof XmlAttribute && "fx:id".equals((attribute = (XmlAttribute)parent).getName()) && fieldName.equals(attribute.getValue())) {
                                        consumer.process((Object)reference);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        }
        return true;
    }
}

