/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.util.BiFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
implements ServiceRegistry,
Closeable {
    private static final ConcurrentMap<Class<?>, RelevantMethods> METHODS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Type, BiFunction<ServiceProvider, LookupContext, Provider>> SERVICE_TYPE_PROVIDER_CACHE = new ConcurrentHashMap<Type, BiFunction<ServiceProvider, LookupContext, Provider>>();
    private final Map<Type, ServiceProvider> providerCache = new HashMap<Type, ServiceProvider>();
    private final Object lock = new Object();
    private final OwnServices ownServices;
    private final Provider allServices;
    private final Provider parentServices;
    private final String displayName;
    private boolean closed;
    private boolean mutable = true;

    public DefaultServiceRegistry() {
        this(null, Collections.emptyList());
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, Collections.emptyList());
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(String displayName, ServiceRegistry ... parents) {
        this(displayName, Arrays.asList(parents));
    }

    public DefaultServiceRegistry(String displayName, Collection<? extends ServiceRegistry> parents) {
        this.displayName = displayName;
        this.ownServices = new OwnServices();
        if (parents.isEmpty()) {
            this.parentServices = null;
            this.allServices = this.ownServices;
        } else {
            if (parents.size() == 1) {
                this.parentServices = new ParentServices(parents.iterator().next());
            } else {
                ArrayList<ParentServices> providers = new ArrayList<ParentServices>(parents.size());
                for (ServiceRegistry serviceRegistry : parents) {
                    providers.add(new ParentServices(serviceRegistry));
                }
                this.parentServices = new CompositeProvider(providers);
            }
            ArrayList<Provider> allProviders = new ArrayList<Provider>(2);
            allProviders.add(this.ownServices);
            allProviders.add(this.parentServices);
            this.allServices = new CachingProvider(new CompositeProvider(allProviders));
        }
        this.findProviderMethods(this);
    }

    public static ServiceRegistry create(Object ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (Object provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    private String getDisplayName() {
        return this.displayName == null ? this.getClass().getSimpleName() : this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void findProviderMethods(Object target) {
        Class<?> type = target.getClass();
        RelevantMethods methods = this.getMethods(type);
        for (Method method : methods.decorators) {
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            this.ownServices.add(new DecoratorMethodService(target, method));
        }
        for (Method method : methods.factories) {
            this.ownServices.add(new FactoryMethodService(target, method));
        }
        for (Method method : methods.configurers) {
            this.applyConfigureMethod(method, target);
        }
    }

    private RelevantMethods getMethods(Class<?> type) {
        RelevantMethods relevantMethods = (RelevantMethods)METHODS_CACHE.get(type);
        if (relevantMethods == null) {
            relevantMethods = this.buildRelevantMethods(type);
            METHODS_CACHE.putIfAbsent(type, relevantMethods);
        }
        return relevantMethods;
    }

    private RelevantMethods buildRelevantMethods(Class<?> type) {
        RelevantMethodsBuilder builder = new RelevantMethodsBuilder(type);
        DefaultServiceRegistry.addDecoratorMethods(builder);
        DefaultServiceRegistry.addFactoryMethods(builder);
        DefaultServiceRegistry.addConfigureMethods(builder);
        RelevantMethods relevantMethods = builder.build();
        return relevantMethods;
    }

    private void applyConfigureMethod(Method method, Object target) {
        Object[] params = new Object[method.getGenericParameterTypes().length];
        DefaultLookupContext context = new DefaultLookupContext();
        for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
            Type paramType = method.getGenericParameterTypes()[i];
            if (paramType.equals(ServiceRegistration.class)) {
                params[i] = this.newRegistration();
                continue;
            }
            ServiceProvider paramProvider = context.find(paramType, this.allServices);
            if (paramProvider == null) {
                throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getDeclaringClass().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
            }
            params[i] = paramProvider.get();
        }
        try {
            DefaultServiceRegistry.invoke(method, target, params);
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()), e);
        }
    }

    private static void addConfigureMethods(RelevantMethodsBuilder builder) {
        Class<?> type = builder.type;
        Iterator<Method> iterator = builder.remainingMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (!method.getName().equals("configure")) continue;
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must return void.", type.getSimpleName(), method.getName()));
            }
            builder.add(iterator, builder.configurers, method);
        }
    }

    private static void addFactoryMethods(RelevantMethodsBuilder builder) {
        Class<?> type = builder.type;
        Iterator<Method> iterator = builder.remainingMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (!method.getName().startsWith("create") || Modifier.isStatic(method.getModifiers())) continue;
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type.getSimpleName(), method.getName()));
            }
            builder.add(iterator, builder.factories, method);
        }
    }

    private static void addDecoratorMethods(RelevantMethodsBuilder builder) {
        Class<?> type = builder.type;
        Iterator<Method> iterator = builder.remainingMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (!method.getName().startsWith("create") && !method.getName().startsWith("decorate") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(method.getReturnType())) continue;
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type.getSimpleName(), method.getName()));
            }
            builder.add(iterator, builder.decorators, method);
        }
    }

    public void register(Action<? super ServiceRegistration> action) {
        this.assertMutable();
        action.execute(this.newRegistration());
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Cannot add provide to service registry " + this + " as it is no longer mutable");
        }
    }

    private ServiceRegistration newRegistration() {
        return new ServiceRegistration(){

            @Override
            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(serviceType, serviceInstance);
            }

            @Override
            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(serviceType));
            }

            @Override
            public void addProvider(Object provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<T> serviceType, T serviceInstance) {
        this.assertMutable();
        this.ownServices.add(new FixedInstanceService<T>(serviceType, serviceInstance));
        return this;
    }

    public DefaultServiceRegistry addProvider(Object provider) {
        this.assertMutable();
        this.findProviderMethods(provider);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                CompositeStoppable.stoppable(this.allServices).stop();
            }
            finally {
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(DefaultServiceRegistry.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(DefaultServiceRegistry.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        Object object = this.lock;
        synchronized (object) {
            this.mutable = false;
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
            }
            ArrayList result = new ArrayList();
            DefaultLookupContext context = new DefaultLookupContext();
            this.allServices.getAll(context, serviceType, result);
            return result;
        }
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.doGet(serviceType));
    }

    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        return this.doGet(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGet(Type serviceType) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            this.mutable = false;
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
            }
            ServiceProvider provider = this.providerCache.get(serviceType);
            if (provider == null) {
                provider = this.getServiceProvider(serviceType);
                this.providerCache.put(serviceType, provider);
            }
            return provider.get();
        }
    }

    private ServiceProvider getServiceProvider(Type serviceType) {
        ServiceProvider provider = new DefaultLookupContext().find(serviceType, this.allServices);
        if (provider == null) {
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
        }
        return provider;
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", DefaultServiceRegistry.format(type), this.getDisplayName()));
            }
            DefaultLookupContext context = new DefaultLookupContext();
            ServiceProvider factory = this.allServices.getFactory(context, type);
            if (factory != null) {
                return (Factory)factory.get();
            }
            throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", DefaultServiceRegistry.format(type), this.getDisplayName()));
        }
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Object invoke(Method method, Object target, Object ... args) {
        return JavaReflectionUtil.method(target, Object.class, method).invoke(target, args);
    }

    private ServiceProvider getThisAsProvider() {
        return new ServiceProvider(){

            public String getDisplayName() {
                return "ServiceRegistry " + DefaultServiceRegistry.this.getDisplayName();
            }

            public Object get() {
                return DefaultServiceRegistry.this;
            }

            public void requiredBy(Provider provider) {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLookupContext
    implements LookupContext {
        private final Set<Type> visiting = new HashSet<Type>();

        private DefaultLookupContext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceProvider find(Type serviceType, Provider provider) {
            if (!this.visiting.add(serviceType)) {
                throw new ServiceValidationException(String.format("Cycle in dependencies of service of type %s.", DefaultServiceRegistry.format(serviceType)));
            }
            try {
                ServiceProvider serviceProvider = this.getServiceProvider(serviceType, provider);
                return serviceProvider;
            }
            finally {
                this.visiting.remove(serviceType);
            }
        }

        public ServiceProvider getServiceProvider(Type serviceType, Provider provider) {
            BiFunction<ServiceProvider, LookupContext, Provider> function = (BiFunction<ServiceProvider, LookupContext, Provider>)SERVICE_TYPE_PROVIDER_CACHE.get(serviceType);
            if (function == null) {
                function = DefaultLookupContext.createServiceProviderFactory(serviceType);
                SERVICE_TYPE_PROVIDER_CACHE.putIfAbsent(serviceType, function);
            }
            return function.apply(this, provider);
        }

        private static BiFunction<ServiceProvider, LookupContext, Provider> createServiceProviderFactory(Type serviceType) {
            ParameterizedType parameterizedType;
            if (serviceType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)serviceType).getRawType().equals(Factory.class)) {
                final Type typeArg = parameterizedType.getActualTypeArguments()[0];
                if (typeArg instanceof Class) {
                    return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                        @Override
                        public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                            return provider.getFactory(lookupContext, (Class)typeArg);
                        }
                    };
                }
                if (typeArg instanceof WildcardType) {
                    final WildcardType wildcardType = (WildcardType)typeArg;
                    if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                        return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                            @Override
                            public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                                return provider.getFactory(lookupContext, (Class)wildcardType.getLowerBounds()[0]);
                            }
                        };
                    }
                    if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                        return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                            @Override
                            public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                                return provider.getFactory(lookupContext, (Class)wildcardType.getUpperBounds()[0]);
                            }
                        };
                    }
                }
            }
            final TypeSpec serviceTypeSpec = DefaultLookupContext.toSpec(serviceType);
            return new BiFunction<ServiceProvider, LookupContext, Provider>(){

                @Override
                public ServiceProvider apply(LookupContext lookupContext, Provider provider) {
                    return provider.getService(lookupContext, serviceTypeSpec);
                }
            };
        }

        static TypeSpec toSpec(Type serviceType) {
            if (serviceType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)serviceType;
                ArrayList<TypeSpec> paramSpecs = new ArrayList<TypeSpec>();
                for (Type paramType : parameterizedType.getActualTypeArguments()) {
                    paramSpecs.add(DefaultLookupContext.toSpec(paramType));
                }
                return new ParameterizedTypeSpec(serviceType, DefaultLookupContext.toSpec(parameterizedType.getRawType()), paramSpecs);
            }
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)serviceType;
                if (serviceClass.isArray()) {
                    throw new ServiceValidationException("Locating services with array type is not supported.");
                }
                if (serviceClass.isAnnotation()) {
                    throw new ServiceValidationException("Locating services with annotation type is not supported.");
                }
                return new ClassSpec(serviceClass);
            }
            throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterizedTypeSpec
    implements TypeSpec {
        private final Type type;
        private final TypeSpec rawType;
        private final List<TypeSpec> paramSpecs;

        private ParameterizedTypeSpec(Type type, TypeSpec rawType, List<TypeSpec> paramSpecs) {
            this.type = type;
            this.rawType = rawType;
            this.paramSpecs = paramSpecs;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (!this.rawType.isSatisfiedBy(parameterizedType.getRawType())) {
                    return false;
                }
                for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                    Type type = parameterizedType.getActualTypeArguments()[i];
                    if (this.paramSpecs.get(i).isSatisfiedBy(type)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterizedTypeSpec that = (ParameterizedTypeSpec)o;
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!this.rawType.equals(that.rawType)) {
                return false;
            }
            return this.paramSpecs.equals(that.paramSpecs);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.rawType.hashCode();
            result = 31 * result + this.paramSpecs.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassSpec
    implements TypeSpec {
        private final Class<?> type;

        private ClassSpec(Class<?> type) {
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isSatisfiedBy(Type element) {
            if (element instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)element;
                if (parameterizedType.getRawType() instanceof Class) {
                    return this.type.isAssignableFrom((Class)parameterizedType.getRawType());
                }
            } else if (element instanceof Class) {
                Class other = (Class)element;
                return this.type.isAssignableFrom(other);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassSpec classSpec = (ClassSpec)o;
            return this.type != null ? this.type.equals(classSpec.type) : classSpec.type == null;
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface TypeSpec
    extends Spec<Type> {
        public Type getType();
    }

    static interface LookupContext {
        @Nullable
        public ServiceProvider find(Type var1, Provider var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentServices
    implements Provider {
        private final ServiceRegistry parent;

        private ParentServices(ServiceRegistry parent) {
            this.parent = parent;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            try {
                Factory<?> factory = this.parent.getFactory(type);
                assert (factory != null) : String.format("parent returned null for factory type '%s'", type.getName());
                return this.wrap(factory);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(type)) {
                    throw e;
                }
                return null;
            }
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            try {
                Object service = this.parent.get(serviceType.getType());
                assert (service != null) : String.format("parent returned null for service type %s", DefaultServiceRegistry.access$700(serviceType.getType()));
                return this.wrap(service);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(serviceType.getType())) {
                    throw e;
                }
                return null;
            }
        }

        private ServiceProvider wrap(final Object instance) {
            return new ServiceProvider(){

                public String getDisplayName() {
                    return "ServiceRegistry " + ParentServices.this.parent;
                }

                public Object get() {
                    return instance;
                }

                public void requiredBy(Provider provider) {
                }
            };
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            List<T> services = this.parent.getAll(serviceType);
            assert (services != null) : String.format("parent returned null for services of type %s", DefaultServiceRegistry.access$700(serviceType));
            result.addAll(services);
        }

        @Override
        public void stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeProvider
    implements Provider {
        private final Collection<Provider> providers;

        private CompositeProvider(Collection<Provider> providers) {
            this.providers = providers;
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            for (Provider provider : this.providers) {
                ServiceProvider service = provider.getService(context, serviceType);
                if (service == null) continue;
                return service;
            }
            return null;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            for (Provider provider : this.providers) {
                ServiceProvider factory = provider.getFactory(context, type);
                if (factory == null) continue;
                return factory;
            }
            return null;
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            for (Provider provider : this.providers) {
                provider.getAll(context, serviceType, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(this.providers).stop();
            }
            finally {
                this.providers.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachingProvider
    implements Provider {
        private final ConcurrentMap<Object, Optional<ServiceProvider>> seen = Maps.newConcurrentMap();
        private final ConcurrentMap<Class<?>, List<?>> allServicesCache = Maps.newConcurrentMap();
        private final Provider delegate;

        private CachingProvider(Provider delegate) {
            this.delegate = delegate;
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            Optional cached = (Optional)this.seen.get(serviceType);
            if (cached != null) {
                return (ServiceProvider)cached.orNull();
            }
            ServiceProvider service = this.delegate.getService(context, serviceType);
            return this.cacheServiceProvider(serviceType, service);
        }

        private ServiceProvider cacheServiceProvider(Object key, ServiceProvider service) {
            this.seen.putIfAbsent(key, (Optional<ServiceProvider>)(service == null ? Optional.absent() : Optional.of((Object)service)));
            return service;
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            Optional cached = (Optional)this.seen.get(type);
            if (cached != null) {
                return (ServiceProvider)cached.orNull();
            }
            ServiceProvider service = this.delegate.getFactory(context, type);
            return this.cacheServiceProvider(type, service);
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            List services = (List)this.allServicesCache.get(serviceType);
            if (services != null) {
                result.addAll(services);
                return;
            }
            ArrayList tmp = new ArrayList();
            this.delegate.getAll(context, serviceType, tmp);
            this.allServicesCache.putIfAbsent(serviceType, tmp);
            if (!tmp.isEmpty()) {
                result.addAll(tmp);
            }
        }

        @Override
        public void stop() {
            this.delegate.stop();
            this.seen.clear();
            this.allServicesCache.clear();
        }
    }

    private class DecoratorMethodService
    extends SingletonService {
        private final Method method;
        private Object target;
        private ServiceProvider paramProvider;

        public DecoratorMethodService(Object target, Method method) {
            super(method.getGenericReturnType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getGenericReturnType()) + " at " + this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName() + "()";
        }

        protected void bind(LookupContext context) {
            Type paramType = this.method.getGenericParameterTypes()[0];
            DefaultLookupContext parentLookupContext = new DefaultLookupContext();
            this.paramProvider = parentLookupContext.find(paramType, DefaultServiceRegistry.this.parentServices);
            if (this.paramProvider == null) {
                throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available in parent registries.", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName(), DefaultServiceRegistry.format(paramType)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object create() {
            Object result;
            Object param = this.paramProvider.get();
            try {
                result = DefaultServiceRegistry.invoke(this.method, this.target, new Object[]{param});
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.method.getGenericReturnType()), this.method.getDeclaringClass().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.paramProvider = null;
                this.target = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorService
    extends FactoryService {
        private final Constructor<?> constructor;

        private ConstructorService(Class<?> serviceType) {
            super(serviceType);
            Constructor<?>[] constructors = serviceType.getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new ServiceValidationException(String.format("Expected a single constructor for %s.", DefaultServiceRegistry.format(serviceType)));
            }
            this.constructor = constructors[0];
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.constructor;
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (InvocationTargetException e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e.getCause());
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e);
            }
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends SingletonService {
        public FixedInstanceService(Class<T> serviceType, T serviceInstance) {
            super(serviceType);
            this.setInstance(serviceInstance);
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType) + " with implementation " + this.getInstance();
        }

        @Override
        protected Object create() {
            throw new UnsupportedOperationException();
        }
    }

    private class FactoryMethodService
    extends FactoryService {
        private final Method method;
        private Object target;

        public FactoryMethodService(Object target, Method method) {
            super(method.getGenericReturnType());
            this.target = target;
            this.method = method;
        }

        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getGenericReturnType()) + " at " + this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName() + "()";
        }

        protected Type[] getParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        protected Member getFactory() {
            return this.method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object invokeMethod(Object[] params) {
            Object result;
            try {
                result = DefaultServiceRegistry.invoke(this.method, this.target, params);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.serviceType), this.method.getDeclaringClass().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.serviceType), this.method.getDeclaringClass().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.target = null;
            }
        }
    }

    private abstract class FactoryService
    extends SingletonService {
        private ServiceProvider[] paramProviders;

        protected FactoryService(Type serviceType) {
            super(serviceType);
        }

        protected abstract Type[] getParameterTypes();

        protected abstract Member getFactory();

        protected void bind(LookupContext context) {
            Type[] parameterTypes = this.getParameterTypes();
            this.paramProviders = new ServiceProvider[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type paramType = parameterTypes[i];
                try {
                    if (paramType.equals(ServiceRegistry.class)) {
                        this.paramProviders[i] = DefaultServiceRegistry.this.getThisAsProvider();
                        continue;
                    }
                    ServiceProvider paramProvider = context.find(paramType, DefaultServiceRegistry.this.allServices);
                    if (paramProvider == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    this.paramProviders[i] = paramProvider;
                    paramProvider.requiredBy(this);
                    continue;
                }
                catch (ServiceValidationException e) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), i + 1, DefaultServiceRegistry.format(paramType)), e);
                }
            }
        }

        protected Object create() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramProviders = null;
            return result;
        }

        private Object[] assembleParameters() {
            Object[] params = new Object[this.paramProviders.length];
            for (int i = 0; i < this.paramProviders.length; ++i) {
                ServiceProvider paramProvider = this.paramProviders[i];
                params[i] = paramProvider.get();
            }
            return params;
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingletonService
    extends ManagedObjectProvider<Object>
    implements ServiceProvider {
        final Type serviceType;
        final Class serviceClass;
        boolean bound;

        SingletonService(Type serviceType) {
            this.serviceType = serviceType;
            this.serviceClass = this.toClass(serviceType);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        private ServiceProvider prepare(LookupContext context) {
            if (!this.bound) {
                this.bind(context);
                this.bound = true;
            }
            return this;
        }

        protected void bind(LookupContext context) {
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (!serviceType.isSatisfiedBy(this.serviceType)) {
                return null;
            }
            return this.prepare(context);
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            if (serviceType.isAssignableFrom(this.serviceClass)) {
                result.add(serviceType.cast(this.prepare(context).get()));
            }
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> elementType) {
            if (!this.isFactory(this.serviceType, elementType)) {
                return null;
            }
            return this.prepare(context);
        }

        private boolean isFactory(Type type, Class<?> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c = this.toClass(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return false;
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class && elementType.isAssignableFrom((Class)actualType)) {
                return true;
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                if (!this.isFactory(interfaceType, elementType)) continue;
                return true;
            }
            return false;
        }

        private Class toClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedObjectProvider<T>
    implements Provider {
        private T instance;
        private Set<Provider> dependents;

        private ManagedObjectProvider() {
        }

        protected void setInstance(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            if (this.instance == null) {
                this.instance = this.create();
                assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
            }
            return this.instance;
        }

        protected abstract T create();

        public void requiredBy(Provider provider) {
            if (this.dependents == null) {
                this.dependents = Sets.newHashSet();
            }
            this.dependents.add(provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                if (this.instance != null) {
                    CompositeStoppable.stoppable(this.dependents == null ? Collections.emptyList() : this.dependents).add(this.instance).stop();
                }
            }
            finally {
                if (this.dependents != null) {
                    this.dependents.clear();
                }
                this.instance = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnServices
    implements Provider {
        private List<Provider> providers;

        private OwnServices() {
        }

        @Override
        public ServiceProvider getFactory(LookupContext context, Class<?> type) {
            if (this.providers == null) {
                return null;
            }
            ArrayList<ServiceProvider> candidates = new ArrayList<ServiceProvider>();
            ServiceProvider unique = null;
            for (Provider provider : this.providers) {
                ServiceProvider factory = provider.getFactory(context, type);
                if (factory == null) continue;
                unique = factory;
                candidates.add(factory);
            }
            if (candidates.size() == 0) {
                return null;
            }
            if (candidates.size() == 1) {
                return (ServiceProvider)candidates.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple factories for objects of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public ServiceProvider getService(LookupContext context, TypeSpec serviceType) {
            if (this.providers == null) {
                return null;
            }
            ArrayList<ServiceProvider> candidates = new ArrayList<ServiceProvider>();
            for (Provider provider : this.providers) {
                ServiceProvider service = provider.getService(context, serviceType);
                if (service == null) continue;
                candidates.add(service);
            }
            if (candidates.size() == 0) {
                return null;
            }
            if (candidates.size() == 1) {
                return (ServiceProvider)candidates.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (ServiceProvider candidate : candidates) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(serviceType.getType()), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public <T> void getAll(LookupContext context, Class<T> serviceType, List<T> result) {
            if (this.providers == null) {
                return;
            }
            for (Provider provider : this.providers) {
                provider.getAll(context, serviceType, result);
            }
        }

        @Override
        public void stop() {
            if (this.providers == null) {
                return;
            }
            CompositeStoppable.stoppable(this.providers).stop();
        }

        public void add(Provider provider) {
            if (this.providers == null) {
                this.providers = Lists.newArrayList();
            }
            this.providers.add(provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Provider
    extends Stoppable {
        public ServiceProvider getService(LookupContext var1, TypeSpec var2);

        public ServiceProvider getFactory(LookupContext var1, Class<?> var2);

        public <T> void getAll(LookupContext var1, Class<T> var2, List<T> var3);
    }

    static interface ServiceProvider {
        public String getDisplayName();

        public Object get();

        public void requiredBy(Provider var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RelevantMethodsBuilder {
        final List<Method> remainingMethods;
        final Class<?> type;
        final LinkedList<Method> decorators = new LinkedList();
        final LinkedList<Method> factories = new LinkedList();
        final LinkedList<Method> configurers = new LinkedList();
        final Set<String> seen = new HashSet<String>();

        public RelevantMethodsBuilder(Class<?> type) {
            this.type = type;
            this.remainingMethods = new LinkedList<Method>();
            for (Class<?> clazz = type; clazz != Object.class && clazz != DefaultServiceRegistry.class; clazz = clazz.getSuperclass()) {
                this.remainingMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            }
        }

        void add(Iterator<Method> iterator, List<Method> builder, Method method) {
            if (this.seen.add(method.getName())) {
                builder.add(method);
            }
            iterator.remove();
        }

        RelevantMethods build() {
            return new RelevantMethods(this.decorators, this.factories, this.configurers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RelevantMethods {
        final List<Method> decorators;
        final List<Method> factories;
        final List<Method> configurers;

        public RelevantMethods(List<Method> decorators, List<Method> factories, List<Method> configurers) {
            this.decorators = decorators;
            this.factories = factories;
            this.configurers = configurers;
        }
    }
}

