/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class JavaTypeInfo {
    public final JavaContainerType containerType;
    public final PsiType baseType;
    public final PsiType[] parameters;

    public JavaTypeInfo(JavaContainerType containerType, PsiType baseType, PsiType ... parameters) {
        this.containerType = containerType;
        this.baseType = baseType;
        this.parameters = parameters;
    }

    @Nullable
    public PsiType getValueType() {
        if (this.containerType == null || this.parameters.length == 0) {
            return this.baseType;
        }
        return this.parameters[0];
    }

    @Nullable
    public PsiType getKeyType() {
        if (this.containerType == null) {
            return null;
        }
        if (this.containerType == JavaContainerType.MAP) {
            return this.parameters.length == 2 ? this.parameters[1] : null;
        }
        return null;
    }

    public JavaTypeInfo copy() {
        return new JavaTypeInfo(this.containerType, this.baseType, (PsiType[])this.parameters.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaTypeInfo that = (JavaTypeInfo)o;
        if (this.baseType != null ? !this.baseType.equals(that.baseType) : that.baseType != null) {
            return false;
        }
        if (this.containerType != that.containerType) {
            return false;
        }
        return Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.containerType != null ? this.containerType.hashCode() : 0;
        result = 31 * result + (this.baseType != null ? this.baseType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }
}

