/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.CssDuplicatesView;
import com.intellij.dupLocator.CssDuplocateSettings;
import com.intellij.dupLocator.CssDuplocateVisitor;
import com.intellij.dupLocator.CssDuplocatorSettingsEditor;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfileAndPresentation;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssFileType;
import org.jetbrains.annotations.NotNull;

public class CssDuplicatesProfile
extends DuplicatesProfileAndPresentation {
    public CssDuplicatesProfile() {
        super(CssFileType.INSTANCE.getLanguage());
    }

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/CssDuplicatesProfile", "createVisitor"));
        }
        int lowerBound = CssDuplocateSettings.getInstance().LOWER_BOUND;
        CssDuplocateVisitor cssDuplocateVisitor = new CssDuplocateVisitor(collector, lowerBound);
        if (cssDuplocateVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/CssDuplicatesProfile", "createVisitor"));
        }
        return cssDuplocateVisitor;
    }

    @NotNull
    public DuplocatorSettingsEditor createEditor(@NotNull DuplocatorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/CssDuplicatesProfile", "createEditor"));
        }
        CssDuplocatorSettingsEditor cssDuplocatorSettingsEditor = new CssDuplocatorSettingsEditor();
        if (cssDuplocatorSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/CssDuplicatesProfile", "createEditor"));
        }
        return cssDuplocatorSettingsEditor;
    }

    @NotNull
    public DuplocatorState getDuplocatorState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/CssDuplicatesProfile", "getDuplocatorState"));
        }
        final CssDuplocateSettings settings = CssDuplocateSettings.getInstance();
        DuplocatorState duplocatorState = new DuplocatorState(){

            public int getLowerBound() {
                return settings.LOWER_BOUND;
            }

            public int getDiscardCost() {
                return 0;
            }
        };
        if (duplocatorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/CssDuplicatesProfile", "getDuplocatorState"));
        }
        return duplocatorState;
    }

    @NotNull
    public DuplicatesView createView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/CssDuplicatesProfile", "createView"));
        }
        CssDuplicatesView cssDuplicatesView = new CssDuplicatesView(project);
        if (cssDuplicatesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/CssDuplicatesProfile", "createView"));
        }
        return cssDuplicatesView;
    }

    public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
        PsiElement[] elements;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/CssDuplicatesProfile", "isMyDuplicate"));
        }
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        if (fragments.length > 0 && (elements = fragments[0].getElements()).length > 0) {
            return elements[0] instanceof CssElement;
        }
        return false;
    }

    public boolean supportIndex() {
        return false;
    }
}

