/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import org.jetbrains.annotations.NotNull;

public class CssDeclarationRangeHandler
implements DeclarationRangeHandler {
    @NotNull
    public TextRange getDeclarationRange(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/psi/css/CssDeclarationRangeHandler", "getDeclarationRange"));
        }
        if (container instanceof CssRuleset) {
            CssRuleset ruleset = (CssRuleset)container;
            CssSelectorList selectorList = ruleset.getSelectorList();
            if (selectorList != null) {
                TextRange textRange = selectorList.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssDeclarationRangeHandler", "getDeclarationRange"));
                }
                return textRange;
            }
        } else if (container instanceof CssAtRule) {
            TextRange textRange = TextRange.from((int)container.getTextOffset(), (int)((CssAtRule)container).getName().length());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssDeclarationRangeHandler", "getDeclarationRange"));
            }
            return textRange;
        }
        TextRange textRange = TextRange.from((int)container.getTextRange().getStartOffset(), (int)0);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssDeclarationRangeHandler", "getDeclarationRange"));
        }
        return textRange;
    }
}

