/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiColorAdjustmentUtils {
    @Nullable
    public static Color adjustColor(@NotNull Color color, @NotNull CssTerm term) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustColor"));
        }
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustColor"));
        }
        CssFunction function = (CssFunction)PsiTreeUtil.getChildOfType((PsiElement)term, CssFunction.class);
        if (function == null) {
            return null;
        }
        CssTermList termList = function.getValue();
        if (termList == null) {
            return null;
        }
        CssTerm[] terms = termList.getTerms();
        String functionName = function.getName();
        switch (functionName = functionName.toLowerCase(Locale.US)) {
            case "red": 
            case "green": 
            case "blue": 
            case "a": 
            case "alpha": {
                return CssPsiColorAdjustmentUtils.adjustRedGreenBlueAlpha(functionName, color, terms);
            }
            case "hue": 
            case "h": {
                return CssPsiColorAdjustmentUtils.adjustHue(color, terms);
            }
            case "saturation": 
            case "s": 
            case "lightness": 
            case "l": {
                return CssPsiColorAdjustmentUtils.adjustSaturationLightness(functionName, color, terms);
            }
            case "whiteness": 
            case "w": 
            case "blackness": 
            case "b": {
                return CssPsiColorAdjustmentUtils.adjustWhitenessBlackness(functionName, color, terms);
            }
            case "tint": 
            case "shade": {
                return CssPsiColorAdjustmentUtils.adjustTintShade(functionName, color, terms);
            }
            case "blend": {
                return CssPsiColorAdjustmentUtils.adjustBlend(color, terms);
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustRedGreenBlueAlpha(@NotNull String functionName, @NotNull Color color, @Nullable CssTerm[] terms) {
        int value;
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustRedGreenBlueAlpha"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustRedGreenBlueAlpha"));
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'%')) {
            double percentageValue = CssPsiColorUtil.getPercentageValueWithSign(text);
            if (percentageValue == Double.NaN) {
                return null;
            }
            value = (int)Math.round(255.0 * percentageValue);
        } else {
            value = StringUtil.parseInt((String)text, (int)Integer.MIN_VALUE);
            if (value == Integer.MIN_VALUE) {
                return null;
            }
        }
        switch (functionName) {
            case "red": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getRed();
                }
                return CssPsiColorUtil.createColor(value, color.getGreen(), color.getBlue(), color.getAlpha());
            }
            case "green": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getGreen();
                }
                return CssPsiColorUtil.createColor(color.getRed(), value, color.getBlue(), color.getAlpha());
            }
            case "blue": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getBlue();
                }
                return CssPsiColorUtil.createColor(color.getRed(), color.getGreen(), value, color.getAlpha());
            }
            case "a": 
            case "alpha": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getAlpha();
                }
                return CssPsiColorUtil.createColor(color.getRed(), color.getGreen(), color.getBlue(), value);
            }
        }
        return null;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static Color adjustHue(@NotNull Color color, @Nullable CssTerm[] terms) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustHue"));
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getHueValue(text);
        if (value == -1.0) {
            return null;
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
            value += hsl[0];
            value = 360.0 * value % 360.0 / 360.0;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(value, hsl[1], hsl[2]);
        return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustSaturationLightness(@NotNull String functionName, @NotNull Color color, @Nullable CssTerm[] terms) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustSaturationLightness"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustSaturationLightness"));
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValueWithSign(text);
        if (value == Double.NaN) {
            return null;
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        switch (functionName) {
            case "saturation": 
            case "s": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hsl[1], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHsl(hsl[0], value, hsl[2]);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
            case "lightness": 
            case "l": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hsl[2], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHsl(hsl[0], hsl[1], value);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustWhitenessBlackness(@NotNull String functionName, @NotNull Color color, @Nullable CssTerm[] terms) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustWhitenessBlackness"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustWhitenessBlackness"));
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValueWithSign(text);
        if (value == Double.NaN) {
            return null;
        }
        double[] hwb = CssPsiColorUtil.getHwbByRgb(color.getRed(), color.getGreen(), color.getBlue());
        switch (functionName) {
            case "whiteness": 
            case "w": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hwb[1], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHwb(hwb[0], value, hwb[2]);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
            case "blackness": 
            case "b": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hwb[2], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHwb(hwb[0], hwb[1], value);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustTintShade(@NotNull String functionName, @NotNull Color color, @Nullable CssTerm[] terms) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustTintShade"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustTintShade"));
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        if (!functionName.equals("tint") && !functionName.equals("shade")) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValue(text);
        if (value == -1.0) {
            return null;
        }
        return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInRgb(color, functionName.equals("tint") ? Color.WHITE : Color.BLACK, value), (int)color.getAlpha());
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static Color adjustBlend(@NotNull Color color, @Nullable CssTerm[] terms) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "adjustBlend"));
        }
        if (terms == null || terms.length != 2 && terms.length != 3) {
            return null;
        }
        String text = terms[1].getText().trim();
        double value = CssPsiColorUtil.getPercentageValue(text);
        if (value == -1.0) {
            return null;
        }
        String colorSpace = "rgb";
        if (!(terms.length != 3 || (colorSpace = terms[2].getText().toLowerCase()).equals("rgb") || colorSpace.equals("hsl") || colorSpace.equals("hwb"))) {
            return null;
        }
        Color mix = CssPsiColorUtil.getColorInClassicCss((PsiElement)terms[0]);
        if (mix == null) {
            return null;
        }
        switch (colorSpace) {
            case "rgb": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInRgb(color, mix, value), (int)color.getAlpha());
            }
            case "hsl": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInHsl(color, mix, value), (int)color.getAlpha());
            }
            case "hwb": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInHwb(color, mix, value), (int)color.getAlpha());
            }
        }
        return null;
    }

    @NotNull
    private static Color blendColorsInRgb(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInRgb"));
        }
        if (mix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mix", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInRgb"));
        }
        int red = CssPsiColorAdjustmentUtils.blendRgb(base.getRed(), mix.getRed(), value);
        int green = CssPsiColorAdjustmentUtils.blendRgb(base.getGreen(), mix.getGreen(), value);
        int blue = CssPsiColorAdjustmentUtils.blendRgb(base.getBlue(), mix.getBlue(), value);
        Color color = CssPsiColorUtil.createColor(red, green, blue);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInRgb"));
        }
        return color;
    }

    @NotNull
    private static Color blendColorsInHsl(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHsl"));
        }
        if (mix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mix", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHsl"));
        }
        double[] baseHsl = CssPsiColorUtil.getHslByRgb(base.getRed(), base.getGreen(), base.getBlue());
        double[] mixHsl = CssPsiColorUtil.getHslByRgb(mix.getRed(), mix.getGreen(), mix.getBlue());
        double h = CssPsiColorAdjustmentUtils.blend(baseHsl[0], mixHsl[0], value);
        double s = CssPsiColorAdjustmentUtils.blend(baseHsl[1], mixHsl[1], value);
        double l = CssPsiColorAdjustmentUtils.blend(baseHsl[2], mixHsl[2], value);
        double[] rgb = CssPsiColorUtil.getRgbByHsl(h, s, l);
        Color color = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHsl"));
        }
        return color;
    }

    @NotNull
    private static Color blendColorsInHwb(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHwb"));
        }
        if (mix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mix", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHwb"));
        }
        double[] baseHwb = CssPsiColorUtil.getHwbByRgb(base.getRed(), base.getGreen(), base.getBlue());
        double[] mixHwb = CssPsiColorUtil.getHwbByRgb(mix.getRed(), mix.getGreen(), mix.getBlue());
        double h = CssPsiColorAdjustmentUtils.blend(baseHwb[0], mixHwb[0], value);
        double w = CssPsiColorAdjustmentUtils.blend(baseHwb[1], mixHwb[1], value);
        double b = CssPsiColorAdjustmentUtils.blend(baseHwb[2], mixHwb[2], value);
        double[] rgb = CssPsiColorUtil.getRgbByHwb(h, w, b);
        Color color = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils", "blendColorsInHwb"));
        }
        return color;
    }

    private static double blend(double base, double mix, double value) {
        return (1.0 - value) * base + value * mix;
    }

    private static int blendRgb(int base, int mix, double value) {
        return (int)Math.round((1.0 - value) * (double)base + value * (double)mix);
    }
}

