/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssBraceMatcher
implements PairedBraceMatcher {
    private static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair(CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_RPAREN, false), new BracePair(CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET, false), new BracePair(CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, true)};

    public BracePair[] getPairs() {
        return BRACE_PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/psi/css/impl/util/editor/CssBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return type == null || CssElementTypes.COMMENTS.contains(type) || CssElementTypes.WHITESPACES.contains(type) || type == CssElementTypes.CSS_SEMICOLON || type == CssElementTypes.CSS_COMMA || type == CssElementTypes.CSS_RPAREN || type == CssElementTypes.CSS_LBRACE || type == CssElementTypes.CSS_RBRACE || type == CssElementTypes.CSS_RBRACKET;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        CssRuleset closestRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
        return closestRuleset != null ? closestRuleset.getTextRange().getStartOffset() : openingBraceOffset;
    }
}

