/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.table.AbstractCssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssShorthandExpandProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyDescriptorImpl
extends AbstractCssPropertyDescriptor {
    @NonNls
    private static final TokenSet POSSIBLE_VALUE_PREFIXES = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SLASH});
    private final CssPropertyInfo[] myCssPropertyInfos;
    private final String myPropertyName;
    private CssPropertyValueImpl myValue;
    private static final Logger LOG = Logger.getInstance(CssPropertyDescriptorImpl.class);

    public CssPropertyDescriptorImpl(@NotNull String propertyName, @NotNull CssPropertyInfo[] infos) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "<init>"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "<init>"));
        }
        this.myPropertyName = propertyName;
        this.myCssPropertyInfos = infos;
    }

    public boolean isShorthandValue() {
        if (this.getRefNames() != null) {
            return true;
        }
        if ("overflow".equals(this.getPropertyName())) {
            return true;
        }
        String propertyName = this.getPropertyName();
        if (propertyName.startsWith("-moz-border-radius")) {
            return propertyName.equals("-moz-border-radius");
        }
        if (propertyName.contains("border-radius")) {
            return true;
        }
        if ("cursor".equalsIgnoreCase(propertyName)) {
            return false;
        }
        if (propertyName.contains("border") && propertyName.contains("image")) {
            String[] sides = new String[]{"left", "right", "bottom", "top"};
            boolean containsSide = false;
            for (String s : sides) {
                if (!propertyName.contains(s)) continue;
                containsSide = true;
            }
            if (!containsSide) {
                return true;
            }
        }
        return this.getValue().getMaxValuesCount() == 4;
    }

    @Override
    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "isValidValue"));
        }
        if (CssPropertyUtil.isVendorSpecificElement(this.getPropertyName())) {
            return true;
        }
        String text = element.getText();
        if (text != null && CssPropertyUtil.isVendorSpecificElement(text.toLowerCase(Locale.US))) {
            return true;
        }
        return super.isValidValue(element);
    }

    @Override
    @NotNull
    public CssPropertyValue getValue() {
        CssPropertyValueImpl cssPropertyValueImpl = this.myValue;
        if (cssPropertyValueImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "getValue"));
        }
        return cssPropertyValueImpl;
    }

    void setValue(@NotNull CssPropertyValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "setValue"));
        }
        this.myValue = value;
    }

    @Nullable
    public static CssCompletionContext buildFullContext(CssDeclaration decl) {
        CssTermList value = decl.getValue();
        List<PsiElement> psiElements = value != null ? CssPropertyDescriptorImpl.buildContextPath((PsiElement)value, true) : Collections.emptyList();
        CssCompletionContext c = null;
        for (PsiElement each : psiElements) {
            c = CssCompletionContext.createContext((PsiElement)each, c);
        }
        return c;
    }

    @Override
    @NotNull
    public String[] expand(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "expand"));
        }
        if (this.isShorthandValue() && PsiTreeUtil.getChildOfType((PsiElement)declaration.getValue(), CssTerm.class) != null) {
            String[] stringArray = CssShorthandExpandProcessor.create(this).expand(declaration);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "expand"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "expand"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        CssCompletionContext c;
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "getShorthandPsiValue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "getShorthandPsiValue"));
        }
        CssPropertyValue value = CssShorthandExpandProcessor.create(this).getPropertyValue(decl, propertyName);
        if (value == null) {
            return null;
        }
        if (this.myPropertyName.startsWith("-moz-border-radius")) {
            propertyName = propertyName.replace("top", "top-");
            propertyName = propertyName.replace("bottom", "bottom-");
        }
        if (this.myPropertyName.contains("border-radius") || this.myPropertyName.contains("border") && this.myPropertyName.contains("image")) {
            c = CssPropertyDescriptorImpl.buildFullContext(decl);
            LOG.assertTrue(c != null, (Object)("Context is null for: " + decl.getText()));
            switch (c.getLength()) {
                case 1: {
                    return new PsiElement[]{c.getElement()};
                }
                case 2: {
                    if (propertyName.contains("top-right") || propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 3: {
                    if (propertyName.contains("top-right") || propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("bottom-right")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getElement()};
                }
                case 4: {
                    if (propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("bottom-right")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("top-right")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getParent().getElement()};
                }
            }
        }
        if (this.is4ValueProperty() || this.getPropertyName().contains("border-image")) {
            c = CssPropertyDescriptorImpl.buildFullContext(decl);
            if (c == null) {
                return null;
            }
            switch (c.getLength()) {
                case 1: {
                    return new PsiElement[]{c.getElement()};
                }
                case 2: {
                    if (propertyName.contains("left") || propertyName.contains("right")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 3: {
                    if (propertyName.contains("bottom")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("top")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 4: {
                    if (propertyName.contains("left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("bottom")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("right")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getParent().getElement()};
                }
            }
        } else {
            LinkedList<PsiElement> values = new LinkedList<PsiElement>();
            for (c = CssPropertyDescriptorImpl.buildFullContext(decl); c != null; c = c.getParent()) {
                PsiElement element = c.getElement();
                if (!value.isValueBelongs(element) || !CssPropertyDescriptorImpl.isPropertyValuePrefixMatch(element, value)) continue;
                values.addFirst(element);
            }
            return values.isEmpty() ? null : PsiUtilCore.toPsiElementArray(values);
        }
        return null;
    }

    @Override
    @NotNull
    public CssPropertyInfo[] getInfos() {
        if (this.myCssPropertyInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "getInfos"));
        }
        return this.myCssPropertyInfos;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "getPropertyName"));
        }
        return string;
    }

    public boolean getInherited() {
        for (CssPropertyInfo info : this.myCssPropertyInfos) {
            if (!"yes".equalsIgnoreCase(info.getInherited()) && !"true".equals(info.getInherited())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String toCanonicalName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "toCanonicalName"));
        }
        String string = propertyName.toLowerCase(Locale.US);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "toCanonicalName"));
        }
        return string;
    }

    private static boolean isPropertyValuePrefixMatch(@Nullable PsiElement element, CssPropertyValue value) {
        String prefix = value.getPrefix();
        if (element != null) {
            int maxValuesCount = Math.max(value.getMaxValuesCount(), 1);
            for (int i = 0; i < maxValuesCount; ++i) {
                CssTerm prevTerm;
                if ((element = PsiTreeUtil.prevVisibleLeaf((PsiElement)element)) != null && (prevTerm = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class)) != null) {
                    element = prevTerm;
                    if (!value.isValueBelongs((PsiElement)prevTerm)) break;
                    continue;
                }
                return prefix != null ? element != null && prefix.equalsIgnoreCase(element.getText()) : element == null || !CssPropertyDescriptorImpl.isPossibleValuePrefix(element);
            }
        }
        return prefix == null;
    }

    private static boolean isPossibleValuePrefix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl", "isPossibleValuePrefix"));
        }
        return POSSIBLE_VALUE_PREFIXES.contains(element.getNode().getElementType());
    }
}

