/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private String myUnresolvedMessage;
    private final FileType myFileType;

    public UrlReference(PsiElement element, @Nullable FileType _fileType, boolean soft) {
        super(element, soft);
        this.myFileType = _fileType;
    }

    public PsiElement resolve() {
        PsiFile psiFile;
        String referenceText = this.getCanonicalText();
        if (referenceText.contains("://") || referenceText.startsWith("//")) {
            if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(referenceText)) {
                return this.myElement;
            }
            String resourceLocation = ExternalResourceManager.getInstance().getResourceLocation(referenceText, this.myElement.getProject());
            if (referenceText.equals(resourceLocation)) {
                if (!this.isSoft()) {
                    this.myUnresolvedMessage = XmlErrorMessages.message((String)"uri.is.not.registered", (Object[])new Object[0]);
                    return null;
                }
                return this.myElement;
            }
            referenceText = resourceLocation;
        }
        if ((psiFile = XmlUtil.findRelativeFile((String)referenceText, (PsiElement)this.myElement.getContainingFile())) == null) {
            this.myUnresolvedMessage = CssBundle.message((String)"invalid.file.reference", (Object[])new Object[0]);
            return null;
        }
        if (this.myFileType != null && psiFile.getFileType() != this.myFileType) {
            this.myUnresolvedMessage = CssBundle.message((String)"file.refers.not.to", (Object[])new Object[]{this.myFileType.getName()});
            return null;
        }
        return psiFile;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/UrlReference", "bindToElement"));
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (this.getCanonicalText().contains("://")) {
            Object[] objectArray = ExternalResourceManager.getInstance().getResourceUrls(null, false);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/UrlReference", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/UrlReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myUnresolvedMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/UrlReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

