/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.applicationServer;

import com.intellij.icons.AllIcons;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.WebSphereUtil;
import com.intellij.j2ee.webSphere.applicationServer.WebSphereIntegration;
import com.intellij.j2ee.webSphere.applicationServer.WebSphereServerHelper;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersionUtil;
import com.intellij.j2ee.webSphere.deployment.WebSphereDeploymentProvider;
import com.intellij.j2ee.webSphere.descriptor.WebSphereAppBndDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereAppExtDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereAppExtPmeDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereEjbBndDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereEjbExtDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereEjbExtPmeDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereWebBndDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereWebExtDescriptor;
import com.intellij.j2ee.webSphere.descriptor.WebSphereWebExtPmeDescriptor;
import com.intellij.j2ee.webSphere.model.WebSphereAppBndRoot;
import com.intellij.j2ee.webSphere.model.WebSphereAppExtPmeRoot;
import com.intellij.j2ee.webSphere.model.WebSphereAppExtRoot;
import com.intellij.j2ee.webSphere.model.WebSphereEjbBndRoot;
import com.intellij.j2ee.webSphere.model.WebSphereEjbExtPmeRoot;
import com.intellij.j2ee.webSphere.model.WebSphereEjbExtRoot;
import com.intellij.j2ee.webSphere.model.WebSphereWebBndRoot;
import com.intellij.j2ee.webSphere.model.WebSphereWebExtPmeRoot;
import com.intellij.j2ee.webSphere.model.WebSphereWebExtRoot;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentSettingsEditor;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereStartupExecutable;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereIntegrationImpl
extends WebSphereIntegration {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("(ibm-[\\w-]+)_(\\d)_(\\d)\\.xml");

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new WebSphereDeploymentProvider();
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(WebSphereWebBndDescriptor.class, WebSphereWebBndRoot.class, "ibm-web-bnd");
        descriptorsManager.addItem(WebSphereWebExtDescriptor.class, WebSphereWebExtRoot.class, "ibm-web-ext");
        descriptorsManager.addItem(WebSphereWebExtPmeDescriptor.class, WebSphereWebExtPmeRoot.class, "ibm-web-ext-pme");
        descriptorsManager.addItem(WebSphereAppBndDescriptor.class, WebSphereAppBndRoot.class, "ibm-application-bnd");
        descriptorsManager.addItem(WebSphereAppExtDescriptor.class, WebSphereAppExtRoot.class, "ibm-application-ext");
        descriptorsManager.addItem(WebSphereAppExtPmeDescriptor.class, WebSphereAppExtPmeRoot.class, "ibm-application-ext-pme");
        descriptorsManager.addItem(WebSphereEjbBndDescriptor.class, WebSphereEjbBndRoot.class, "ibm-ejb-jar-bnd");
        descriptorsManager.addItem(WebSphereEjbExtDescriptor.class, WebSphereEjbExtRoot.class, "ibm-ejb-jar-ext");
        descriptorsManager.addItem(WebSphereEjbExtPmeDescriptor.class, WebSphereEjbExtPmeRoot.class, "ibm-ejb-jar-ext-pme");
    }

    @NotNull
    public String getName() {
        String string = WebSphereBundle.message("websphere.integration.presentable.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/applicationServer/WebSphereIntegrationImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.RunConfigurations.Web_app;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/applicationServer/WebSphereIntegrationImpl", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = AllIcons.RunConfigurations.Web_app;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/applicationServer/WebSphereIntegrationImpl", "getBigIcon"));
        }
        return icon;
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) throws Exception {
        return new TemplateMatcher(){

            @Override
            protected String doGetMatch(Matcher matcher) {
                return matcher.group(1);
            }
        }.getMatch(template);
    }

    @Nullable
    @NonNls
    public String getVersionFromTemplate(String template) throws Exception {
        return new TemplateMatcher(){

            @Override
            protected String doGetMatch(Matcher matcher) {
                return matcher.group(2) + "." + matcher.group(3);
            }
        }.getMatch(template);
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String string = WebSphereVersionUtil.get(persistentData);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/applicationServer/WebSphereIntegrationImpl", "getServerVersion"));
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        locations.add(new File(home, "lib"));
        locations.add(new File(home, "dev/spec"));
        locations.add(new File(home, "dev/api/spec"));
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return WebSphereIntegrationImpl.allLibrariesExceptEjbFound(classes, mapper);
    }

    public String getContextRoot(JavaeeFacet facet) {
        WebSphereWebExtRoot web = WebSphereUtil.getWebRoot(facet);
        return web != null ? (String)web.getContextRoot().getUri().getValue() : null;
    }

    protected JavaeeServerHelper createServerHelper() {
        return new WebSphereServerHelper();
    }

    public boolean isStartupScriptTerminating(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupScript", "com/intellij/j2ee/webSphere/applicationServer/WebSphereIntegrationImpl", "isStartupScriptTerminating"));
        }
        return !(startupScript instanceof WebSphereStartupExecutable);
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new WebSphereDeploymentModel(commonModel, source);
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return new WebSphereDeploymentSettingsEditor(commonModel, source);
    }

    private static abstract class TemplateMatcher {
        private TemplateMatcher() {
        }

        public String getMatch(String template) {
            Matcher matcher = TEMPLATE_PATTERN.matcher(template);
            return matcher.matches() ? this.doGetMatch(matcher) : null;
        }

        protected abstract String doGetMatch(Matcher var1);
    }
}

