/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersionUtil;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class WebSphereRunConfigurationEditorBase
extends SettingsEditor<CommonModel>
implements ApplicationServerSelectionListener {
    private WebSphereVersion myVersion;

    protected WebSphereVersion getVersion() {
        return this.myVersion;
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        this.onServerChanged(server);
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
    }

    private void onServerChanged(@Nullable ApplicationServer server) {
        WebSphereVersion version = WebSphereVersionUtil.createVersion(server);
        if (this.myVersion != null && this.myVersion.equals(version)) {
            return;
        }
        this.myVersion = version;
        boolean libertyProfile = this.myVersion != null && this.myVersion.isLibertyProfile();
        for (JComponent component : this.getLibertyExcludedComponents()) {
            component.setVisible(!libertyProfile);
        }
        this.onVersionChanged(server, this.myVersion, libertyProfile);
    }

    protected abstract JComponent[] getLibertyExcludedComponents();

    protected abstract void onVersionChanged(@Nullable ApplicationServer var1, @Nullable WebSphereVersion var2, boolean var3);
}

