/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DbCredentialManagerKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007J!\u0010\n\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J0\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/access/DbCredentialManager;", "", "()V", "createServiceName", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "get", "Lcom/intellij/credentialStore/Credentials;", "getPasswordAsString", "Lorg/jetbrains/annotations/NotNull;", "set", "", "credentials", "memoryOnly", "", "database-impl"})
public final class DbCredentialManager {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public final Credentials get(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe credentialStore = PasswordSafe.getInstance();
        Credentials credentials = credentialStore.get(attributes);
        if (credentials != null) {
            Credentials credentials2 = credentials;
            Credentials it = credentials2;
            return it;
        }
        Logger logger = DbCredentialManagerKt.access$getLOG$p();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = prefix;
            if (string == null) {
                string = DbCredentialManagerKt.access$getDB_PWD$p();
            }
            CredentialAttributes oldKey = CredentialStoreKt.toOldKey(DatabaseCredentials.class, (String)stringBuilder.append(string).append(dataSource.getUniqueId()).toString());
            Credentials credentials3 = credentialStore.get(oldKey);
            if (credentials3 != null) {
                Credentials credentials4 = credentials3;
                Credentials it = credentials4;
                credentialStore.set(oldKey, (Credentials)null);
                Credentials credentials5 = new Credentials(dataSource.getUsername(), it.getPassword());
                credentialStore.set(attributes, credentials5);
                return credentials5;
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            void $receiver$iv;
            $receiver$iv.error(e$iv);
        }
        return null;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Credentials get$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.get(localDataSource, string);
    }

    @JvmOverloads
    @Nullable
    public Credentials get(@NotNull LocalDataSource dataSource) {
        return DbCredentialManager.get$default(this, dataSource, null, 2, null);
    }

    @Nullable
    public final String getPasswordAsString(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        Credentials credentials = this.get(dataSource, prefix);
        return credentials != null ? credentials.getPasswordAsString() : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String getPasswordAsString$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPasswordAsString");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPasswordAsString(localDataSource, string);
    }

    @JvmOverloads
    public final void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean memoryOnly, @Nullable String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dataSource), (String)"dataSource");
        CredentialAttributes attributes = new CredentialAttributes(this.createServiceName(dataSource, prefix), dataSource.getUsername(), null, false, 12, null);
        PasswordSafe.getInstance().set(attributes, credentials, memoryOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void set$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, Credentials credentials, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: set");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        dbCredentialManager.set(localDataSource, credentials, bl, string);
    }

    @JvmOverloads
    public void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials, boolean memoryOnly) {
        DbCredentialManager.set$default(this, dataSource, credentials, memoryOnly, null, 8, null);
    }

    @JvmOverloads
    public void set(@NotNull LocalDataSource dataSource, @Nullable Credentials credentials) {
        DbCredentialManager.set$default(this, dataSource, credentials, false, null, 12, null);
    }

    private final String createServiceName(LocalDataSource dataSource, String prefix) {
        return CredentialAttributesKt.SERVICE_NAME_PREFIX + " DB \u2014 " + (prefix == null ? "" : String.valueOf(prefix)) + dataSource.getUniqueId();
    }
}

