/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.CsvInput;
import com.intellij.database.dbimport.ExistingImportTableEditorWrapper;
import com.intellij.database.dbimport.ImportDialog;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTableEditorWrapper;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportAction
extends DumbAwareAction {
    private static final int MAX_CHARACTERS = 10000;
    private static final int CHAR_COUNT = 0x100000;

    private static void showDataFormatEditorDialog(@NotNull Project project, @NotNull String text, @NotNull String fileName, @NotNull InputType inputType, @NotNull DatabaseDialectEx dialect, @NotNull DbElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (inputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputType", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        Disposable disposable = Disposer.newDisposable();
        ImportType type = ImportType.of(element);
        CsvFormatUISettings settings = ((ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type)))).getSettings();
        CsvFormatsSelectionUI formats = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable, settings);
        CsvFormat selectedFormat = formats.getSelectedFormat();
        TableCsvFormatPreview preview = new TableCsvFormatPreview(project, (CsvFormat)ObjectUtils.assertNotNull((Object)selectedFormat), text, disposable);
        DatabaseEditorContext editorContext = DbRefactoringHelper.createContext((DasObject)element, null);
        if (editorContext == null) {
            return;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        DbNamespaceImpl namespace = DatabaseView.getLowestSchema(element);
        DeNamespace deNamespace = ImportAction.getNamespace(model, namespace);
        boolean created = ((ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type)))).isTableCreated();
        DatabaseEditorCapabilities.TableEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(created);
        ImportEditorContext context = new ImportEditorContext(editorContext, caps, formats, preview, element, model, fileName, (ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type))), disposable, inputType, deNamespace);
        DataGrid grid = preview.getGrid();
        grid.getDataHookup().getLoader().loadFirstPage(new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(grid, null));
        ImportDialog dialog = new ImportDialog(context);
        Disposer.register((Disposable)disposable, (Disposable)dialog.getDisposable());
        dialog.show();
    }

    @Nullable
    private static DeNamespace getNamespace(@NotNull DeModel model, @Nullable DbNamespaceImpl namespace) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction", "getNamespace"));
        }
        return namespace == null ? null : (DeNamespace)model.getExportHelper().exportDeep(namespace.getDataSource().getModel(), (DasObject)namespace, false);
    }

    @NotNull
    private static String loadPartOfFile(@NotNull VirtualFile file) throws IOException {
        String string;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "loadPartOfFile"));
        }
        char[] buffer = new char[10000];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getPath()), file.getCharset()));){
            int count = reader.read(buffer, 0, 10000);
            String string2 = count == -1 ? "" : StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, count));
            string = string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "loadPartOfFile"));
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "update"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(elements);
        boolean isOneElement = elements.size() == 1;
        boolean schemaExists = DatabaseView.getLowestSchema(element) != null;
        boolean canConnect = DbImplUtil.canConnectToAndModify(element);
        boolean hasImportType = element != null && ImportType.of(element) != null;
        e.getPresentation().setEnabledAndVisible(hasImportType && isOneElement && schemaExists && canConnect);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        if (element == null) {
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, file -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "lambda$actionPerformed$0"));
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
            try {
                CsvInputType type = new CsvInputType((VirtualFile)file, 0x100000);
                ImportAction.showDataFormatEditorDialog(project, ImportAction.loadPartOfFile(file), file.getName(), type, dialect, element);
            }
            catch (IOException ex) {
                DataSourceUiUtil.showNotification(e.getProject(), "Can't access file", ex.getMessage(), true);
            }
        });
    }

    private static class CsvInputType
    implements InputType {
        private final VirtualFile myFile;
        private final int myCharCount;

        private CsvInputType(@NotNull VirtualFile file, int charCountToRead) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction$CsvInputType", "<init>"));
            }
            this.myFile = file;
            this.myCharCount = charCountToRead;
        }

        @Override
        @NotNull
        public ReaderTask.Input createInput(@NotNull ImportInfo info) throws IOException {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/actions/ImportAction$CsvInputType", "createInput"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
            CsvInput csvInput = new CsvInput((ThrowableComputable<InputStream, IOException>)((ThrowableComputable)() -> new FileInputStream(this.myFile.getPath())), this.myFile.getCharset(), info, this.myCharCount, this.myFile.getLength());
            if (csvInput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$CsvInputType", "createInput"));
            }
            return csvInput;
        }
    }

    public static interface InputType {
        @NotNull
        public ReaderTask.Input createInput(@NotNull ImportInfo var1) throws IOException;
    }

    public static class ImportEditorContext
    extends DatabaseEditorContext {
        private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
        private final CsvFormatsSelectionUI myFormats;
        private final TableCsvFormatPreview myPreview;
        private final ImportManager myManager;
        private final DbElement myElement;
        private final DeModel myModel;
        private final String myName;
        private final ImportType myType;
        private final Disposable myDisposable;
        private final DeNamespace myNamespace;
        private final List<DbTable> myTables;
        private final InputType myInput;

        ImportEditorContext(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull CsvFormatsSelectionUI formats, @NotNull TableCsvFormatPreview preview, @NotNull DbElement element, @NotNull DeModel model, @NotNull String fileName, @NotNull ImportType type, @NotNull Disposable disposable, @NotNull InputType input, @Nullable DeNamespace namespace) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (formats == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (preview == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            super(context.getProject(), context.getDialect(), context.getModel(), context.getDataSource(), context.getVirtualFile());
            this.myCaps = caps;
            this.myFormats = formats;
            this.myPreview = preview;
            this.myManager = ImportManager.of(context.getDialect(), this.getDataSource() == null ? null : this.getDataSource().getDatabaseProductVersion());
            this.myElement = element;
            this.myModel = model;
            this.myName = fileName;
            this.myType = type;
            this.myDisposable = disposable;
            this.myNamespace = namespace;
            this.myInput = input;
            this.myTables = this.getContextTables();
        }

        @NotNull
        public InputType getInputType() {
            InputType inputType = this.myInput;
            if (inputType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getInputType"));
            }
            return inputType;
        }

        @NotNull
        public DbElement getElement() {
            DbElement dbElement = this.myElement;
            if (dbElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getElement"));
            }
            return dbElement;
        }

        @NotNull
        public TableCsvFormatPreview getPreview() {
            TableCsvFormatPreview tableCsvFormatPreview = this.myPreview;
            if (tableCsvFormatPreview == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getPreview"));
            }
            return tableCsvFormatPreview;
        }

        @NotNull
        public CsvFormatsSelectionUI getFormats() {
            CsvFormatsSelectionUI csvFormatsSelectionUI = this.myFormats;
            if (csvFormatsSelectionUI == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getFormats"));
            }
            return csvFormatsSelectionUI;
        }

        @NotNull
        public ImportType getType() {
            ImportType importType = this.myType;
            if (importType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getType"));
            }
            return importType;
        }

        @Override
        @NotNull
        public DeModel getModel() {
            DeModel deModel = this.myModel;
            if (deModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getModel"));
            }
            return deModel;
        }

        @Nullable
        public DeNamespace getNamespace() {
            return this.myNamespace;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getDisposable"));
            }
            return disposable;
        }

        @NotNull
        public ImportManager getManager() {
            ImportManager importManager = this.myManager;
            if (importManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getManager"));
            }
            return importManager;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getName"));
            }
            return string;
        }

        @NotNull
        public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
            DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
            if (tableEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getCaps"));
            }
            return tableEditorCaps;
        }

        @NotNull
        public String getTableName() {
            String name;
            String result = name = FileUtil.getNameWithoutExtension((String)this.myName);
            int index = 1;
            while (this.isTableExists(result)) {
                result = name + "_" + index++;
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableName"));
            }
            return string;
        }

        public boolean isTableExists(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction$ImportEditorContext", "isTableExists"));
            }
            return ContainerUtil.exists(this.myTables, (Condition)DasUtil.byName((String)name));
        }

        @NotNull
        private List<DbTable> getContextTables() {
            DbNamespaceImpl namespace = DatabaseView.getLowestSchema(this.myElement);
            if (namespace == null || this.myElement instanceof DbTable) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
                }
                return list;
            }
            List list = ((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)namespace)).filter(DbTable.class).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
            }
            return list;
        }

        @NotNull
        public ImportTableEditorWrapper createWrapper() {
            ImportTableEditorWrapper importTableEditorWrapper = this.myType.createTableEditorWrapper(this);
            if (importTableEditorWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "createWrapper"));
            }
            return importTableEditorWrapper;
        }
    }

    public static enum ImportType {
        NEW_TABLE(false){

            @Override
            boolean suitable(@NotNull DbElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportType$1", "suitable"));
                }
                return element.getKind() == ObjectKind.SCHEMA || element.getKind() == ObjectKind.DATABASE || element instanceof DbDataSource;
            }

            @Override
            @NotNull
            ImportTableEditorWrapper createTableEditorWrapper(@NotNull ImportEditorContext context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$ImportType$1", "createTableEditorWrapper"));
                }
                ImportTableEditorWrapper importTableEditorWrapper = new ImportTableEditorWrapper(context);
                if (importTableEditorWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportType$1", "createTableEditorWrapper"));
                }
                return importTableEditorWrapper;
            }

            @Override
            @NotNull
            CsvFormatUISettings getSettings() {
                CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.DEFAULT;
                if (csvFormatUISettings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportType$1", "getSettings"));
                }
                return csvFormatUISettings;
            }
        }
        ,
        EXISTING_TABLE(true){

            @Override
            boolean suitable(@NotNull DbElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportType$2", "suitable"));
                }
                return element.getKind() == ObjectKind.TABLE;
            }

            @Override
            @NotNull
            ImportTableEditorWrapper createTableEditorWrapper(@NotNull ImportEditorContext context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$ImportType$2", "createTableEditorWrapper"));
                }
                ExistingImportTableEditorWrapper existingImportTableEditorWrapper = new ExistingImportTableEditorWrapper(context);
                if (existingImportTableEditorWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportType$2", "createTableEditorWrapper"));
                }
                return existingImportTableEditorWrapper;
            }

            @Override
            @NotNull
            CsvFormatUISettings getSettings() {
                CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.IMPORT_IN_TABLE;
                if (csvFormatUISettings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportType$2", "getSettings"));
                }
                return csvFormatUISettings;
            }
        };

        private final boolean myTableCreated;

        private ImportType(boolean created) {
            this.myTableCreated = created;
        }

        public boolean isTableCreated() {
            return this.myTableCreated;
        }

        @NotNull
        abstract CsvFormatUISettings getSettings();

        @NotNull
        abstract ImportTableEditorWrapper createTableEditorWrapper(@NotNull ImportEditorContext var1);

        abstract boolean suitable(@NotNull DbElement var1);

        @Nullable
        public static ImportType of(@NotNull DbElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportType", "of"));
            }
            for (ImportType type : ImportType.values()) {
                if (!type.suitable(element)) continue;
                return type;
            }
            return null;
        }
    }
}

