/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvRecordFormatForm
implements Disposable {
    private static final List<Couple<String>> DELIMITERS = ContainerUtil.immutableList((Object[])new Couple[]{Couple.of((Object)"Newline", (Object)"\n"), Couple.of((Object)"Tab", (Object)"\t"), Couple.of((Object)"Comma", (Object)","), Couple.of((Object)"Semicolon", (Object)";")});
    private static final List<Pair<String, CsvRecordFormat.QuotationPolicy>> QUOTATION_POLICIES = ContainerUtil.immutableList((Object[])new Pair[]{Pair.create((Object)"When needed", (Object)((Object)CsvRecordFormat.QuotationPolicy.AS_NEEDED)), Pair.create((Object)"Always", (Object)((Object)CsvRecordFormat.QuotationPolicy.ALWAYS))});
    private JPanel myPanel;
    private JBCheckBox myTrimWhitespaceCheckBox;
    private JBTextField myRecordPrefixTextField;
    private JBTextField myRecordSuffixTextField;
    private JBTextField myNullValueTextTextField;
    private ComboBox myValueSeparatorComboBox;
    private ComboBox myRecordSeparatorComboBox;
    private ComboBox myQuotationPolicyComboBox;
    private JPanel myRowPrefixSuffixPanel;
    private ActionLink myAddRowPrefixSuffixActionLink;
    private JPanel myQuotesTablePanel;
    private JBLabel myQuotationLabel;
    private QuotesListTable myQuotesTable;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CsvRecordFormatForm(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvRecordFormatForm", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myQuotesTablePanel.add(DatabaseEditorUtil.labeledDecorator((JComponent)this.myQuotationLabel, this.myQuotesTable.getTable()));
        this.myQuotesTablePanel.setBorder(IdeBorderFactory.createBorder());
        ItemListener fireFormatChangedOnItemUpdate = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        };
        KeyAdapter fireFormatChangedOnKeyRelease = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        };
        CsvRecordFormatForm.prepareComboBox(this.myRecordSeparatorComboBox, DELIMITERS, fireFormatChangedOnItemUpdate, fireFormatChangedOnKeyRelease);
        CsvRecordFormatForm.prepareComboBox(this.myValueSeparatorComboBox, DELIMITERS, fireFormatChangedOnItemUpdate, fireFormatChangedOnKeyRelease);
        CsvRecordFormatForm.prepareComboBox(this.myQuotationPolicyComboBox, QUOTATION_POLICIES, fireFormatChangedOnItemUpdate, fireFormatChangedOnKeyRelease);
        this.myTrimWhitespaceCheckBox.addItemListener(fireFormatChangedOnItemUpdate);
        DocumentAdapter fireFormatChangeOnTextUpdate = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        };
        this.myNullValueTextTextField.getDocument().addDocumentListener((DocumentListener)fireFormatChangeOnTextUpdate);
        this.myRecordPrefixTextField.getDocument().addDocumentListener((DocumentListener)fireFormatChangeOnTextUpdate);
        this.myRecordSuffixTextField.getDocument().addDocumentListener((DocumentListener)fireFormatChangeOnTextUpdate);
        this.setRowPrefixSuffixVisible(false);
    }

    private void createUIComponents() {
        this.myQuotesTable = new QuotesListTable(this);
        this.myQuotesTable.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        });
        this.myAddRowPrefixSuffixActionLink = new ActionLink("", (AnAction)new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                CsvRecordFormatForm.this.setRowPrefixSuffixVisible(true);
            }
        });
        this.myAddRowPrefixSuffixActionLink.setBorder(IdeBorderFactory.createEmptyBorder((int)4, (int)0, (int)0, (int)0));
    }

    public void reset(@NotNull CsvRecordFormat recordFormat) {
        if (recordFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordFormat", "com/intellij/database/csv/ui/CsvRecordFormatForm", "reset"));
        }
        this.myResetting = true;
        try {
            CsvRecordFormatForm.selectInCombo(this.myRecordSeparatorComboBox, DELIMITERS, recordFormat.recordSeparator);
            CsvRecordFormatForm.selectInCombo(this.myValueSeparatorComboBox, DELIMITERS, recordFormat.valueSeparator);
            this.myTrimWhitespaceCheckBox.setSelected(recordFormat.trimWhitespace);
            CsvRecordFormatForm.selectInCombo(this.myQuotationPolicyComboBox, QUOTATION_POLICIES, recordFormat.quotationPolicy);
            this.myQuotesTable.setQuotes((List<CsvRecordFormat.Quotes>)recordFormat.quotes);
            this.myNullValueTextTextField.setText(recordFormat.nullText);
            this.myRecordPrefixTextField.setText(recordFormat.prefix);
            this.myRecordSuffixTextField.setText(recordFormat.suffix);
            this.setRowPrefixSuffixVisible(StringUtil.isNotEmpty((String)recordFormat.prefix) || StringUtil.isNotEmpty((String)recordFormat.suffix));
        }
        finally {
            this.myResetting = false;
            this.fireFormatChanged();
        }
    }

    @NotNull
    public CsvRecordFormat getFormat() {
        String rowSeparator = (String)CsvRecordFormatForm.selectedInCombo(this.myRecordSeparatorComboBox, DELIMITERS);
        String valueSeparator = (String)CsvRecordFormatForm.selectedInCombo(this.myValueSeparatorComboBox, DELIMITERS);
        boolean trimWhitespace = this.myTrimWhitespaceCheckBox.isSelected();
        List<CsvRecordFormat.Quotes> quotes = this.myQuotesTable.getQuotes();
        CsvRecordFormat.QuotationPolicy quotationPolicy = (CsvRecordFormat.QuotationPolicy)((Object)CsvRecordFormatForm.selectedInCombo(this.myQuotationPolicyComboBox, QUOTATION_POLICIES));
        String nullText = this.myNullValueTextTextField.getText();
        String prefix = this.myRecordPrefixTextField.getText();
        String suffix = this.myRecordSuffixTextField.getText();
        CsvRecordFormat csvRecordFormat = new CsvRecordFormat(prefix, suffix, nullText, quotes, quotationPolicy, valueSeparator, rowSeparator, trimWhitespace);
        if (csvRecordFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm", "getFormat"));
        }
        return csvRecordFormat;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm", "getMainPanel"));
        }
        return jPanel;
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/csv/ui/CsvRecordFormatForm", "addChangeListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void dispose() {
    }

    private void fireFormatChanged() {
        if (!this.myResetting) {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).recordFormatChanged(this);
        }
    }

    private void setRowPrefixSuffixVisible(boolean visible) {
        this.myAddRowPrefixSuffixActionLink.setVisible(!visible);
        this.myRowPrefixSuffixPanel.setVisible(visible);
    }

    @NotNull
    private static <T, V, P extends Pair<T, V>> V selectedInCombo(@NotNull ComboBox combobox, @NotNull List<P> mappings) {
        if (combobox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combobox", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectedInCombo"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectedInCombo"));
        }
        Object selected = combobox.isEditable() ? combobox.getEditor().getItem() : combobox.getSelectedItem();
        Pair mapping = (Pair)ContainerUtil.find(mappings, pair -> pair.first.equals(selected));
        Object object = mapping == null ? selected : mapping.second;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectedInCombo"));
        }
        return (V)object;
    }

    private static <V, P extends Pair<?, V>> void selectInCombo(@NotNull ComboBox combo, @NotNull List<P> mappings, @NotNull V what) {
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectInCombo"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectInCombo"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/database/csv/ui/CsvRecordFormatForm", "selectInCombo"));
        }
        Pair mapping = (Pair)ContainerUtil.find(mappings, pair -> {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/database/csv/ui/CsvRecordFormatForm", "lambda$selectInCombo$1"));
            }
            return pair.second.equals(what);
        });
        combo.setSelectedItem(mapping == null ? what : mapping.first);
    }

    private static <T> void prepareComboBox(@NotNull ComboBox combo, @NotNull List<? extends Pair<T, ?>> mappings, @NotNull ItemListener itemListener, @NotNull KeyListener keyListener) {
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "com/intellij/database/csv/ui/CsvRecordFormatForm", "prepareComboBox"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/database/csv/ui/CsvRecordFormatForm", "prepareComboBox"));
        }
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/intellij/database/csv/ui/CsvRecordFormatForm", "prepareComboBox"));
        }
        if (keyListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyListener", "com/intellij/database/csv/ui/CsvRecordFormatForm", "prepareComboBox"));
        }
        combo.setModel((ComboBoxModel)new CollectionComboBoxModel(ContainerUtil.map(mappings, (Function)Functions.pairFirst())));
        combo.addItemListener(itemListener);
        combo.getEditor().getEditorComponent().addKeyListener(keyListener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField2;
        JBTextField jBTextField3;
        JPanel jPanel2;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Value separator:");
        jBLabel2.setDisplayedMnemonic('S');
        jBLabel2.setDisplayedMnemonicIndex(6);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValueSeparatorComboBox = comboBox3 = new ComboBox();
        comboBox3.setEditable(true);
        jPanel3.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Row separator:");
        jBLabel3.setDisplayedMnemonic('R');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordSeparatorComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel3.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 6, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myRowPrefixSuffixPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Row prefix:");
        jBLabel4.setDisplayedMnemonic('X');
        jBLabel4.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordPrefixTextField = jBTextField3 = new JBTextField();
        jBTextField3.setText("");
        jBTextField3.setColumns(3);
        jPanel2.add((Component)jBTextField3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Row suffix:");
        jBLabel5.setDisplayedMnemonic('I');
        jBLabel5.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordSuffixTextField = jBTextField2 = new JBTextField();
        jBTextField2.setText("");
        jBTextField2.setColumns(3);
        jPanel2.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        ActionLink actionLink = this.myAddRowPrefixSuffixActionLink;
        actionLink.setText("Add row prefix/suffix");
        jPanel3.add((Component)actionLink, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTrimWhitespaceCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Trim whitespaces");
        jBCheckBox.setMnemonic('W');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Null value text:");
        jBLabel6.setDisplayedMnemonic('N');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNullValueTextTextField = jBTextField = new JBTextField();
        jBTextField.setColumns(3);
        jPanel3.add((Component)jBTextField, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), null, 0, 0, null, null));
        this.myQuotesTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.myQuotationLabel = jBLabel = new JBLabel();
        jBLabel.setText("Quotation:");
        jPanel.add((Component)jBLabel, "North");
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Quote values:");
        jBLabel7.setDisplayedMnemonic('Q');
        jBLabel7.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuotationPolicyComboBox = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox2);
        jBLabel4.setLabelFor((Component)jBTextField3);
        jBLabel5.setLabelFor((Component)jBTextField2);
        jBLabel6.setLabelFor((Component)jBTextField);
        jBLabel7.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class QuotesListTable
    extends JBListTable {
        private final QuotesTable.QuotesRowRenderer myRenderer;
        private final QuotesTable.QuotesRowEditor myEditor;

        public QuotesListTable(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable", "<init>"));
            }
            super((JTable)((Object)new QuotesTable()), parent);
            this.myRenderer = new QuotesTable.QuotesRowRenderer(parent);
            this.myEditor = new QuotesTable.QuotesRowEditor();
            this.getTable().addPropertyChangeListener("tableCellEditor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TableCellEditor cellEditor = (TableCellEditor)ObjectUtils.tryCast((Object)evt.getNewValue(), TableCellEditor.class);
                    if (cellEditor != null) {
                        myEditor.editingStarted(cellEditor);
                    }
                }
            });
            JComponent c = this.myEditor.getComponent();
            Dimension preferredWidth = new Dimension(c.getPreferredSize().width + UIUtil.getScrollBarWidth(), this.getTable().getRowHeight() * 5);
            this.getTable().setPreferredScrollableViewportSize(preferredWidth);
        }

        @NotNull
        public List<CsvRecordFormat.Quotes> getQuotes() {
            List<CsvRecordFormat.Quotes> list = this.quotesTable().getQuotes();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable", "getQuotes"));
            }
            return list;
        }

        public void setQuotes(@NotNull List<CsvRecordFormat.Quotes> quotes) {
            if (quotes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable", "setQuotes"));
            }
            this.quotesTable().setQuotes(quotes);
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRenderer;
        }

        protected JBTableRowEditor getRowEditor(int row) {
            this.myEditor.prepareEditor(this.myInternalTable, row);
            return new DatabaseEditorUtil.JBTableRowEditorWrapper<QuotesTable.QuotesRowEditor>(this.myEditor){

                public JBTableRow getValue() {
                    return myEditor.getValue();
                }
            };
        }

        @NotNull
        private QuotesTable quotesTable() {
            QuotesTable quotesTable = (QuotesTable)((Object)this.myInternalTable);
            if (quotesTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable", "quotesTable"));
            }
            return quotesTable;
        }

        private static class QuotesTable
        extends JBTable {
            private static final String DUPLICATE_ESCAPE_METHOD = "<duplicate>";
            static final MyColumnInfo LEFT_QUOTE_COLUMN = new MyColumnInfo("left quote", 0);
            static final MyColumnInfo RIGHT_QUOTE_COLUMN = new MyColumnInfo("right quote", 1);
            static final MyColumnInfo ESCAPE_METHOD_COLUMN = new MyColumnInfo("escape method", 2);

            public QuotesTable() {
                super((TableModel)new ListTableModel<String[]>(new ColumnInfo[]{LEFT_QUOTE_COLUMN, RIGHT_QUOTE_COLUMN, ESCAPE_METHOD_COLUMN}){

                    public void addRow() {
                        this.addRow(new String[]{"'", "'", QuotesTable.DUPLICATE_ESCAPE_METHOD});
                    }
                });
            }

            /*
             * Exception decompiling
             */
            public void setQuotes(@NotNull List<CsvRecordFormat.Quotes> quotesList) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public List<CsvRecordFormat.Quotes> getQuotes() {
                List list = ContainerUtil.mapNotNull((Collection)QuotesTable.model((JTable)((Object)this)).getItems(), aspects -> {
                    String left = LEFT_QUOTE_COLUMN.valueOf((String[])aspects);
                    String right = RIGHT_QUOTE_COLUMN.valueOf((String[])aspects);
                    String escapeMethod = ESCAPE_METHOD_COLUMN.valueOf((String[])aspects);
                    if (StringUtil.isEmpty((String)left) || StringUtil.isEmpty((String)right) || StringUtil.isEmpty((String)escapeMethod)) {
                        return null;
                    }
                    return DUPLICATE_ESCAPE_METHOD.equalsIgnoreCase(escapeMethod) ? new CsvRecordFormat.Quotes(left, right, left + left, right + right) : new CsvRecordFormat.Quotes(left, right, escapeMethod + left, escapeMethod + right);
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable", "getQuotes"));
                }
                return list;
            }

            @NotNull
            private static String escapeMethod(@NotNull CsvRecordFormat.Quotes quotes) {
                if (quotes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable", "escapeMethod"));
                }
                String string = StringUtil.equals((CharSequence)(quotes.leftQuote + quotes.leftQuote), (CharSequence)quotes.leftQuoteEscaped) && StringUtil.equals((CharSequence)(quotes.rightQuote + quotes.rightQuote), (CharSequence)quotes.rightQuoteEscaped) ? DUPLICATE_ESCAPE_METHOD : StringUtil.trimEnd((String)quotes.leftQuoteEscaped, (String)quotes.leftQuote);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable", "escapeMethod"));
                }
                return string;
            }

            @NotNull
            private static ListTableModel<String[]> model(@NotNull JTable t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable", "model"));
                }
                ListTableModel listTableModel = (ListTableModel)t.getModel();
                if (listTableModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable", "model"));
                }
                return listTableModel;
            }

            private static class MyColumnInfo
            extends ColumnInfo<String[], String> {
                private final int myIndex;

                public MyColumnInfo(@NotNull String name, int index) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$MyColumnInfo", "<init>"));
                    }
                    super(name);
                    this.myIndex = index;
                }

                @Nullable
                public String valueOf(String[] aspects) {
                    return aspects[this.myIndex];
                }

                public void setValue(String[] strings, String value) {
                    strings[this.myIndex] = value;
                }
            }

            static class QuotesRowEditor
            extends DatabaseEditorUtil.EmbeddableEditorAdapter {
                private JPanel myPanel;
                private JBTextField myLeftQuoteTextField;
                private JBTextField myRightQuoteTextField;
                private ComboBox myEscapeMethodComboBox;

                public QuotesRowEditor() {
                    this.$$$setupUI$$$();
                    this.myLeftQuoteTextField.setColumns(4);
                    this.myRightQuoteTextField.setColumns(4);
                    this.myEscapeMethodComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{QuotesTable.DUPLICATE_ESCAPE_METHOD}));
                    this.myEscapeMethodComboBox.setEditable(true);
                }

                @Override
                @NotNull
                public JComponent getComponent() {
                    JPanel jPanel = this.myPanel;
                    if (jPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor", "getComponent"));
                    }
                    return jPanel;
                }

                void prepareEditor(JTable table, int row) {
                    String[] aspects = (String[])QuotesTable.model(table).getItem(row);
                    this.myLeftQuoteTextField.setText(LEFT_QUOTE_COLUMN.valueOf(aspects));
                    this.myRightQuoteTextField.setText(RIGHT_QUOTE_COLUMN.valueOf(aspects));
                    this.myEscapeMethodComboBox.setSelectedItem((Object)ESCAPE_METHOD_COLUMN.valueOf(aspects));
                }

                JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            switch (column) {
                                case 0: {
                                    return myLeftQuoteTextField.getText();
                                }
                                case 1: {
                                    return myRightQuoteTextField.getText();
                                }
                                case 2: {
                                    return myEscapeMethodComboBox.getEditor().getItem();
                                }
                            }
                            throw new AssertionError();
                        }
                    };
                }

                @Override
                @NotNull
                public JComponent getPreferredFocusedComponent() {
                    JBTextField jBTextField = this.myLeftQuoteTextField;
                    if (jBTextField == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor", "getPreferredFocusedComponent"));
                    }
                    return jBTextField;
                }

                @Override
                @NotNull
                public JComponent[] getFocusableComponents() {
                    JComponent[] jComponentArray = new JComponent[]{this.myLeftQuoteTextField, this.myRightQuoteTextField, this.myEscapeMethodComboBox};
                    if (jComponentArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor", "getFocusableComponents"));
                    }
                    return jComponentArray;
                }

                void editingStarted(@NotNull TableCellEditor editor) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor", "editingStarted"));
                    }
                    ComboBox.registerTableCellEditor((JComboBox)this.myEscapeMethodComboBox, (TableCellEditor)editor);
                }

                private /* synthetic */ void $$$setupUI$$$() {
                    ComboBox comboBox;
                    JBTextField jBTextField;
                    JBTextField jBTextField2;
                    JPanel jPanel;
                    this.myPanel = jPanel = new JPanel();
                    jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
                    JBLabel jBLabel = new JBLabel();
                    jBLabel.setText("Left:");
                    jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
                    Spacer spacer = new Spacer();
                    jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
                    this.myLeftQuoteTextField = jBTextField2 = new JBTextField();
                    jPanel.add((Component)jBTextField2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
                    JBLabel jBLabel2 = new JBLabel();
                    jBLabel2.setText("Right:");
                    jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
                    this.myRightQuoteTextField = jBTextField = new JBTextField();
                    jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
                    JBLabel jBLabel3 = new JBLabel();
                    jBLabel3.setText("Escape:");
                    jPanel.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
                    this.myEscapeMethodComboBox = comboBox = new ComboBox();
                    jPanel.add((Component)comboBox, new GridConstraints(1, 2, 1, 1, 0, 1, 2, 0, null, null, null));
                }

                public /* synthetic */ JComponent $$$getRootComponent$$$() {
                    return this.myPanel;
                }
            }

            static class QuotesRowRenderer
            extends EditorTextFieldJBTableRowRenderer {
                protected QuotesRowRenderer(@NotNull Disposable parent) {
                    if (parent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowRenderer", "<init>"));
                    }
                    super(null, null, parent);
                }

                protected String getText(JTable table, int row) {
                    String[] aspects = (String[])QuotesTable.model(table).getItem(row);
                    String escapeMethod = ESCAPE_METHOD_COLUMN.valueOf(aspects);
                    String escapeMethodText = QuotesTable.DUPLICATE_ESCAPE_METHOD.equals(escapeMethod) ? "Escape: duplicate" : "Escape with: " + escapeMethod;
                    String leftQuoteText = LEFT_QUOTE_COLUMN.valueOf(aspects);
                    String rightQuoteText = RIGHT_QUOTE_COLUMN.valueOf(aspects);
                    return StringUtil.join((String[])new String[]{leftQuoteText, rightQuoteText, escapeMethodText}, (String)"  ");
                }
            }
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void recordFormatChanged(@NotNull CsvRecordFormatForm var1);
    }
}

