/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.ConverterSupport;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataConverter<V, T> {
    private static final List<DataConverter<?, ?>> ourValues = ContainerUtil.newArrayList();
    private final PointSet<V> myStart;
    private final PointSet<T> myEnd;

    protected DataConverter(@NotNull PointSet<V> start, @NotNull PointSet<T> end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/data/types/DataConverter", "<init>"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/database/data/types/DataConverter", "<init>"));
        }
        this.myStart = start;
        this.myEnd = end;
        ConversionGraph.register(this);
    }

    @Nullable
    public final T convert(@Nullable V value) {
        return value == null ? null : (T)this.notNull(value);
    }

    @Nullable
    public final V convertReverse(@Nullable T value) {
        return value == null ? null : (V)this.reverseNotNull(value);
    }

    @Nullable
    protected abstract V reverseNotNull(@NotNull T var1);

    @Nullable
    protected abstract T notNull(@NotNull V var1);

    @NotNull
    public PointSet<V> getStart() {
        PointSet<V> pointSet = this.myStart;
        if (pointSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataConverter", "getStart"));
        }
        return pointSet;
    }

    @NotNull
    public PointSet<T> getEnd() {
        PointSet<T> pointSet = this.myEnd;
        if (pointSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataConverter", "getEnd"));
        }
        return pointSet;
    }

    public static void init() {
        if (!ourValues.isEmpty()) {
            return;
        }
        ourValues.addAll(ContainerUtil.list((Object[])new DataConverter[]{new TimestampToTemporal(), new TimeToTemporal(), new TimeZonedTimeToTemporal(), new TimeZonedTimestampToTemporal(), new BinaryTextToText(), new BinaryToText(), new BooleanToBinary(), new BooleanToNumber(), new BooleanToText(), new DateToNumber(), new DateToText(), new DateToTimestamp(), new NumberToText(), new NumberToTimestamp(), new TimestampToText(), new TimeToNumber(), new TimeToText(), new TemporalTimeToTemporalTimestamp(), new UuidToText(), new ObjectToText(), new NumberRangeToText(), new DateRangeToText(), new TimestampRangeToText(), new MoneyToText()}));
    }

    public static class DateRangeToText
    extends DataConverter<String, String> {
        public DateRangeToText() {
            super(PointSet.DATE_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$DateRangeToText", "reverseNotNull"));
            }
            try {
                return (String)ConverterSupport.getDateRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$DateRangeToText", "notNull"));
            }
            return value;
        }
    }

    public static class TimestampRangeToText
    extends DataConverter<String, String> {
        public TimestampRangeToText() {
            super(PointSet.TIMESTAMP_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimestampRangeToText", "reverseNotNull"));
            }
            try {
                return (String)ConverterSupport.getTimestampRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimestampRangeToText", "notNull"));
            }
            return value;
        }
    }

    public static class NumberRangeToText
    extends DataConverter<String, String> {
        public NumberRangeToText() {
            super(PointSet.NUMBER_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$NumberRangeToText", "reverseNotNull"));
            }
            try {
                return (String)ConverterSupport.getNumberRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$NumberRangeToText", "notNull"));
            }
            return value;
        }
    }

    public static class UuidToText
    extends DataConverter<String, String> {
        protected UuidToText() {
            super(PointSet.UUID, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$UuidToText", "reverseNotNull"));
            }
            try {
                return UUID.fromString(value).toString();
            }
            catch (Exception exception) {
                return UUID.randomUUID().toString();
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$UuidToText", "notNull"));
            }
            return value;
        }
    }

    public static class ObjectToText
    extends DataConverter<Object, String> {
        protected ObjectToText() {
            super(PointSet.UNKNOWN, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected Object reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$ObjectToText", "reverseNotNull"));
            }
            return value;
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$ObjectToText", "notNull"));
            }
            return value.toString();
        }
    }

    public static class TimeZonedTimestampToTemporal
    extends DataConverter<TimeZonedTimestamp, TemporalAccessor> {
        public TimeZonedTimestampToTemporal() {
            super(PointSet.TIMESTAMP_WITH_TIMEZONE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TimeZonedTimestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeZonedTimestampToTemporal", "reverseNotNull"));
            }
            return new TimeZonedTimestamp(Timestamp.valueOf(LocalDateTime.from(value)), ConverterSupport.getTimestampFormatter().format(value));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTimestamp value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeZonedTimestampToTemporal", "notNull"));
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimestampFormatter().parse(value.getStringRepresentation());
            }
            catch (Exception exception) {
                Timestamp timestamp = (Timestamp)value.getValue();
                ZoneOffset offset = value.getZoneOffset();
                LocalDateTime time = timestamp.toLocalDateTime();
                return offset == null ? time : time.atOffset(OffsetDateTime.now().getOffset()).withOffsetSameInstant(offset);
            }
        }
    }

    public static class TimeZonedTimeToTemporal
    extends DataConverter<TimeZonedTime, TemporalAccessor> {
        public TimeZonedTimeToTemporal() {
            super(PointSet.TIME_WITH_TIMEZONE, PointSet.TEMPORAL_TIME);
        }

        @Override
        @Nullable
        protected TimeZonedTime reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeZonedTimeToTemporal", "reverseNotNull"));
            }
            return new TimeZonedTime(Time.valueOf(value instanceof LocalTime ? (LocalTime)value : ((OffsetTime)value).withOffsetSameInstant(OffsetTime.now().getOffset()).toLocalTime()), ConverterSupport.getTimeFormatter().format(value));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTime value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeZonedTimeToTemporal", "notNull"));
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimeFormatter().parse(value.getStringRepresentation());
            }
            catch (Exception exception) {
                return DataGridFormattersUtil.convert(value);
            }
        }
    }

    public static class TemporalTimeToTemporalTimestamp
    extends DataConverter<TemporalAccessor, TemporalAccessor> {
        public TemporalTimeToTemporalTimestamp() {
            super(PointSet.TEMPORAL_TIME, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TemporalTimeToTemporalTimestamp", "notNull"));
            }
            LocalDate date = LocalDate.of(1, 1, 1);
            return data instanceof OffsetTime ? ((OffsetTime)data).atDate(date) : ((LocalTime)data).atDate(date);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TemporalTimeToTemporalTimestamp", "reverseNotNull"));
            }
            return data instanceof OffsetDateTime ? ((OffsetDateTime)data).toOffsetTime() : ((LocalDateTime)data).toLocalTime();
        }
    }

    public static class TimeToText
    extends DataConverter<TemporalAccessor, String> {
        public TimeToText() {
            super(PointSet.TEMPORAL_TIME, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimeToText", "notNull"));
            }
            return ConverterSupport.getTimeFormatter().format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimeToText", "reverseNotNull"));
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimeFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public static class TimeToNumber
    extends DataConverter<TemporalAccessor, Number> {
        public TimeToNumber() {
            super(PointSet.TEMPORAL_TIME, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimeToNumber", "notNull"));
            }
            LocalTime from = LocalTime.from(data);
            return Time.valueOf(from).getTime();
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull Number data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimeToNumber", "reverseNotNull"));
            }
            return new Time(data.longValue()).toLocalTime();
        }
    }

    public static class TimestampToText
    extends DataConverter<TemporalAccessor, String> {
        public TimestampToText() {
            super(PointSet.TEMPORAL_TIMESTAMP, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimestampToText", "notNull"));
            }
            return ConverterSupport.getTimestampFormatter().format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$TimestampToText", "reverseNotNull"));
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimestampFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public static class TimestampToTemporal
    extends DataConverter<Timestamp, TemporalAccessor> {
        public TimestampToTemporal() {
            super(PointSet.TIMESTAMP, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected Timestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimestampToTemporal", "reverseNotNull"));
            }
            return Timestamp.valueOf(value instanceof OffsetDateTime ? ((OffsetDateTime)value).withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime() : (LocalDateTime)value);
        }

        @Override
        @Nullable
        public TemporalAccessor notNull(@NotNull Timestamp value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimestampToTemporal", "notNull"));
            }
            return value.toLocalDateTime();
        }
    }

    public static class TimeToTemporal
    extends DataConverter<Time, TemporalAccessor> {
        public TimeToTemporal() {
            super(PointSet.TIME, PointSet.TEMPORAL_TIME);
        }

        @Override
        @Nullable
        protected Time reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeToTemporal", "reverseNotNull"));
            }
            return Time.valueOf(value instanceof OffsetTime ? ((OffsetTime)value).withOffsetSameInstant(ZoneOffset.UTC).toLocalTime() : (LocalTime)value);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Time value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$TimeToTemporal", "notNull"));
            }
            return value.toLocalTime();
        }
    }

    public static class NumberToTimestamp
    extends DataConverter<Number, TemporalAccessor> {
        public NumberToTimestamp() {
            super(PointSet.NUMBER, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Number data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$NumberToTimestamp", "notNull"));
            }
            long l = data.longValue();
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault());
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$NumberToTimestamp", "reverseNotNull"));
            }
            return data instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)data).getTime() : Timestamp.valueOf(((OffsetDateTime)data).toLocalDateTime()).getTime();
        }
    }

    public static class MoneyToText
    extends DataConverter<Number, String> {
        private static final DecimalFormat FORMAT = new DecimalFormat();

        public MoneyToText() {
            super(PointSet.MONEY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$MoneyToText", "reverseNotNull"));
            }
            if (value.length() == 0) {
                return null;
            }
            try {
                return FORMAT.parse(value);
            }
            catch (Exception exception) {
                return MoneyToText.parseCurrency(value);
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$MoneyToText", "notNull"));
            }
            return value.toString();
        }

        @Nullable
        private static Number parseCurrency(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$MoneyToText", "parseCurrency"));
            }
            try {
                return FORMAT.parse(value.substring(1));
            }
            catch (Exception exception) {
                return null;
            }
        }

        static {
            FORMAT.setParseBigDecimal(true);
        }
    }

    public static class NumberToText
    extends DataConverter<Number, String> {
        public NumberToText() {
            super(PointSet.NUMBER, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$NumberToText", "notNull"));
            }
            return data.toString();
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$NumberToText", "reverseNotNull"));
            }
            try {
                return Double.parseDouble(data);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public static class DateToTimestamp
    extends DataConverter<java.util.Date, TemporalAccessor> {
        public DateToTimestamp() {
            super(PointSet.DATE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToTimestamp", "reverseNotNull"));
            }
            return Date.valueOf(LocalDate.from(data));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull java.util.Date data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToTimestamp", "notNull"));
            }
            return data instanceof Date ? ((Date)data).toLocalDate().atTime(0, 0, 0) : LocalDateTime.ofInstant(Instant.ofEpochMilli(data.getTime()), ZoneId.systemDefault());
        }
    }

    public static class DateToText
    extends DataConverter<java.util.Date, String> {
        public DateToText() {
            super(PointSet.DATE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull java.util.Date data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToText", "notNull"));
            }
            return ConverterSupport.getDateFormatter().format(data);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToText", "reverseNotNull"));
            }
            try {
                return (java.util.Date)ConverterSupport.getDateFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public static class DateToNumber
    extends DataConverter<java.util.Date, Number> {
        public DateToNumber() {
            super(PointSet.DATE, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull java.util.Date data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToNumber", "notNull"));
            }
            return data.getTime();
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull Number data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$DateToNumber", "reverseNotNull"));
            }
            return new java.util.Date(data.longValue());
        }
    }

    public static class BooleanToText
    extends DataConverter<Boolean, String> {
        public BooleanToText() {
            super(PointSet.BOOLEAN, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Boolean data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BooleanToText", "notNull"));
            }
            return String.valueOf(data);
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BooleanToText", "reverseNotNull"));
            }
            return StringUtil.findIgnoreCase((String)data, (String[])new String[]{"yes", "true", "1"});
        }
    }

    public static class BooleanToNumber
    extends DataConverter<Boolean, Number> {
        public BooleanToNumber() {
            super(PointSet.BOOLEAN, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull Boolean data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BooleanToNumber", "notNull"));
            }
            return data != false ? 1 : 0;
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull Number data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BooleanToNumber", "reverseNotNull"));
            }
            return Double.compare(data.doubleValue(), 1.0) >= 0;
        }
    }

    public static class BooleanToBinary
    extends DataConverter<Boolean, byte[]> {
        public BooleanToBinary() {
            super(PointSet.BOOLEAN, PointSet.BINARY);
        }

        @Override
        @Nullable
        protected byte[] notNull(@NotNull Boolean data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BooleanToBinary", "notNull"));
            }
            return new byte[]{data != false ? (byte)1 : 0};
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull byte[] bytes) {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/data/types/DataConverter$BooleanToBinary", "reverseNotNull"));
            }
            return bytes[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    public static class BinaryToText
    extends DataConverter<byte[], String> {
        public BinaryToText() {
            super(PointSet.BINARY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull byte[] data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BinaryToText", "notNull"));
            }
            ObjectFormatter.TextInfo info = ObjectFormatter.tryDetectString(data);
            return info == null ? new String(data, StandardCharsets.UTF_8) : info.text;
        }

        @Override
        @Nullable
        protected byte[] reverseNotNull(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/data/types/DataConverter$BinaryToText", "reverseNotNull"));
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class BinaryTextToText
    extends DataConverter<String, String> {
        public BinaryTextToText() {
            super(PointSet.BINARY_STRING, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String text) {
            byte[] bytes;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/data/types/DataConverter$BinaryTextToText", "reverseNotNull"));
            }
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes = text.getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                int aByte;
                int intValue = aByte = byArray[j];
                for (int i2 = 0; i2 < 8; ++i2) {
                    sb.append((intValue & 0x80) == 0 ? 0 : 1);
                    intValue <<= 1;
                }
            }
            return sb.toString();
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/data/types/DataConverter$BinaryTextToText", "notNull"));
            }
            List<String> strings = BinaryTextToText.split(value);
            if (strings.isEmpty()) {
                return value;
            }
            try {
                StringBuilder sb = new StringBuilder();
                for (String string : strings) {
                    sb.append((char)Integer.parseInt(string, 2));
                }
                return sb.toString();
            }
            catch (Exception exception) {
                return value;
            }
        }

        @NotNull
        private static List<String> split(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/data/types/DataConverter$BinaryTextToText", "split"));
            }
            ArrayList strings = ContainerUtil.newArrayList();
            for (int currentIdx = 0; currentIdx < s.length(); currentIdx += 8) {
                String substring = s.substring(currentIdx, Math.min(s.length(), currentIdx + 8));
                strings.add(substring);
            }
            ArrayList arrayList = strings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/DataConverter$BinaryTextToText", "split"));
            }
            return arrayList;
        }
    }
}

