/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FractionDomain
extends Domain {
    private final Cardinality.FractionCardinality myCardinality;
    private final int myDefaultValue;
    private final boolean myNarrowable;
    private final int myMax;

    public FractionDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, int max) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        this(name, descriptor, type, max, -1, false);
    }

    public FractionDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, int myMax, int defaultValue, boolean narrowable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/domain/FractionDomain", "<init>"));
        }
        super(descriptor, type, name);
        this.myMax = myMax;
        this.myCardinality = new Cardinality.FractionCardinality(myMax);
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/FractionDomain", "getCompatibility"));
        }
        Compatibility compatibility = (domain instanceof FractionDomain || domain instanceof SimpleDomain) && this.getLogicType().getSuitability(domain.getLogicType()) > 0 ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible();
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/FractionDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/FractionDomain", "trim"));
        }
        return o;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.FractionCardinality fractionCardinality = this.myCardinality;
        if (fractionCardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/FractionDomain", "cardinality"));
        }
        return fractionCardinality;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/FractionDomain", "narrow"));
        }
        FractionDomain fractionDomain = this.myNarrowable && domain instanceof FractionDomain ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), Math.min(((FractionDomain)domain).getMax(), this.getMax()), this.myDefaultValue, true) : (this.myNarrowable && domain instanceof SimpleDomain && domain.getDomainType() == this.getDomainType() ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), this.myDefaultValue, this.myDefaultValue, true) : this);
        if (fractionDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/FractionDomain", "narrow"));
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/FractionDomain", "narrow"));
        }
        FractionDomain fractionDomain = this.myNarrowable ? new FractionDomain(this.simpleName(), this.getPoint(), this.getDomainType(), provider.getScale(), this.myDefaultValue, true) : this;
        if (fractionDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/FractionDomain", "narrow"));
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.getMax() == this.myDefaultValue || !this.myNarrowable || this.getMax() <= 0 ? super.name() : this.simpleName() + "(" + this.getMax() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/FractionDomain", "name"));
        }
        return string;
    }

    private int getMax() {
        return this.myMax;
    }
}

