/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.NumberDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.Db2Dialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Domains
extends DomainRegistry {
    private static final short MAX_DB2_GRAPHIC = 127;
    private static final short MAX_VARGRAPHIC = 16336;
    private static final short MAX_DECIMAL_PRECISION = 31;
    private static final double MIN_DOUBLE = -7.2E75;
    private static final double MAX_DOUBLE = 7.2E75;
    private static final int DB2_MAX_TS_PRECISION = 12;
    private static final int MAX_VARCHAR_LENGTH = 32704;
    private static final int DBCLOB = 0x3FFFFFFF;

    public Db2Domains() {
        super(Db2Dialect.INSTANCE);
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new TextDomain("vargraphic", ConversionPoint.TEXT_GRAPHIC, 16336L, -1L, true));
        this.add(new TextDomain("graphic", ConversionPoint.TEXT_GRAPHIC, 127L, -1L, true));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 12, -1, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 32704L, -1L, true));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("dbclob", ConversionPoint.CLOB, 0x3FFFFFFFL, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 127L, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 127L, -1L, true));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new DecfloatDomain(34));
    }

    private static class DecfloatDomain
    extends NumberDomain {
        private static final int DEFAULT_DIGITS = 16;
        private static final int MAX_DIGITS = 34;
        private static final DomainRegistry.Limits LIMITS = new DomainRegistry.Limits(new DomainRegistry.Limit(16, 384, 384), new DomainRegistry.Limit(34, 6143, 6143));
        private final int myDigits;

        protected DecfloatDomain(int digits) {
            super("decfloat", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE);
            this.myDigits = digits;
        }

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality.ScalableCardinality scalableCardinality = new Cardinality.ScalableCardinality(this.myDigits);
            if (scalableCardinality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "cardinality"));
            }
            return scalableCardinality;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "narrow"));
            }
            DecfloatDomain decfloatDomain = domain instanceof Number2Domain ? new DecfloatDomain(LIMITS.minParameterValue(((Number2Domain)domain).getMaxPrecision()).intValue()) : (domain instanceof NumberDomain ? new DecfloatDomain(34) : this);
            if (decfloatDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "narrow"));
            }
            return decfloatDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "narrow"));
            }
            DecfloatDomain decfloatDomain = new DecfloatDomain(LIMITS.minParameterValue(provider.getSize()).intValue());
            if (decfloatDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "narrow"));
            }
            return decfloatDomain;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "getCompatibility"));
            }
            Compatibility compatibility = domain instanceof DecfloatDomain ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof Number2Domain || domain instanceof NumberDomain ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible());
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "getCompatibility"));
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "trim"));
            }
            return o;
        }

        @Override
        @NotNull
        public String name() {
            String string = super.name() + (this.myDigits == 16 ? "" : String.format("(%s)", this.myDigits));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/Db2Domains$DecfloatDomain", "name"));
            }
            return string;
        }
    }
}

