/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OraNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.OracleDialect;

public class OracleDomains
extends DomainRegistry {
    private static final int MAX_CHAR = 2000;
    private static final int MAX_RAW = 2000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_FRACTION = 9;
    private static final int MAX_VARCHAR = 4000;

    public OracleDomains() {
        super(OracleDialect.INSTANCE);
        this.add(new BinaryDomain("raw", ConversionPoint.BINARY, 2000L, -1L, true));
        this.add(new BinaryDomain("long raw", ConversionPoint.BINARY, Integer.MAX_VALUE));
        this.add(new BinaryDomain("urowid", ConversionPoint.BINARY_ID, 4000L));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new OraNumber2Domain("number", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new OraNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, 1.4E-45f, 3.4028234663852886E38));
        this.add(new FloatDomain("binary_float", ConversionPoint.SINGLE_PRECISION, 1.4E-45f, 3.4028234663852886E38));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FractionDomain("date", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 0));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9, -1, true));
        this.add(new TextDomain("nclob", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("long", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("rowid", ConversionPoint.TEXT_ID, 2000L));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 4000L, -1L, true));
        this.add(new TextDomain("varchar2", ConversionPoint.VARCHAR, 4000L, -1L, true));
        this.add(new TextDomain("nvarchar2", ConversionPoint.NVARCHAR, 2000L, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 2000L, -1L, true));
        this.add(new TextDomain("nchar", ConversionPoint.NCHAR, 1000L, -1L, true));
        this.add(new TextDomain("sys.xmltype", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new TextDomain("xmltype", ConversionPoint.XML, Integer.MAX_VALUE));
    }
}

