/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.SybaseDialect;

public class SybaseDomains
extends DomainRegistry {
    private static final double MAX_FLOAT = 1.0E307;
    private static final double MIN_FLOAT = -1.0E308;
    private static final int MONEY_SCALE = 4;
    private static final int MAX_VARCHAR = 16384;
    private static final int MAX_UNIVARCHAR = 8192;
    private static final int SMALLMONEY_PRECISION = 10;
    private static final int MAX_PRECISION = 126;
    private static final int MONEY_PRECISION = 19;
    private static final int MAX_TS_FRACTION = 6;

    public SybaseDomains() {
        super(SybaseDialect.INSTANCE);
        this.add(new IntegerDomain("unsigned bigint", ConversionPoint.NUMBER, 0.0, 9.223372036854776E18));
        this.add(new IntegerDomain("ubigint", ConversionPoint.NUMBER, 0.0, 9.223372036854776E18));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 16384L, -1L, true));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, 16384L, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 16384L, -1L, true));
        this.add(new TextDomain("univarchar", ConversionPoint.NVARCHAR, 8192L, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 8192L, -1L, true));
        this.add(new TextDomain("unichar", ConversionPoint.NCHAR, 8192L, -1L, true));
        this.add(new TextDomain("nchar", ConversionPoint.NCHAR, 8192L, -1L, true));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new Number2Domain("smallmoney", ConversionPoint.MONEY, 10, 4, false));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 126, 126, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 126, 126, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 19, 4, false));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E308, 1.0E307));
        this.add(new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 16384L, -1L, true));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 16384L, -1L, true));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE));
        this.add(new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6));
    }
}

