/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsEditor;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private static final String SCHEMA_LOADING_ERROR = "SCHEMA_LOADING_ERROR";
    private static final String ASTERISK = "*";
    private final DataSourceConfigurable myDialog;
    private JPanel myRootPanel;
    private JPanel myTablePanel;
    private JBCheckBox myLegacyIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private DataSourceOptionsEditor myOptionsPanel;
    private JPanel myOptionsPanelComponent;
    private ComboBox mySourceLoading;
    private JPanel mySourceLoadingPanel;
    private final TreeTable mySchemasTable;
    private final JBLoadingPanel myLoadingPanel;
    private final DefaultsInstaller myDefaultsInstaller;
    private Object mySavedKey;
    @NotNull
    private MultiMap<String, String> myAllSchemaNames;
    private static final DataKey<DataSourceOptionsPanel> OPTIONS_PANEL = DataKey.create((String)"OPTIONS_PANEL");
    private static final DefaultActionGroup TABLE_POPUP = new DefaultActionGroup(new AnAction[]{new AnAction("Refresh", "Refresh Schemas", AllIcons.Actions.Refresh){

        public void actionPerformed(AnActionEvent e) {
            DataSourceOptionsPanel panel = (DataSourceOptionsPanel)OPTIONS_PANEL.getData(e.getDataContext());
            if (panel == null) {
                return;
            }
            panel.refreshSchemas(panel.getTitle(), true);
        }
    }});

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/dataSource/DataSourceOptionsPanel", "<init>"));
        }
        this.myAllSchemaNames = new MultiMap();
        this.myDialog = dialog;
        this.myOptionsPanel = new DataSourceOptionsEditor(dialog);
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), this.myDialog){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, size.height / 3 * 2);
            }
        };
        EventDispatcher myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
        final CheckboxTreeHelper helper = new CheckboxTreeHelper(CheckboxTreeHelper.DEFAULT_POLICY, myEventDispatcher);
        this.mySchemasTable = new TreeTableView(this.emptyModel()){

            public void setModel(TreeTableModel treeTableModel) {
                super.setModel(treeTableModel);
                helper.initTree((Tree)this.getTree(), (JComponent)((Object)this), new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

                    public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        if (value instanceof CheckedTreeNode) {
                            ColoredTreeCellRenderer renderer = this.getTextRenderer();
                            renderer.append(value.toString());
                            this.getCheckbox().setSelected(((CheckedTreeNode)value).isChecked());
                            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)DataSourceOptionsPanel.this.mySchemasTable, (SimpleColoredComponent)renderer, (boolean)false, (boolean)selected);
                        }
                    }
                });
                this.getTree().setRootVisible(true);
            }
        };
        this.$$$setupUI$$$();
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DBIntrospectionOptions.SourceLoading>(){

            public void customize(JList list, DBIntrospectionOptions.SourceLoading value, int index, boolean selected, boolean hasFocus) {
                String text = "None";
                if (value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES) {
                    text = "All schemas";
                }
                if (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                    text = "Except system schemas";
                }
                this.setText(text);
            }
        });
        this.mySourceLoadingPanel.setVisible(DbSrcStorage.isEnabled());
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myLoadingPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.mySchemasTable));
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        this.myTablePanel.add((Component)this.myLoadingPanel, "Center");
        LocalDataSource dataSource = (LocalDataSource)((Object)this.myDialog.getDataSource());
        this.myDefaultsInstaller = new DefaultsInstaller(dataSource);
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getTablePattern()));
        this.myObjectFilterHelp.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null).run();
            }
        });
        this.myLegacyIntrospector.setVisible(DBIntrospectorFactory.hasModerIntrospector(GenericIntrospectorLegacyModelUtils.findRdbms(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource))));
        this.myLegacyIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
        this.myDefaultsInstaller.setIntrospectionScope(dataSource.getIntrospectionScope());
        this.myDefaultsInstaller.setDefaultSchemas(dataSource.getResolveScope());
        this.setupTableView();
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSourceOptionsPanel", "setSourceLoading"));
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    @NotNull
    private ListTreeTableModelOnColumns emptyModel() {
        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns(null, this.getColumns());
        if (listTreeTableModelOnColumns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "emptyModel"));
        }
        return listTreeTableModelOnColumns;
    }

    @NotNull
    private ColumnInfo[] getColumns() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TreeColumnInfo(this.getTitle()), new ResolveColumnInfo()};
        if (columnInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getColumns"));
        }
        return columnInfoArray;
    }

    private void setupTableView() {
        new TreeTableSpeedSearch(this.mySchemasTable);
        boolean visible = !this.getNamespaces().isEmpty();
        this.mySchemasTable.setVisible(visible);
        this.mySchemasTable.setSelectionMode(0);
        this.mySchemasTable.setCellSelectionEnabled(true);
        this.mySchemasTable.getEmptyText().setText("");
        if (!visible) {
            return;
        }
        PopupHandler.installPopupHandler((JComponent)this.mySchemasTable, (ActionGroup)TABLE_POPUP, (String)"unknown", (ActionManager)ActionManager.getInstance());
        DataManager.registerDataProvider((JComponent)this.mySchemasTable, dataId -> OPTIONS_PANEL.getName().equals(dataId) ? this : null);
        new UiNotifyConnector((Component)this.myRootPanel, new Activatable(){

            public void showNotify() {
                ApplicationManager.getApplication().invokeLater(() -> DataSourceOptionsPanel.this.refreshSchemas(DataSourceOptionsPanel.this.getTitle(), false));
            }

            public void hideNotify() {
            }
        });
    }

    @NotNull
    private String getTitle() {
        String string = StringUtil.join(this.getNamespaces(), kind -> StringUtil.capitalize((String)StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)kind, (DatabaseDialect)this.getDialect()))), (String)" and ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getTitle"));
        }
        return string;
    }

    @NotNull
    private Set<ObjectKind> getNamespaces() {
        Set set = this.getDialect().getMetaModel().getNamespaces();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getNamespaces"));
        }
        return set;
    }

    @NotNull
    private DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect((RawConnectionConfig)this.myDialog.getDataSource()), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "getDialect"));
        }
        return databaseDialectEx;
    }

    public void refreshSchemas(String columnTitle, boolean force) {
        boolean emptyProps;
        LocalDataSource tempDataSource = this.myDialog.getTempDataSourceForConnection();
        boolean bl = emptyProps = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl());
        if (emptyProps) {
            this.mySchemasTable.setModel((TreeTableModel)this.emptyModel());
            this.mySchemasTable.getEmptyText().setText("No " + columnTitle);
            return;
        }
        Object newSavedUrl = this.myDialog.createKey(tempDataSource);
        if (!force && Comparing.equal((Object)this.mySavedKey, (Object)newSavedUrl)) {
            return;
        }
        this.mySchemasTable.getEmptyText().setText("");
        this.mySavedKey = newSavedUrl;
        Ref currentCatalogRef = Ref.create();
        ModalityState state = ModalityState.current();
        Project project = this.myDialog.getProject();
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Connection connection;
            Ref connecting;
            Ref exRef;
            block9: {
                exRef = Ref.create(null);
                connecting = Ref.create((Object)true);
                connection = null;
                connection = tempDataSource.getConnection(project);
                if (connection != null) break block9;
                Runnable runnable = new Runnable(tempDataSource, exRef, columnTitle, connecting){
                    final /* synthetic */ LocalDataSource val$tempDataSource;
                    final /* synthetic */ Ref val$exRef;
                    final /* synthetic */ String val$columnTitle;
                    final /* synthetic */ Ref val$connecting;
                    {
                        this.val$tempDataSource = localDataSource;
                        this.val$exRef = ref;
                        this.val$columnTitle = string;
                        this.val$connecting = ref2;
                    }

                    @Override
                    public void run() {
                        if (Disposer.isDisposed((Disposable)DataSourceOptionsPanel.this.myDialog)) {
                            return;
                        }
                        if (!Comparing.equal((Object)DataSourceOptionsPanel.this.mySavedKey, (Object)DataSourceOptionsPanel.this.myDialog.createKey(this.val$tempDataSource))) {
                            return;
                        }
                        DataSourceOptionsPanel.this.myLoadingPanel.stopLoading();
                        Exception ex = this.val$exRef.get() instanceof ProcessCanceledException ? null : (Exception)this.val$exRef.get();
                        String emptyText = ex == null ? "No " + this.val$columnTitle + " Found" : "Error Loading " + this.val$columnTitle;
                        DataSourceOptionsPanel.this.mySchemasTable.getEmptyText().setText(emptyText);
                        if (this.val$tempDataSource.getFirstSync() == ThreeState.YES) {
                            this.val$tempDataSource.setFirstSync(ThreeState.NO);
                        }
                        DataSourceOptionsPanel.this.mySchemasTable.setModel(this.createModel((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames));
                        if (ex != null) {
                            String msg;
                            if (((Boolean)this.val$connecting.get()).booleanValue()) {
                                ErrorHandler handler = new ErrorHandler();
                                LocalDataSource.handleConnectionError(ex, handler, DataSourceOptionsPanel.this.myDialog.getNameValue());
                                msg = handler.hasErrors() ? handler.getSummary() : null;
                            } else {
                                msg = JdbcEngine.getErrorMessage(ex, DataSourceOptionsPanel.this.myDialog.getNameValue(), DbImplUtil.getDatabaseDialect(this.val$tempDataSource).getFamilyId());
                            }
                            UIUtil.invokeLaterIfNeeded(() -> DataSourceOptionsPanel.this.myDialog.getController().showErrorNotification((Configurable)DataSourceOptionsPanel.this.myDialog, DataSourceOptionsPanel.SCHEMA_LOADING_ERROR, "Error", msg, new Object[0]));
                        } else {
                            DataSourceOptionsPanel.this.myDialog.updateDatabaseInfo(this.val$tempDataSource);
                            DataSourceOptionsPanel.this.myDialog.showErrorNotification(null, DataSourceOptionsPanel.SCHEMA_LOADING_ERROR);
                        }
                    }

                    @NotNull
                    private TreeTableModel createModel(@NotNull MultiMap<String, String> schemas) {
                        if (schemas == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/dataSource/DataSourceOptionsPanel$5", "createModel"));
                        }
                        if (schemas.isEmpty()) {
                            ListTreeTableModelOnColumns listTreeTableModelOnColumns = DataSourceOptionsPanel.this.emptyModel();
                            if (listTreeTableModelOnColumns == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel$5", "createModel"));
                            }
                            return listTreeTableModelOnColumns;
                        }
                        boolean singleRoot = DataSourceOptionsPanel.this.getNamespaces().size() == 1;
                        MyCheckedTreeNode root2 = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK));
                        for (Map.Entry e : schemas.entrySet()) {
                            String database = (String)e.getKey();
                            if (DataSourceOptionsPanel.ASTERISK.equals(database) && ((Collection)e.getValue()).size() == 1 && DataSourceOptionsPanel.ASTERISK.equals(ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())))) continue;
                            MyCheckedTreeNode db = new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)DataSourceOptionsPanel.ASTERISK), true);
                            if (!singleRoot) {
                                root2.add((MutableTreeNode)((Object)db));
                            }
                            for (String schema : (Collection)e.getValue()) {
                                if (!DataSourceOptionsPanel.realName(schema)) continue;
                                (singleRoot ? root2 : db).add((MutableTreeNode)((Object)new MyCheckedTreeNode((Couple<String>)Couple.of((Object)database, (Object)schema))));
                            }
                        }
                        ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns((TreeNode)((Object)root2), DataSourceOptionsPanel.this.getColumns());
                        if (listTreeTableModelOnColumns == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel$5", "createModel"));
                        }
                        return listTreeTableModelOnColumns;
                    }
                };
                if (!project.isOpen()) return;
                tempDataSource.releaseConnection(project, connection);
                ApplicationManager.getApplication().invokeLater(runnable, state);
                return;
            }
            try {
                connecting.set((Object)false);
                this.myAllSchemaNames = this.loadSchemaNamesAndSetIntrospectionScopeByDefault(connection, (LocalDataSource)((Object)((Object)this.myDialog.getDataSource())));
                DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(tempDataSource);
                if (dialect.getFamilyId().isMysql()) {
                    boolean toInvert = true;
                    MultiMap inverted = MultiMap.createLinked();
                    for (Map.Entry entry : this.myAllSchemaNames.entrySet()) {
                        Collection db = (Collection)entry.getValue();
                        if (db.isEmpty()) continue;
                        if (!JBIterable.from((Iterable)db).filter(x -> DataSourceOptionsPanel.realName(x)).isEmpty()) {
                            toInvert = false;
                            break;
                        }
                        inverted.putValue((Object)ASTERISK, entry.getKey());
                    }
                    if (toInvert) {
                        this.myAllSchemaNames = inverted;
                    }
                }
                Case casing = dialect.getCasing(ObjectKind.SCHEMA, null).choose(true);
                this.myDefaultsInstaller.setupIntrospectionScopeByDefault(connection, casing.apply(this.myDialog.getUserName()));
                currentCatalogRef.set((Object)connection.getCatalog());
            }
            catch (Exception e) {
                try {
                    exRef.set((Object)e);
                }
                catch (Throwable throwable) {
                    Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                    if (!project.isOpen()) throw throwable;
                    tempDataSource.releaseConnection(project, connection);
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                    throw throwable;
                }
                Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                if (!project.isOpen()) return;
                tempDataSource.releaseConnection(project, connection);
                ApplicationManager.getApplication().invokeLater(runnable, state);
                return;
            }
            Runnable runnable = new /* invalid duplicate definition of identical inner class */;
            if (!project.isOpen()) return;
            tempDataSource.releaseConnection(project, connection);
            ApplicationManager.getApplication().invokeLater(runnable, state);
            return;
        });
    }

    private static boolean realName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && !ASTERISK.equals(name);
    }

    @NotNull
    public MultiMap<String, String> loadSchemaNamesAndSetIntrospectionScopeByDefault(@NotNull Connection connection, @NotNull LocalDataSource dataSource) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        DatabaseMetaData metaData = connection.getMetaData();
        dataSource.refreshDatabaseInfo(metaData);
        MultiMap result = MultiMap.createLinkedSet();
        DatabaseMetaDataWrapper meta = DatabaseMetaDataWrapper.create(connection, metaData, new ErrorHandler(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(meta.schemas(true))) {
            result.putValue((Object)StringUtil.notNullize((String)schema.database), (Object)StringUtil.notNullize((String)schema.schema));
        }
        for (String d : result.keySet()) {
            result.putValue((Object)d, (Object)ASTERISK);
        }
        result.putValue((Object)ASTERISK, (Object)ASTERISK);
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceOptionsPanel", "loadSchemaNamesAndSetIntrospectionScopeByDefault"));
        }
        return multiMap;
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceOptionsPanel", "saveData"));
        }
        dataSource.setIntrospectionScope(this.myDefaultsInstaller.getIntrospectionScope());
        dataSource.setResolveScope(this.myDefaultsInstaller.getDefaultSchemas());
        dataSource.setTablePattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myLegacyIntrospector.isSelected());
        dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        this.myOptionsPanel.saveData(dataSource);
    }

    public void reset(LocalDataSource source) {
        this.myOptionsPanel.reset(source);
        this.mySourceLoading.setSelectedItem((Object)source.getSourceLoading());
        this.myDefaultsInstaller.setIntrospectionScope(source.getIntrospectionScope());
        this.myDefaultsInstaller.setDefaultSchemas(source.getResolveScope());
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor(s -> JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        StyleSheet sheet = ((HTMLDocument)this.myObjectFilterHelp.getDocument()).getStyleSheet();
        sheet.addRule("a { color: #" + ColorUtil.toHex((Color)UI.getColor((String)"link.foreground")) + " }");
        sheet.addRule("ol { margin: 0px; padding-left: 10px; padding-bottom: 4px; list-style-type:none; }");
        sheet.addRule(UIUtil.displayPropertiesToCSS((Font)JBUI.Fonts.smallFont(), (Color)UIUtil.getLabelDisabledForeground()));
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol>  <li>&lt;type&gt; is a <b>table</b>, <b>view</b>, <b>mview</b>, <b>sequence</b>, <b>routine</b>, <b>package</b> or <b>synonym</b>,</li>  <li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion.</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b></html>");
        this.myObjectFilterHelp.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)4, (int)4));
        this.myOptionsPanelComponent = this.myOptionsPanel.getComponent();
    }

    @Nullable
    private static Couple<String> databaseAndSchema(@NotNull DefaultMutableTreeNode o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DataSourceOptionsPanel", "databaseAndSchema"));
        }
        return (Couple)ObjectUtils.tryCast((Object)o.getUserObject(), Couple.class);
    }

    public static boolean containsSchema(@NotNull DefaultMutableTreeNode c, @NotNull DefaultsInstaller defaultsInstaller) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/dataSource/DataSourceOptionsPanel", "containsSchema"));
        }
        if (defaultsInstaller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultsInstaller", "com/intellij/database/dataSource/DataSourceOptionsPanel", "containsSchema"));
        }
        return defaultsInstaller.getIntrospectionScope().containsSchema(DataSourceOptionsPanel.databaseAndSchema(c));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel4.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, new Dimension(150, 50), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = this.myOptionsPanelComponent;
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myLegacyIntrospector = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Introspect using JDBC metadata");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(22);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySourceLoadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Load sources for");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class ResolveColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, Boolean> {
        private BooleanTableCellRenderer myRenderer;
        private BooleanTableCellEditor myEditor;

        public ResolveColumnInfo() {
            super("Resolve Unqualified References");
            this.myRenderer = new BooleanTableCellRenderer(2);
            this.myEditor = new BooleanTableCellEditor(false, 2);
        }

        @Nullable
        public Boolean valueOf(@NotNull DefaultMutableTreeNode c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/dataSource/DataSourceOptionsPanel$ResolveColumnInfo", "valueOf"));
            }
            return DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().containsSchema((Couple<String>)DataSourceOptionsPanel.databaseAndSchema(c));
        }

        public boolean isCellEditable(@NotNull DefaultMutableTreeNode c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/dataSource/DataSourceOptionsPanel$ResolveColumnInfo", "isCellEditable"));
            }
            return true;
        }

        public void setValue(@NotNull DefaultMutableTreeNode c, Boolean value) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/dataSource/DataSourceOptionsPanel$ResolveColumnInfo", "setValue"));
            }
            Couple couple = DataSourceOptionsPanel.databaseAndSchema(c);
            if (couple == null) {
                return;
            }
            String first = (String)couple.first;
            String second = (String)couple.second;
            MultiMap<String, String> map = DataSourceOptionsPanel.this.myDefaultsInstaller.getDefaultSchemas().applyToContext((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames);
            if (Boolean.TRUE.equals(value)) {
                map.putValue((Object)first, (Object)second);
            } else {
                map.remove((Object)first, (Object)second);
                map.remove((Object)first, (Object)DataSourceOptionsPanel.ASTERISK);
                map.remove((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK);
                if (DataSourceOptionsPanel.ASTERISK.equals(first) && DataSourceOptionsPanel.ASTERISK.equals(second)) {
                    map.clear();
                }
                if (DataSourceOptionsPanel.ASTERISK.equals(second)) {
                    map.remove((Object)first);
                }
            }
            DataSourceOptionsPanel.this.myDefaultsInstaller.setDefaultSchemas(IntrospectionScopes.collapse(map));
            DataSourceOptionsPanel.this.mySchemasTable.revalidate();
            DataSourceOptionsPanel.this.mySchemasTable.repaint();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode o) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(DefaultMutableTreeNode o) {
            return this.myEditor;
        }
    }

    private class MyCheckedTreeNode
    extends CheckedTreeNode {
        private final boolean myDb;

        public MyCheckedTreeNode(Couple<String> s) {
            this(s, false);
        }

        public MyCheckedTreeNode(Couple<String> s, boolean db) {
            super(s);
            this.myDb = db;
        }

        public boolean isChecked() {
            return DataSourceOptionsPanel.containsSchema((DefaultMutableTreeNode)((Object)this), DataSourceOptionsPanel.this.myDefaultsInstaller);
        }

        public void setChecked(boolean checked) {
            Couple couple = DataSourceOptionsPanel.databaseAndSchema((DefaultMutableTreeNode)((Object)this));
            if (couple == null) {
                return;
            }
            String first = (String)couple.first;
            String second = (String)couple.second;
            MultiMap<String, String> map = DataSourceOptionsPanel.this.myDefaultsInstaller.getIntrospectionScope().applyToContext((MultiMap<String, String>)DataSourceOptionsPanel.this.myAllSchemaNames);
            if (checked) {
                map.putValue((Object)first, (Object)second);
            } else {
                map.remove((Object)first, (Object)second);
                map.remove((Object)first, (Object)DataSourceOptionsPanel.ASTERISK);
                map.remove((Object)DataSourceOptionsPanel.ASTERISK, (Object)DataSourceOptionsPanel.ASTERISK);
            }
            DataSourceOptionsPanel.this.myDefaultsInstaller.setIntrospectionScope(IntrospectionScopes.collapse(map));
        }

        public String toString() {
            Couple t = (Couple)ObjectUtils.tryCast((Object)this.getUserObject(), Couple.class);
            return t == null ? super.toString() : (this.myDb ? (String)t.first : (String)t.second);
        }
    }
}

