/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcChangesBrowser
extends ChangesBrowser {
    private static final Logger LOG = Logger.getInstance(DbSrcChangesBrowser.class);
    public static final ChangeNodeDecorator MY_DECORATOR = new ChangeNodeDecorator(){

        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) {
                return;
            }
            VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(revision.getFile().getPath());
            if (file == null) {
                return;
            }
            DasObject object = DbSrcUtils.findObject(file, false);
            if (object == null) {
                return;
            }
            component.setIcon(DbPresentation.getIcon((DasObject)object));
        }

        @Nullable
        public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
            return null;
        }

        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }
    };

    public DbSrcChangesBrowser(Project project) {
        super(project, DbSrcChangesTracker.getInstance(project).getChangeLists(), Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.setChangesToDisplay(this.getTrackedChanges());
        DbSrcChangesTracker.getInstance(project).addListener((ModificationTrackerListener<DbSrcChangesTracker>)((ModificationTrackerListener)source -> UIUtil.invokeLaterIfNeeded(() -> this.setChangesToDisplay(this.getTrackedChanges()))), (Disposable)this);
    }

    @NotNull
    public List<Change> getTrackedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)JBIterable.from(DbSrcChangesTracker.getInstance(this.myProject).getChangeLists()).flatten(DbSrcChangesTracker.DbSrcChangeList::getChanges).toList());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser", "getTrackedChanges"));
        }
        return arrayList;
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, showFlatten){

            protected ChangesBrowserChangeListNode createChangeListNode(final @NotNull ChangeList list, List<Change> changes) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2", "createChangeListNode"));
                }
                ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
                return new ChangesBrowserChangeListNode(DbSrcChangesBrowser.this.myProject, list, listRemoteState){

                    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                        LocalDataSource dataSource;
                        super.render(renderer, selected, expanded, hasFocus);
                        DbSrcChangesTracker.DbSrcChangeList changeList = (DbSrcChangesTracker.DbSrcChangeList)ObjectUtils.tryCast((Object)list, DbSrcChangesTracker.DbSrcChangeList.class);
                        LocalDataSource localDataSource = dataSource = changeList == null ? null : changeList.getDataSource();
                        if (dataSource != null) {
                            renderer.setIcon(dataSource.getBaseIcon());
                        }
                    }
                };
            }

            @Nullable
            protected ChangesBrowserNode createPathNode(final StaticFilePath parentPath) {
                Boolean res = DbSrcFileSystem.processPath(parentPath.getPath(), new DbSrcFileSystem.ItemProcessor<Boolean>(){

                    @Override
                    public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                        if (dataSourceId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$2", "processFile"));
                        }
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$2", "processFile"));
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String kind) {
                        if (dataSourceId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$2", "processFolder"));
                        }
                        return Boolean.TRUE;
                    }
                });
                if (!Boolean.TRUE.equals(res)) {
                    return null;
                }
                return new ChangesBrowserFilePathNode(VcsContextFactory.SERVICE.getInstance().createFilePath(parentPath.getPath(), true)){

                    @NotNull
                    protected String getRelativePath(FilePath path) {
                        String result;
                        FilePath parent = 3.safeCastToFilePath((Object)((ChangesBrowserNode)this.getParent()).getUserObject());
                        Iterable<String> items = parent == null ? DbSrcFileSystem.processPath(parentPath.getPath(), new DbSrcFileSystem.ItemProcessor<Iterable<String>>(){

                            @Override
                            public Iterable<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                                if (dataSourceId == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$3$1", "processFolder"));
                                }
                                ArrayList names = path == null ? Collections.emptyList() : ContainerUtil.newArrayList(path.names());
                                return group2 == null ? names : ContainerUtil.append((List)names, (Object[])new String[]{group2});
                            }

                            @Override
                            public Iterable<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                                if (dataSourceId == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$3$1", "processFile"));
                                }
                                if (path == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$3$1", "processFile"));
                                }
                                return path.names();
                            }
                        }) : ((result = FileUtil.getRelativePath((String)parent.getPath(), (String)path.getPath(), (char)'/', (boolean)true)) == null ? null : DbSrcFileSystem.splitPath(result));
                        String string = items == null ? path.getPath() : StringUtil.join(items, (String)".");
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser$2$3", "getRelativePath"));
                        }
                        return string;
                    }

                    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
                        super.render(renderer, selected, expanded, hasFocus);
                        FilePath path = (FilePath)ObjectUtils.tryCast((Object)this.userObject, FilePath.class);
                        if (path != null) {
                            DasObject object;
                            VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(path.getPath());
                            DasObject dasObject = object = file == null ? null : DbSrcUtils.findObject(file, false);
                            if (object != null) {
                                renderer.setIcon(DbPresentation.getIcon((DasObject)object));
                            }
                        }
                    }
                };
            }

            protected ChangesBrowserNode createChangeListChild(RemoteRevisionsCache revisionsCache, ChangesBrowserChangeListNode node, List<Change> changes, int i2) {
                return this.createChangeNode(changes.get(i2), MY_DECORATOR);
            }
        };
        DefaultTreeModel defaultTreeModel = builder.setChangeLists(ContainerUtil.filter(DbSrcChangesTracker.getInstance(this.myProject).getChangeLists(), c -> !c.getChanges().isEmpty())).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser", "buildTreeModel"));
        }
        return defaultTreeModel;
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        super.buildToolBar(toolBarGroup);
        DumbAwareAction revertAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                Stream<VirtualFile> files = DbSrcChangesBrowser.this.getSelectedFiles();
                e.getPresentation().setEnabled(files.findAny().isPresent());
            }

            public void actionPerformed(AnActionEvent e) {
                Stream<VirtualFile> files = DbSrcChangesBrowser.this.getSelectedFiles();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        DbSrcUtils.removeFromStorage(files.collect(Collectors.toList()), true);
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
            }
        };
        ActionUtil.copyFrom((AnAction)revertAction, (String)"ChangesView.Revert");
        revertAction.registerCustomShortcutSet((JComponent)this.myViewer, null);
        toolBarGroup.add((AnAction)revertAction);
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
        Stream<VirtualFile> stream = this.getSelectedChanges().stream().map(c -> {
            ContentRevision revision = c.getAfterRevision();
            return revision == null ? null : dbFs.findFileByPath(revision.getFile().getPath());
        }).filter(Objects::nonNull);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesBrowser", "getSelectedFiles"));
        }
        return stream;
    }
}

