/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GridFilteringModelImpl
implements GridFilteringModel {
    private final EventDispatcher<GridFilteringModel.Listener> myEventDispatcher;
    private final DatabaseTableGridDataHookUp myHookUp;
    private final List<String> myHistory;
    private boolean myApplied;
    private boolean myEnabled;
    private Document myDocument;

    public GridFilteringModelImpl(@NotNull Document document, @NotNull DatabaseTableGridDataHookUp hookUp) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/GridFilteringModelImpl", "<init>"));
        }
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/datagrid/GridFilteringModelImpl", "<init>"));
        }
        this.myEventDispatcher = EventDispatcher.create(GridFilteringModel.Listener.class);
        this.myHistory = ContainerUtil.newArrayList();
        this.myDocument = document;
        this.myHookUp = hookUp;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myEnabled;
    }

    @Override
    public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/GridFilteringModelImpl", "applyFilter"));
        }
        String text = this.getFilterText().trim();
        boolean empty = StringUtil.isEmpty((String)text);
        if (!empty) {
            this.myHistory.remove(text);
            this.myHistory.add(0, text);
            this.trimFilterHistory();
        }
        this.myApplied = !empty;
        this.myHookUp.getLoader().applyFilter(source);
    }

    @Override
    public void onError() {
        this.myHistory.remove(this.getFilterText());
        this.myApplied = false;
    }

    private void trimFilterHistory() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        int historySize = Math.max(0, settings.getFiltersHistorySize());
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    @Override
    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/database/datagrid/GridFilteringModelImpl", "setHistory"));
        }
        this.myHistory.clear();
        this.myHistory.addAll(history);
        this.trimFilterHistory();
    }

    @Override
    @NotNull
    public List<String> getHistory() {
        List<String> list = this.myHistory;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridFilteringModelImpl", "getHistory"));
        }
        return list;
    }

    @Override
    public void setFilteringEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @NotNull
    public String getFilterText() {
        String string = this.myDocument.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridFilteringModelImpl", "getFilterText"));
        }
        return string;
    }

    @Override
    public void setFilterText(@NotNull String filter) {
        boolean valueChanged;
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/datagrid/GridFilteringModelImpl", "setFilterText"));
        }
        String newFilter = filter.trim();
        String currentFilter = this.getFilterText();
        boolean bl = valueChanged = !Comparing.equal((String)currentFilter, (String)newFilter);
        if (!valueChanged) {
            return;
        }
        this.myApplied = false;
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/datagrid/GridFilteringModelImpl", "lambda$setFilterText$0"));
            }
            this.myDocument.setText((CharSequence)filter);
        });
    }

    @Override
    public boolean isFilterApplied() {
        return this.myApplied;
    }

    @Override
    @NotNull
    public Document getFilterDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridFilteringModelImpl", "getFilterDocument"));
        }
        return document;
    }

    @Override
    public void addListener(@NotNull GridFilteringModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/GridFilteringModelImpl", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/GridFilteringModelImpl", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    void setDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/GridFilteringModelImpl", "setDocument"));
        }
        this.myDocument = document;
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).filterDocumentChanged(this);
    }
}

