/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnUpdateData;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RowMutation
implements Comparable<RowMutation> {
    private final DataConsumer.Row myRow;
    private final List<ColumnUpdateData> myData;

    public RowMutation(@NotNull DataConsumer.Row row, @NotNull List<ColumnUpdateData> data) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/mutating/RowMutation", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/datagrid/mutating/RowMutation", "<init>"));
        }
        this.myRow = row;
        this.myData = ContainerUtil.sorted(data);
    }

    @NotNull
    public RowMutation merge(@Nullable RowMutation mutation) {
        RowMutation rowMutation = mutation == null ? this : new RowMutation(this.myRow, ContainerUtil.concat(this.myData, mutation.myData));
        if (rowMutation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/RowMutation", "merge"));
        }
        return rowMutation;
    }

    @NotNull
    public List<ColumnUpdateData> getData() {
        List<ColumnUpdateData> list = this.myData;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/RowMutation", "getData"));
        }
        return list;
    }

    @NotNull
    public DataConsumer.Row getRow() {
        DataConsumer.Row row = this.myRow;
        if (row == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/RowMutation", "getRow"));
        }
        return row;
    }

    @Override
    public int compareTo(@NotNull RowMutation o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/datagrid/mutating/RowMutation", "compareTo"));
        }
        return Integer.compare(this.myRow.rowNum, o.myRow.rowNum);
    }
}

