/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BatchRecords {
    public static final BatchRecords POISON = new BatchRecords(ContainerUtil.emptyList(), 0.0);
    private final List<Object[]> myRecords;
    private final double myBytes;

    public BatchRecords(@NotNull List<Object[]> records, double bytes) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/BatchRecords", "<init>"));
        }
        this.myRecords = records;
        this.myBytes = bytes;
    }

    @NotNull
    List<Object[]> getRecords() {
        List<Object[]> list = this.myRecords;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/BatchRecords", "getRecords"));
        }
        return list;
    }

    int getLineCount() {
        return this.myRecords.size();
    }

    double getBatchSize() {
        return this.myBytes;
    }

    public boolean isEmpty() {
        return ((List)ObjectUtils.assertNotNull(this.myRecords)).isEmpty();
    }
}

