/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.BatchRecords;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInput
implements ReaderTask.Input {
    private static final int MAX_RECORD_SIZE = 0x100000;
    private final ImportInfo myInfo;
    private final ThrowableComputable<InputStream, IOException> myStream;
    private final Charset myCharset;
    private final int myMaxCharCount;
    private final int myCharCountToRead;
    private final long mySizeInBytes;
    private final double myBytesPerChar;
    private BufferedReader myReader;
    private CsvFormatParser myParser;
    private String myUnparsedText;

    public CsvInput(@NotNull ThrowableComputable<InputStream, IOException> stream, @NotNull Charset charset, @NotNull ImportInfo info, int charCountToRead, long bytes) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dbimport/CsvInput", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/CsvInput", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/CsvInput", "<init>"));
        }
        this.myStream = stream;
        this.myBytesPerChar = charset.newEncoder().averageBytesPerChar();
        this.myCharset = charset;
        this.myParser = new CsvFormatParser(info.getFormat());
        this.myCharCountToRead = charCountToRead;
        this.myMaxCharCount = charCountToRead + 0x100000;
        this.myInfo = info;
        this.mySizeInBytes = bytes;
        this.myUnparsedText = "";
    }

    @Override
    @Nullable
    public BatchRecords read() throws ReaderTask.BigRecordException, InterruptedException, IOException {
        if (this.myReader == null) {
            this.myReader = new BufferedReader(new InputStreamReader((InputStream)this.myStream.compute(), this.myCharset));
        }
        BatchRecords batch = BatchRecords.POISON;
        String text = "";
        CsvDocumentDataHookUp.CsvMarkup markup = null;
        while (batch.isEmpty()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            text = this.getText(this.myReader);
            if (text == null) {
                return null;
            }
            text = this.myUnparsedText + text;
            if (text.length() >= this.myMaxCharCount) {
                throw new ReaderTask.BigRecordException();
            }
            markup = this.myParser.parse(text);
            batch = this.getBatch(markup);
            if (!batch.isEmpty()) continue;
            this.myUnparsedText = text;
        }
        CsvDocumentDataHookUp.CsvRecord lastRecord = (CsvDocumentDataHookUp.CsvRecord)ContainerUtil.getLastItem(((CsvDocumentDataHookUp.CsvMarkup)ObjectUtils.assertNotNull(markup)).getRecords());
        int end = ((CsvDocumentDataHookUp.CsvRecord)ObjectUtils.assertNotNull((Object)lastRecord)).range.getEndOffset();
        this.myUnparsedText = text.substring(Math.min(text.length(), end));
        if (this.myParser.getDataFormat().headerRecord != null) {
            this.myParser = CsvInput.createParserWithoutHeader(this.myInfo);
        }
        return batch;
    }

    @Override
    public double getSizeOfData() {
        return this.mySizeInBytes;
    }

    @Override
    public void close() {
        if (this.myReader == null) {
            return;
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static CsvFormatParser createParserWithoutHeader(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/CsvInput", "createParserWithoutHeader"));
        }
        CsvFormat format = info.getFormat();
        CsvFormat withoutHeader = new CsvFormat(format.dataRecord, null, format.rowNumbers);
        CsvFormatParser csvFormatParser = new CsvFormatParser(withoutHeader);
        if (csvFormatParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/CsvInput", "createParserWithoutHeader"));
        }
        return csvFormatParser;
    }

    @NotNull
    private BatchRecords getBatch(@Nullable CsvDocumentDataHookUp.CsvMarkup markup) {
        if (markup == null) {
            BatchRecords batchRecords = BatchRecords.POISON;
            if (batchRecords == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/CsvInput", "getBatch"));
            }
            return batchRecords;
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        long chars = 0L;
        for (DataConsumer.Row row : markup.rows) {
            ArrayList line = ContainerUtil.newArrayList();
            for (DataConsumer.Column column : markup.columns) {
                String value = (String)column.getValue(row);
                if (value != null) {
                    chars += (long)value.length();
                }
                line.add(value);
            }
            parameters.add(ArrayUtil.toStringArray((Collection)line));
        }
        BatchRecords batchRecords = new BatchRecords(parameters, (double)chars * this.myBytesPerChar);
        if (batchRecords == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/CsvInput", "getBatch"));
        }
        return batchRecords;
    }

    @Nullable
    private String getText(@NotNull BufferedReader myReader) throws IOException {
        int character;
        if (myReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myReader", "com/intellij/database/dbimport/CsvInput", "getText"));
        }
        char[] buffer = new char[this.myCharCountToRead];
        int count = myReader.read(buffer);
        if (count == -1) {
            return null;
        }
        if (count == 0) {
            return "";
        }
        String lastChar = String.valueOf(buffer[count - 1]);
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, count)));
        while (!this.isRecordSeparator(lastChar) && (character = myReader.read()) != -1) {
            lastChar = StringUtil.convertLineSeparators((String)String.valueOf((char)character));
            sb.append(lastChar);
            if (sb.length() < this.myMaxCharCount) continue;
            throw new ReaderTask.BigRecordException();
        }
        return sb.toString();
    }

    private boolean isRecordSeparator(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/dbimport/CsvInput", "isRecordSeparator"));
        }
        String recordSeparator = this.myParser.getDataFormat().dataRecord.recordSeparator;
        return StringUtil.equals((CharSequence)string, (CharSequence)recordSeparator);
    }
}

