/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DataImporter {
    private static final Set<DasTable> ourBusyTables = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final DbElement myElement;
    private final ReaderTask.Input myInput;
    private final ImportInfo myInfo;

    public DataImporter(@NotNull Project project, @NotNull DbElement element, @NotNull ReaderTask.Input input, @Nullable ImportInfo info) throws FileNotFoundException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/DataImporter", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/DataImporter", "<init>"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/DataImporter", "<init>"));
        }
        this.myProject = project;
        this.myElement = element;
        this.myInput = input;
        this.myInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData() {
        if (this.myInfo == null) {
            return;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(this.myElement);
        DbDataSource dataSource = this.myElement.getDataSource();
        ImportSettings.store(this.myInfo, dialect, dataSource.getDatabaseProductVersion());
        this.lockTable();
        boolean shouldUnlock = true;
        try {
            DbNamespaceImpl namespace = DatabaseView.getLowestSchema(this.myElement);
            ImportDatabaseModifier modifier = new ImportDatabaseModifier(dataSource, this.myInfo, this.myProject, dialect, this.myInput, namespace);
            modifier.getContext().include(this.myElement);
            modifier.getContext().setElementToFocus(this.myElement instanceof DbTable ? null : this.myInfo.getTable());
            Promise<Void> callback = modifier.runStatements(false);
            callback.processed(p -> this.unlockTable());
            shouldUnlock = false;
        }
        catch (IOException e) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Can't access to file.", NotificationType.ERROR).notify(this.myProject);
        }
        finally {
            if (shouldUnlock) {
                this.unlockTable();
            }
        }
    }

    private void lockTable() {
        if (!((ImportInfo)ObjectUtils.assertNotNull((Object)this.myInfo)).shouldLockTable()) {
            return;
        }
        if (this.myElement instanceof DasTable) {
            ourBusyTables.add((DasTable)this.myElement);
        }
    }

    private void unlockTable() {
        if (!((ImportInfo)ObjectUtils.assertNotNull((Object)this.myInfo)).shouldLockTable()) {
            return;
        }
        if (this.myElement instanceof DasTable) {
            ourBusyTables.remove((DasTable)this.myElement);
        }
    }

    public static boolean isBusy(@Nullable Object element) {
        DasTable table = DataImporter.getElement(element);
        return table != null && ourBusyTables.contains(table);
    }

    private static DasTable getElement(@Nullable Object element) {
        return element instanceof DasTableChild ? ((DasTableChild)element).getTable() : (element instanceof DasTable ? (DasTable)element : null);
    }
}

