/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.PreparedBatchQuery;
import com.intellij.database.dbimport.Query;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExecuteBatchQuery
implements Query {
    @NotNull
    private final List<PreparedBatchQuery> myAllQueries;
    @NotNull
    private final PreparedStatement myStatement;
    @NotNull
    private final TransactionStateHolder myHolder;
    @NotNull
    private final ImportInfo myInfo;
    @NotNull
    private final ImportManager myManager;

    ExecuteBatchQuery(@NotNull List<PreparedBatchQuery> allQueries, @NotNull PreparedStatement statement, @NotNull TransactionStateHolder holder, @NotNull ImportInfo info, @NotNull ImportManager manager) {
        if (allQueries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allQueries", "com/intellij/database/dbimport/ExecuteBatchQuery", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/ExecuteBatchQuery", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ExecuteBatchQuery", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ExecuteBatchQuery", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ExecuteBatchQuery", "<init>"));
        }
        this.myAllQueries = allQueries;
        this.myStatement = statement;
        this.myHolder = holder;
        this.myInfo = info;
        this.myManager = manager;
    }

    @Override
    public void execute(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ExecuteBatchQuery", "execute"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ExecuteBatchQuery", "execute"));
        }
        try {
            if (!this.myHolder.canExecuteBatch()) {
                return;
            }
            this.myStatement.executeBatch();
            this.myHolder.batchExecuted(connection);
        }
        catch (AbstractTransactionStateHolder.IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException e) {
            this.myStatement.clearBatch();
            this.myHolder.onExecuteBatchError(connection);
            ExecuteBatchQuery.executeWithoutBatch(connection, this.myAllQueries, indicator, this.myHolder, this.myManager, this.myInfo, this.myAllQueries.size());
        }
    }

    public static void executeWithoutBatch(@NotNull Connection connection, @NotNull List<PreparedBatchQuery> queries, @NotNull ProgressIndicator indicator, @NotNull TransactionStateHolder holder, @NotNull ImportManager manager, @NotNull ImportInfo info, int lastQuery) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ExecuteBatchQuery", "executeWithoutBatch"));
        }
        int count = 0;
        for (int i2 = 0; i2 < lastQuery; ++i2) {
            if (!ExecuteBatchQuery.tryCommit(connection, holder, manager, info, count += queries.get(i2).executeWithoutBatch(connection, indicator))) continue;
            count = 0;
        }
    }

    public static boolean tryCommit(@NotNull Connection connection, @NotNull TransactionStateHolder holder, @NotNull ImportManager manager, @NotNull ImportInfo info, int count) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ExecuteBatchQuery", "tryCommit"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ExecuteBatchQuery", "tryCommit"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/ExecuteBatchQuery", "tryCommit"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ExecuteBatchQuery", "tryCommit"));
        }
        if (count < 1000 || !holder.isTransactionSupported()) {
            return false;
        }
        connection.commit();
        holder.committed(connection);
        if (!info.shouldLockTable()) {
            return true;
        }
        String lock = manager.getLockQuery(info.getContext(), info.getTable());
        if (lock != null) {
            DbImplUtil.executeUpdate(connection, lock);
        }
        return true;
    }
}

