/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.ImportTableEditorWrapper;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.ui.TableDialogSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingImportTableEditorWrapper
extends ImportTableEditorWrapper {
    private final DbTable myTable;

    public ExistingImportTableEditorWrapper(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ExistingImportTableEditorWrapper", "<init>"));
        }
        super(context);
        this.myTable = (DbTable)context.getElement();
    }

    @Override
    @NotNull
    protected TableDialogSettings.Settings createSettings() {
        TableDialogSettings.Settings settings = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.ALTER_CODE);
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ExistingImportTableEditorWrapper", "createSettings"));
        }
        return settings;
    }

    @Override
    @NotNull
    protected DeTable createTable(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/ExistingImportTableEditorWrapper", "createTable"));
        }
        DeTable deTable = (DeTable)this.myContext.getModel().getExportHelper().exportDeep(this.myTable.getDataSource().getModel(), (DasObject)this.myTable, true);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ExistingImportTableEditorWrapper", "createTable"));
        }
        return deTable;
    }
}

