/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportQueryGenerator;
import com.intellij.database.dbimport.Query;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDatabaseModifier
extends AbstractDatabaseModifier {
    private static final String ERROR_TITLE = "File contains records that can't be inserted";
    private static final String REF_ERROR_MESSAGE = "Click <a href=\"here\">here</a> to see not inserted records";
    private static final String ERROR_MESSAGE = "Not all records have been inserted";
    private static final String INDICATOR_TITLE = "Importing Data...";
    private static final String INDICATOR_TEXT = "Importing data from \"%s\" file to \"%s\" table";
    @NotNull
    private final AbstractDatabaseModifier.QueryExecutor myExecutor;

    public ImportDatabaseModifier(@NotNull DbDataSource dataSource, @NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull ReaderTask.Input reader, @Nullable DasNamespace defaultNs) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (dialectEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        super(dataSource, defaultNs, INDICATOR_TITLE);
        this.myExecutor = new ImportExecutor(info, project, dialectEx, (DatabaseSystem)dataSource, reader);
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        AbstractDatabaseModifier.QueryExecutor queryExecutor = this.myExecutor;
        if (queryExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier", "getExecutor"));
        }
        return queryExecutor;
    }

    private static class MyNotificationListener
    implements NotificationListener {
        @NotNull
        private final String myPathToFile;
        @NotNull
        private final Project myProject;

        MyNotificationListener(@NotNull Project project, @NotNull String pathToFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "<init>"));
            }
            if (pathToFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToFile", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "<init>"));
            }
            this.myPathToFile = pathToFile;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dbimport/ImportDatabaseModifier$MyNotificationListener", "hyperlinkUpdate"));
            }
            File file = new File(this.myPathToFile);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Can't access file", NotificationType.WARNING).notify(this.myProject);
                return;
            }
            if (virtualFile.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
                ShowFilePathAction.openFile((File)file);
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openEditor(new OpenFileDescriptor(this.myProject, virtualFile), true);
        }
    }

    public static class ImportExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private final ImportQueryGenerator myGenerator;
        @NotNull
        private final ImportErrorHandler myHandler;
        @NotNull
        private final ImportInfo myInfo;
        @NotNull
        private final DatabaseDialect myDialect;
        @NotNull
        private final DatabaseSystem mySystem;

        public ImportExecutor(@NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull DatabaseSystem system, @NotNull ReaderTask.Input input) throws IOException {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (dialectEx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (system == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            this.myHandler = new ImportErrorHandler(project, info);
            this.mySystem = system;
            this.myGenerator = new ImportQueryGenerator(info, project, dialectEx, this.myHandler, system, input);
            this.myDialect = dialectEx;
            this.myInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull Connection connection, @NotNull Project project, @NotNull ErrorHandler errorHandler) throws Exception {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            ImportManager manager = ImportManager.of(this.myDialect, this.mySystem.getDatabaseProductVersion());
            List<String> queriesBefore = manager.getDisablingQueries(this.myInfo.getContext(), this.myInfo.getTable());
            List<String> queriesAfter = manager.getEnablingQueries(this.myInfo.getContext(), this.myInfo.getTable());
            indicator.setText(String.format(ImportDatabaseModifier.INDICATOR_TEXT, this.myInfo.getFileName(), this.myInfo.getTableName()));
            indicator.setText2(this.mySystem.getName());
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                boolean transactions = metaData.supportsTransactions();
                boolean savepoints = metaData.supportsSavepoints();
                TransactionStateHolder holder = manager.createTransactionStateHolder(this.myInfo, transactions, savepoints);
                if (this.myInfo.shouldLockTable()) {
                    ImportExecutor.execute(connection, queriesBefore);
                }
                this.myGenerator.start();
                while (this.myGenerator.hasQueries()) {
                    List<Query> queries = this.myGenerator.generate(connection, holder);
                    for (Query query : queries) {
                        query.execute(connection, indicator);
                    }
                }
            }
            catch (SQLException e) {
                errorHandler.addError(e.getMessage(), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myGenerator.stop();
                if (this.myInfo.shouldLockTable()) {
                    ImportExecutor.executeInFinally(connection, queriesAfter);
                }
                if (this.myHandler.isErrorOccurs()) {
                    this.createNotification(project).notify(project);
                }
            }
            return true;
        }

        @NotNull
        private Notification createNotification(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (!this.myInfo.hasErrorPath()) {
                Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("File contains records that can't be inserted: Not all records have been inserted", NotificationType.WARNING);
                if (notification == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
                }
                return notification;
            }
            MyNotificationListener listener = new MyNotificationListener(project, (String)ObjectUtils.assertNotNull((Object)this.myInfo.getErrorFilePath()));
            Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(ImportDatabaseModifier.ERROR_TITLE, ImportDatabaseModifier.REF_ERROR_MESSAGE, NotificationType.WARNING, (NotificationListener)listener);
            if (notification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            return notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void execute(@NotNull Connection connection, @NotNull List<String> queries) throws Exception {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            Statement statement = connection.createStatement();
            try {
                for (String query : queries) {
                    statement.execute(query);
                }
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }

        private static void executeInFinally(@NotNull Connection connection, @NotNull List<String> queries) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            try {
                ImportExecutor.execute(connection, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

