/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ExistingImportTableEditorWrapper;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportPanel;
import com.intellij.database.dbimport.ImportTableEditorWrapper;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ImportDialog
extends DialogWrapper
implements ResultProcessorProvider {
    private static final String EMPTY_DATA = "No data for import";
    private static final String EMPTY_NAME = "Name of the table is empty";
    private static final String TITLE = "Import: \"%s\" Format";
    private static final String TABLE_EXISTS = "Table with this name already exists";
    private static final String MAPPING_ERROR = "Columns are not mapped";
    private static final String EMPTY_TABLE = "Table is empty";
    private static final Dimension SIZE = JBUI.size((int)800, (int)600);
    private final ImportPanel myPanel;
    private final ImportAction.ImportEditorContext myContext;
    private final ImportTableEditorWrapper myWrapper;

    public ImportDialog(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        super(context.getProject());
        this.myContext = context;
        this.setTitle(String.format(TITLE, context.getName()));
        this.myWrapper = context.createWrapper();
        this.myPanel = new ImportPanel(this.myWrapper, context);
        this.myPanel.setPreferredSize(SIZE);
        this.myWrapper.init();
        this.init();
        this.initValidation();
    }

    @NotNull
    public ImportInfo getImportInfo() throws IOException {
        ImportInfo importInfo = this.myPanel.getInfo();
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getImportInfo"));
        }
        return importInfo;
    }

    protected void doOKAction() {
        MyResultProcessor processor = new MyResultProcessor(this, this.myWrapper.getSettings(), null);
        if (!processor.process()) {
            this.error(new RuntimeException("Failed to process"));
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        boolean empty;
        ImportDatabaseTableEditor<?> editor = this.myWrapper.getEditor();
        if (editor == null) {
            return null;
        }
        DataGrid grid = this.myContext.getPreview().getGrid();
        boolean bl = empty = grid.getVisibleColumns().size() == 0 || grid.getVisibleRows().size() == 0;
        if (empty) {
            return new ValidationInfo(EMPTY_DATA, grid.getComponent());
        }
        JComponent editorComponent = editor.getPreferredFocusedComponent();
        if (editor.getTableModel().getName().isEmpty()) {
            return new ValidationInfo(EMPTY_NAME, editorComponent);
        }
        if (this.myContext.isTableExists(editor.getTable().name)) {
            return new ValidationInfo(TABLE_EXISTS, editorComponent);
        }
        JComponent columnEditorComponent = editor.getColumnsEditor().getComponent();
        if (editor.getTableModel().getColumnsCount() == 0) {
            return new ValidationInfo(EMPTY_TABLE, columnEditorComponent);
        }
        if (!this.checkMapping()) {
            return new ValidationInfo(MAPPING_ERROR, columnEditorComponent);
        }
        return null;
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private boolean checkMapping() {
        ImportDatabaseTableEditor<?> editor = this.myWrapper.getEditor();
        if (editor == null) {
            return true;
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = ((ImportColumnEditor)editor.getColumnsEditor()).getMapping();
        return ContainerUtil.exists(mapping.values(), (Condition)Condition.NOT_NULL);
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        if (!(this.myWrapper instanceof ExistingImportTableEditorWrapper)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "collectRenames"));
            }
            return jBIterable;
        }
        JBIterable<Pair<PsiElement, String>> jBIterable = DbRenamePsiElementProcessor.collectRenameElements(this.getContext().getModel());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "collectRenames"));
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.myContext.getProject();
    }

    @Override
    public boolean isPreviewUsages() {
        return true;
    }

    @Override
    public void success() {
        this.close(0);
    }

    @Override
    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dbimport/ImportDialog", "error"));
        }
        this.myPanel.reportError(t);
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myWrapper.getDdlPreview().getPreviewText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "statement"));
        }
        return string;
    }

    @Override
    @NotNull
    public ImportAction.ImportEditorContext getContext() {
        ImportAction.ImportEditorContext importEditorContext = this.myContext;
        if (importEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getContext"));
        }
        return importEditorContext;
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.getContext().getModel();
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getModel"));
        }
        return deModel;
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getEditor() {
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.assertNotNull(this.myWrapper.getEditor());
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getEditor"));
        }
        return databaseEditorBaseEx;
    }

    private void runImport() {
        try {
            ImportInfo info = this.getImportInfo();
            new DataImporter(this.getProject(), this.myContext.getElement(), this.myContext.getInputType().createInput(info), info).importData();
        }
        catch (IOException ex) {
            DataSourceUiUtil.showNotification(this.getProject(), "Can't access file", ex.getMessage(), true);
        }
        finally {
            Disposer.dispose((Disposable)this.myContext.getDisposable());
        }
    }

    private class ImportRenameProcessor
    extends DbRenamePsiElementProcessor.MyRenameProcessor {
        public ImportRenameProcessor(Project project, DatabaseRefactoringHandler handler, JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            super(project, handler, renames, isSearchInComments, isSearchTextOccurrences);
        }

        @Override
        @NotNull
        protected Promise<Void> runStatements(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            Promise promise = super.runStatements(usages).done(aVoid -> ImportDialog.this.runImport());
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            return promise;
        }
    }

    private class MyResultProcessor
    extends GenericEditingResultProcessor {
        public MyResultProcessor(@NotNull ResultProcessorProvider api, @Nullable TableDialogSettings.Settings settings, RangeMarker insertPos) {
            if (api == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "api", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "<init>"));
            }
            super(api, settings, insertPos);
        }

        @Override
        @NotNull
        protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
            if (renames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            ImportRenameProcessor importRenameProcessor = new ImportRenameProcessor((Project)ObjectUtils.assertNotNull((Object)ImportDialog.this.getContext().getProject()), handler, renames, true, true);
            if (importRenameProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            return importRenameProcessor;
        }

        @Override
        @NotNull
        protected Promise<Void> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            Promise promise = super.processWithoutRenames(handler).done(aVoid -> ImportDialog.this.runImport());
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            return promise;
        }
    }
}

