/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportErrorHandler {
    private final BlockingQueue<Object[]> myQueue;
    private final Thread myThread;
    private final HandleErrorTask myErrorTask;
    private final boolean myHasErrorPath;
    private boolean myErrorOccurs;

    ImportErrorHandler(@NotNull Project project, @NotNull ImportInfo info) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        this.myQueue = new LinkedTransferQueue<Object[]>();
        this.myHasErrorPath = info.hasErrorPath();
        this.myErrorTask = this.createErrorTask(project, info);
        this.myThread = new Thread((Runnable)this.myErrorTask, "Import error handler");
    }

    void start() {
        if (this.myHasErrorPath) {
            this.myThread.start();
        }
    }

    void stop() {
        if (this.myHasErrorPath) {
            this.onStop();
        }
    }

    void handle(@NotNull Object[] errorLine) {
        if (errorLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorLine", "com/intellij/database/dbimport/ImportErrorHandler", "handle"));
        }
        this.myErrorOccurs = true;
        if (!this.myHasErrorPath || this.myErrorTask.isStopped()) {
            return;
        }
        this.myQueue.add(errorLine);
    }

    boolean isErrorOccurs() {
        return this.myErrorOccurs;
    }

    private void onStop() {
        this.myQueue.add(HandleErrorTask.POISON);
    }

    @Nullable
    private HandleErrorTask createErrorTask(@NotNull Project project, @NotNull ImportInfo info) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        return this.myHasErrorPath ? new HandleErrorTask(project, this.myQueue, (Writer)ObjectUtils.assertNotNull((Object)info.getErrorWriter()), info.getFormat()) : null;
    }
}

