/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportInfo {
    private final CsvFormat myFormat;
    private final DeTable myTable;
    private final String myFileName;
    private final String myErrorFilePath;
    private final Writer myErrorWriter;
    private final ImportAction.ImportType myType;
    private final boolean myLockTable;
    private final List<? extends ColumnDescriptor> myProducers;
    private final StatementWorker myWorker;
    private final DatabaseEditorContext myContext;
    private final boolean myInsertAsNull;
    private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
    private List<AutoValueDescriptor> myConsumers;

    public ImportInfo(@NotNull CsvFormat format, @NotNull DeTable table, @NotNull List<AutoValueDescriptor> consumers, @NotNull List<? extends ColumnDescriptor> producers, @NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map, @NotNull String fileName, @NotNull ImportAction.ImportType type, @NotNull DatabaseEditorContext context, @Nullable String errorFilePath, @Nullable Writer errorWriter, boolean lockTable, boolean insertAsNull) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (producers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producers", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        this.myFormat = format;
        this.myTable = table;
        this.myProducers = producers;
        this.myFileName = fileName;
        this.myType = type;
        this.myLockTable = lockTable;
        this.myErrorFilePath = errorFilePath;
        this.myErrorWriter = errorWriter;
        this.myConsumers = consumers;
        this.myConsumerToProducer = map;
        this.myContext = context;
        this.myInsertAsNull = insertAsNull;
        this.myWorker = new StatementWorker();
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumers() {
        List<AutoValueDescriptor> list = this.myConsumers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getConsumers"));
        }
        return list;
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumersForInsert() {
        List list = ContainerUtil.filter(this.myConsumers, consumer -> this.myConsumerToProducer.get(consumer) != null || consumer.isAutogenerated() || consumer.hasDefault());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getConsumersForInsert"));
        }
        return list;
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNull;
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getFormat"));
        }
        return csvFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTable.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTableName"));
        }
        return string;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getContext"));
        }
        return databaseEditorContext;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = this.myTable;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTable"));
        }
        return deTable;
    }

    @NotNull
    public ImportAction.ImportType getType() {
        ImportAction.ImportType importType = this.myType;
        if (importType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getType"));
        }
        return importType;
    }

    @Nullable
    public String getErrorFilePath() {
        return this.myErrorFilePath;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getFileName"));
        }
        return string;
    }

    public boolean hasErrorPath() {
        return this.myErrorWriter != null;
    }

    @Nullable
    public Writer getErrorWriter() {
        return this.myErrorWriter;
    }

    @NotNull
    public StatementWorker statementWorker() {
        StatementWorker statementWorker = this.myWorker;
        if (statementWorker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "statementWorker"));
        }
        return statementWorker;
    }

    public void setConsumers(@NotNull List<ColumnDescriptor> consumers) {
        if (consumers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumers", "com/intellij/database/dbimport/ImportInfo", "setConsumers"));
        }
        ArrayList newConsumers = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < consumers.size(); ++i2) {
            AutoValueDescriptor oldOne = this.myConsumers.get(i2);
            newConsumers.add(ImportUtil.createDescriptor(consumers.get(i2), oldOne.isAutogenerated(), oldOne.hasDefault()));
        }
        this.myConsumers = newConsumers;
        LinkedHashMap newMap = ContainerUtilRt.newLinkedHashMap();
        Iterator<Map.Entry<AutoValueDescriptor, ColumnDescriptor>> iterator = this.myConsumerToProducer.entrySet().iterator();
        for (AutoValueDescriptor consumer : this.myConsumers) {
            if (!iterator.hasNext()) break;
            AutoValueDescriptor existingConsumer = iterator.next().getKey();
            ColumnDescriptor producer = this.myConsumerToProducer.get(existingConsumer);
            newMap.put(consumer, producer);
        }
        this.myConsumerToProducer = newMap;
    }

    public static class ConversionException
    extends Exception {
        private static final String ERROR_MASK = "Can't convert value %s to type %s";

        private ConversionException(@NotNull Object value, @NotNull String typeName) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dbimport/ImportInfo$ConversionException", "<init>"));
            }
            if (typeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/dbimport/ImportInfo$ConversionException", "<init>"));
            }
            super(String.format(ERROR_MASK, value, typeName));
        }
    }

    public class StatementWorker {
        private final Map<ColumnDescriptor, Integer> myCachedMapping = ContainerUtil.newHashMap();
        private final Map<ColumnDescriptor, Function<Object, Object>> myConverters = ContainerUtil.newHashMap();

        public void fillStatement(@NotNull PreparedStatement statement, @NotNull Object[] line) throws Exception {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "fillStatement"));
            }
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "fillStatement"));
            }
            int i2 = 1;
            Collection<AutoValueDescriptor> consumers = this.mappedConsumers();
            for (AutoValueDescriptor consumer : consumers) {
                Object converted;
                int index = this.getProducerIndex(consumer);
                Object o = index == -1 ? null : line[index];
                Function<Object, Object> converter = this.getConverter(o, consumer, (ColumnDescriptor)ImportInfo.this.myProducers.get(index));
                Object object = converted = converter == null ? null : converter.fun(o);
                if (!ImportInfo.this.myInsertAsNull && o != null && converted == null) {
                    throw new ConversionException(o, consumer.getTypeName());
                }
                DbImplUtil.setStatementParameter(statement, consumer, converted, ImportInfo.this.myContext.getDialect(), true, i2++);
            }
        }

        @Nullable
        private Function<Object, Object> getConverter(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "getConverter"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "getConverter"));
            }
            if (this.myConverters.containsKey(consumer)) {
                return this.myConverters.get(consumer);
            }
            Function<Object, Object> converter = this.getNoCached(o, consumer, producer);
            this.myConverters.put(consumer, converter);
            return converter;
        }

        @Nullable
        private Function<Object, Object> getNoCached(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "getNoCached"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "getNoCached"));
            }
            DbDataSource source = ImportInfo.this.myContext.getDataSource();
            return DataTypeConversion.getConverter(GenericDialect.INSTANCE, ImportInfo.this.myContext.getDialect(), null, (DatabaseSystem)source, producer, consumer, o);
        }

        @NotNull
        private Collection<AutoValueDescriptor> mappedConsumers() {
            List list = ContainerUtil.filter((Collection)ImportInfo.this.myConsumers, consumer -> ImportInfo.this.myConsumerToProducer.get(consumer) != null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "mappedConsumers"));
            }
            return list;
        }

        private int getProducerIndex(@NotNull AutoValueDescriptor consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ImportInfo$StatementWorker", "getProducerIndex"));
            }
            if (this.myCachedMapping.containsKey(consumer)) {
                return this.myCachedMapping.get(consumer);
            }
            ColumnDescriptor producer = (ColumnDescriptor)ImportInfo.this.myConsumerToProducer.get(consumer);
            int result = producer == null ? -1 : ContainerUtil.indexOf((List)ImportInfo.this.myProducers, current -> StringUtil.equals((CharSequence)producer.getName(), (CharSequence)current.getName()));
            this.myCachedMapping.put(consumer, result);
            return result;
        }
    }
}

