/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.state.CommitOnExecuteStateHolder;
import com.intellij.database.dbimport.state.DefaultTransactionStateHolder;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.Db2Dialect;
import com.intellij.database.dialects.DerbyDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.H2Dialect;
import com.intellij.database.dialects.HsqldbDialect;
import com.intellij.database.dialects.MssqlDialect;
import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.dialects.OracleDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.dialects.SybaseDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ImportManager {
    DEFAULT((DatabaseDialectEx)GenericDialect.INSTANCE, "CLOB", 1, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")}){

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$1", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, false);
        }
    }
    ,
    POSTGRES((DatabaseDialectEx)PostgresDialect.INSTANCE, "TEXT", 1, true, false, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("NUMERIC")}){

        @Override
        @NotNull
        public List<String> getDisablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$2", "getDisablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$2", "getDisablingQueries"));
            }
            List<String> list = this.getQueries(context, table, true);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$2", "getDisablingQueries"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getEnablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$2", "getEnablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$2", "getEnablingQueries"));
            }
            List<String> list = this.getQueries(context, table, false);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$2", "getEnablingQueries"));
            }
            return list;
        }

        private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table, boolean before) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$2", "getQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$2", "getQueries"));
            }
            return ContainerUtil.list((Object[])new String[]{this.triggers(this.alter(this.createBuilder(context), "TABLE", table).space(), !before).getStatement()});
        }

        private DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportManager$2", "triggers"));
            }
            return builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("TRIGGER").space().keyword("ALL");
        }
    }
    ,
    ORACLE((DatabaseDialectEx)OracleDialect.INSTANCE, "CLOB", 1, true, false, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")}){

        @Override
        @NotNull
        public List<String> getDisablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "getDisablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "getDisablingQueries"));
            }
            List<String> queries = this.getQueries(context, table, true, "UNUSABLE");
            queries.add(this.getLockQuery(context, table));
            List<String> list = queries;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$3", "getDisablingQueries"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getEnablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "getEnablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "getEnablingQueries"));
            }
            List<String> list = this.getQueries(context, table, false, "REBUILD");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$3", "getEnablingQueries"));
            }
            return list;
        }

        @NotNull
        private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table, boolean isBeforeImport, @NotNull String whatToDoWithIndices) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "getQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "getQueries"));
            }
            if (whatToDoWithIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whatToDoWithIndices", "com/intellij/database/dbimport/ImportManager$3", "getQueries"));
            }
            ArrayList result = ContainerUtil.newArrayList();
            result.add(this.triggers(this.alter(this.createBuilder(context), "TABLE", table).space(), !isBeforeImport).getStatement());
            result.add(this.skipUnusable(context, isBeforeImport));
            this.alterIndicies(context, table, result, whatToDoWithIndices);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$3", "getQueries"));
            }
            return arrayList;
        }

        private DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportManager$3", "triggers"));
            }
            return builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("ALL").space().keyword("TRIGGERS");
        }

        @Override
        @NotNull
        public String getInsertStatement(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull Collection<? extends AutoValueDescriptor> columns, int linesCount) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "getInsertStatement"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "getInsertStatement"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportManager$3", "getInsertStatement"));
            }
            if (linesCount > 1) {
                throw new IllegalArgumentException("Lines count bigger than 1 not supported by oracle");
            }
            List params2 = ImportManager.getPlaceholders(OracleDialect.INSTANCE, columns, linesCount);
            DdlBuilder builder = this.createBuilder(context).keyword("INSERT").space().literal("/*+append*/").space().keyword("INTO").space().qualifiedRef((DasObject)table).space().literal("(");
            DialectUtils.appendStringList(builder, JdbcEngine.getColumnNamesForInsert(columns, OracleDialect.INSTANCE));
            builder.literal(")").space().keyword("VALUES").literal("(");
            DialectUtils.appendPlainList(builder, (Iterable)ContainerUtil.getFirstItem((List)params2));
            builder.literal(")");
            String string = builder.getStatement();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$3", "getInsertStatement"));
            }
            return string;
        }

        @Override
        @Nullable
        public String getLockQuery(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "getLockQuery"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "getLockQuery"));
            }
            return this.createBuilder(context).space().keyword("LOCK").space().keyword("TABLE").space().qualifiedRef(table).space().keyword("IN").space().keyword("EXCLUSIVE").space().keyword("MODE").getStatement();
        }

        private String skipUnusable(@NotNull DatabaseEditorContext context, boolean value) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "skipUnusable"));
            }
            return this.createBuilder(context).keyword("ALTER").space().keyword("SESSION").space().keyword("SET").space().literal("skip_unusable_indexes=").space().literal(String.valueOf(value).toLowerCase(Locale.US)).getStatement();
        }

        private void alterIndicies(@NotNull DatabaseEditorContext context, @NotNull DeTable table, @NotNull List<String> result, @NotNull String whatToDo) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "alterIndicies"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$3", "alterIndicies"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportManager$3", "alterIndicies"));
            }
            if (whatToDo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whatToDo", "com/intellij/database/dbimport/ImportManager$3", "alterIndicies"));
            }
            if (table.indices.isEmpty()) {
                return;
            }
            for (int i2 = 1; i2 < table.indices.size(); ++i2) {
                result.add(this.alterIndex(context, table.indices.get(i2), whatToDo));
            }
        }

        private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DeIndex index, @NotNull String whatToDo) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$3", "alterIndex"));
            }
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dbimport/ImportManager$3", "alterIndex"));
            }
            if (whatToDo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whatToDo", "com/intellij/database/dbimport/ImportManager$3", "alterIndex"));
            }
            return this.alter(this.createBuilder(context), "INDEX", index).space().keyword(whatToDo).getStatement();
        }

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$3", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, supportTransactions);
        }
    }
    ,
    MSSQL2005((DatabaseDialectEx)MssqlDialect.INSTANCE, "TEXT", 1, true, false, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")}){

        @Override
        @NotNull
        public List<String> getDisablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$4", "getDisablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$4", "getDisablingQueries"));
            }
            List<String> result = POSTGRES.getDisablingQueries(context, table);
            this.alterIndicies(context, table, result, false);
            List<String> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$4", "getDisablingQueries"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getEnablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$4", "getEnablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$4", "getEnablingQueries"));
            }
            List<String> result = POSTGRES.getEnablingQueries(context, table);
            this.alterIndicies(context, table, result, true);
            List<String> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$4", "getEnablingQueries"));
            }
            return list;
        }

        private void alterIndicies(@NotNull DatabaseEditorContext context, @NotNull DeTable table, @NotNull List<String> result, boolean enable) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$4", "alterIndicies"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$4", "alterIndicies"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportManager$4", "alterIndicies"));
            }
            if (table.indices.isEmpty()) {
                return;
            }
            for (int i2 = 1; i2 < table.indices.size(); ++i2) {
                result.add(this.alterIndex(context, table, table.indices.get(i2), enable));
            }
        }

        private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DeTable table, @NotNull DeIndex index, boolean enable) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$4", "alterIndex"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$4", "alterIndex"));
            }
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dbimport/ImportManager$4", "alterIndex"));
            }
            return this.alter(this.createBuilder(context), "INDEX", index).space().keyword("ON").space().qualifiedRef(table).space().keyword(enable ? "REBUILD" : "DISABLE").getStatement();
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager$4", "isSuitable"));
            }
            return dialect == MssqlDialect.INSTANCE && (productVersion == null || !DataSourceUiUtil.isMsSql2008(productVersion));
        }

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$4", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, supportTransactions);
        }
    }
    ,
    MSSQL2008((DatabaseDialectEx)MssqlDialect.INSTANCE, "TEXT", 1, true, false, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")}){

        @Override
        @NotNull
        public List<String> getDisablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$5", "getDisablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$5", "getDisablingQueries"));
            }
            List<String> list = MSSQL2005.getDisablingQueries(context, table);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$5", "getDisablingQueries"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getEnablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager$5", "getEnablingQueries"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager$5", "getEnablingQueries"));
            }
            List<String> list = MSSQL2005.getEnablingQueries(context, table);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager$5", "getEnablingQueries"));
            }
            return list;
        }

        @Override
        boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager$5", "isSuitable"));
            }
            return dialect == MssqlDialect.INSTANCE && productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
        }

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$5", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, supportTransactions);
        }
    }
    ,
    DERBY((DatabaseDialectEx)DerbyDialect.INSTANCE, "CLOB", 1000, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("REAL")}){

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$6", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, supportTransactions);
        }
    }
    ,
    DB2((DatabaseDialectEx)Db2Dialect.INSTANCE, "CLOB", 1, false, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("REAL")),
    H2((DatabaseDialectEx)H2Dialect.INSTANCE, "TEXT", 1000, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DOUBLE")),
    HSQLDB((DatabaseDialectEx)HsqldbDialect.INSTANCE, "CLOB", 1, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("DECIMAL")}){

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$7", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, false);
        }
    }
    ,
    SYBASE((DatabaseDialectEx)SybaseDialect.INSTANCE, "TEXT", 1, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")}){

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$8", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, false);
        }
    }
    ,
    MYSQL((DatabaseDialectEx)MysqlDialect.INSTANCE, "TEXT", 1000, new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")),
    SQLITE((DatabaseDialectEx)SqliteDialect.INSTANCE, "TEXT", 1, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("REAL")}){

        @Override
        public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager$9", "createTransactionStateHolder"));
            }
            return new CommitOnExecuteStateHolder(this, info, false);
        }
    };

    @NotNull
    private final TypeMerger[] myMergers;
    @NotNull
    private final DatabaseDialectEx myDialect;
    @NotNull
    private final TypeMerger.StringMerger myStringMerger;
    private final int myLinesPerStatement;
    private final boolean mySupportFastMode;
    private final boolean myShouldNotUseBatches;

    private ImportManager(DatabaseDialectEx dialect, @NotNull String myTextType, int batchSize, TypeMerger ... mergers) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        if (myTextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myTextType", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        if (mergers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergers", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        this(dialect, myTextType, batchSize, false, false, mergers);
    }

    private ImportManager(DatabaseDialectEx dialect, String myTextType, int linesPerStatement, @NotNull boolean supportFastMode, boolean shouldNotUseBatches, TypeMerger ... mergers) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        if (myTextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myTextType", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        if (mergers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergers", "com/intellij/database/dbimport/ImportManager", "<init>"));
        }
        this.myDialect = dialect;
        this.myMergers = mergers;
        this.myStringMerger = new TypeMerger.StringMerger(myTextType);
        this.myLinesPerStatement = linesPerStatement;
        this.mySupportFastMode = supportFastMode;
        this.myShouldNotUseBatches = shouldNotUseBatches;
        Arrays.sort(this.myMergers, (m1, m2) -> m1.getPriority() > m2.getPriority() ? 1 : -1);
    }

    @NotNull
    public static ImportManager of(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager", "of"));
        }
        for (ImportManager manager : ImportManager.values()) {
            if (!manager.isSuitable(dialect, productVersion)) continue;
            ImportManager importManager = manager;
            if (importManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "of"));
            }
            return importManager;
        }
        ImportManager importManager = DEFAULT;
        if (importManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "of"));
        }
        return importManager;
    }

    @NotNull
    public TypeMerger getType(String string) {
        for (TypeMerger merger : this.myMergers) {
            if (!merger.isSuitable(string)) continue;
            TypeMerger typeMerger = merger;
            if (typeMerger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getType"));
            }
            return typeMerger;
        }
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getType"));
        }
        return stringMerger;
    }

    @NotNull
    public TypeMerger.StringMerger getStringMerger() {
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getStringMerger"));
        }
        return stringMerger;
    }

    @NotNull
    public String getInsertStatement(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull Collection<? extends AutoValueDescriptor> columns, int linesCount) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "getInsertStatement"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager", "getInsertStatement"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportManager", "getInsertStatement"));
        }
        String string = AbstractDatabaseDialect.multiInsertStatement(this.createBuilder(context), table, JdbcEngine.getColumnNamesForInsert(columns, this.myDialect), this.myDialect, ImportManager.getPlaceholders(this.myDialect, columns, linesCount)).getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getInsertStatement"));
        }
        return string;
    }

    public int getLinesPerStatement() {
        return this.myLinesPerStatement;
    }

    @NotNull
    public List<String> getDisablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "getDisablingQueries"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager", "getDisablingQueries"));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getDisablingQueries"));
        }
        return list;
    }

    @NotNull
    public List<String> getEnablingQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "getEnablingQueries"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager", "getEnablingQueries"));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getEnablingQueries"));
        }
        return list;
    }

    @Nullable
    public String getLockQuery(@NotNull DatabaseEditorContext context, @NotNull DeTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "getLockQuery"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager", "getLockQuery"));
        }
        return null;
    }

    public boolean isSupportFastMode() {
        return this.mySupportFastMode;
    }

    public boolean isShouldNotUseBatches() {
        return this.myShouldNotUseBatches;
    }

    boolean isSuitable(@NotNull DatabaseDialect dialect, @Nullable String productVersion) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager", "isSuitable"));
        }
        return this.myDialect == dialect;
    }

    @NotNull
    DdlBuilder createBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "createBuilder"));
        }
        DdlBuilder ddlBuilder = ImportManager.createConfiguredBuilder(context);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "createBuilder"));
        }
        return ddlBuilder;
    }

    public TransactionStateHolder createTransactionStateHolder(@NotNull ImportInfo info, boolean supportTransactions, boolean supportSavePoints) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportManager", "createTransactionStateHolder"));
        }
        return new DefaultTransactionStateHolder(info, this, supportTransactions, supportSavePoints);
    }

    @NotNull
    DdlBuilder alter(@NotNull DdlBuilder builder, @NotNull String objectToAlter, @NotNull DasObject table) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportManager", "alter"));
        }
        if (objectToAlter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectToAlter", "com/intellij/database/dbimport/ImportManager", "alter"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportManager", "alter"));
        }
        DdlBuilder ddlBuilder = builder.keyword("ALTER").space().keyword(objectToAlter).space().qualifiedRef(table);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "alter"));
        }
        return ddlBuilder;
    }

    @NotNull
    static DdlBuilder createConfiguredBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportManager", "createConfiguredBuilder"));
        }
        DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder(context, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "createConfiguredBuilder"));
        }
        return ddlBuilder;
    }

    @NotNull
    private static List<List<String>> getPlaceholders(@NotNull DatabaseDialectEx dialect, @NotNull Collection<? extends AutoValueDescriptor> columns, int rows) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportManager", "getPlaceholders"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportManager", "getPlaceholders"));
        }
        List<List<String>> list = Collections.nCopies(rows, JdbcEngine.getPlaceholdersForInsert(columns, dialect));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportManager", "getPlaceholders"));
        }
        return list;
    }
}

