/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTableEditorWrapper;
import com.intellij.database.dbimport.ui.ImportSettingsPanel;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportPanel
extends JPanel {
    private final ImportTableEditorWrapper myWrapper;
    private final ImportSettingsPanel myImportSettingsPanel;
    private final ImportAction.ImportEditorContext myContext;
    private final ImportAction.ImportType myType;
    private final DdlPreview myDdlPreview;
    private final ErrorNotificationWrapperPanel myErrorPanel;
    private TabbedPaneWrapper myPane;

    ImportPanel(@NotNull ImportTableEditorWrapper tableEditor, @NotNull ImportAction.ImportEditorContext context) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myWrapper = tableEditor;
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.myDdlPreview = tableEditor.getDdlPreview();
        this.myType = context.getType();
        this.myImportSettingsPanel = new ImportSettingsPanel(this.myWrapper.getTableName(), context);
        this.myContext = context;
        tableEditor.addEditorListener(this::onEditorChanged);
    }

    @NotNull
    ImportInfo getInfo() throws IOException {
        TableCsvFormatPreview preview = this.myContext.getPreview();
        DataGrid grid = preview.getGrid();
        String errorFilePath = ImportPanel.sanitize(this.myImportSettingsPanel.getErrorOutputFilePath());
        DatabaseTableEditor editor = (DatabaseTableEditor)ObjectUtils.assertNotNull(this.myWrapper.getEditor());
        List columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = this.myWrapper.getMapping();
        ImportInfo importInfo = new ImportInfo((CsvFormat)ObjectUtils.assertNotNull((Object)this.myContext.getFormats().getSelectedFormat()), (DeTable)editor.getTableModel().getObject(), ContainerUtil.newArrayList(mapping.keySet()), columns, mapping, this.myContext.getName(), this.myType, this.myContext, errorFilePath, errorFilePath == null ? null : new FileWriter(errorFilePath), this.myImportSettingsPanel.getModalityState(), this.myImportSettingsPanel.isInsertAsNull());
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportPanel", "getInfo"));
        }
        return importInfo;
    }

    void onEditorChanged(@NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportPanel", "onEditorChanged"));
        }
        this.removeAll();
        TabbedPaneWrapper oldOne = this.myPane;
        this.myPane = new TabbedPaneWrapper((Disposable)newEditor);
        this.myPane.insertTab("Data preview", null, this.myContext.getPreview().getComponent(), null, 0);
        this.myPane.insertTab("DDL preview", null, this.myDdlPreview.getComponent(), null, 1);
        if (oldOne != null) {
            this.myPane.setSelectedIndex(oldOne.getSelectedIndex());
        }
        JComponent paneComponent = this.myPane.getComponent();
        paneComponent.setBorder(IdeBorderFactory.createEmptyBorder((int)1));
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setFirstComponent(newEditor.getComponent());
        splitter.setSecondComponent(paneComponent);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)splitter, "Center");
        right.add((Component)this.myImportSettingsPanel, "South");
        this.add((Component)this.myContext.getFormats().getComponent(), "West");
        this.add((Component)right, "Center");
        this.add((Component)this.myErrorPanel, "South");
    }

    public void reportError(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dbimport/ImportPanel", "reportError"));
        }
        this.myErrorPanel.reportError(t);
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }
}

