/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.BatchRecords;
import com.intellij.database.dbimport.ExecuteBatchQuery;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.PreparedBatchQuery;
import com.intellij.database.dbimport.PreparedQuery;
import com.intellij.database.dbimport.Query;
import com.intellij.database.dbimport.QueryWithParameters;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportQueryGenerator {
    public static final int MAX_STATEMENTS_PER_TRANSACTION = 1000;
    private final Thread myReaderThread;
    private final ReaderTask myReaderTask;
    private final DatabaseDialectEx myDatabaseDialect;
    private final LinkedTransferQueue<BatchRecords> myTransferQueue;
    private final ImportInfo myInfo;
    private final ImportManager myManager;
    private final ImportErrorHandler myHandler;
    private final DatabaseSystem mySystem;
    private final double mySize;
    private List<PreparedBatchQuery> myBatchQueries;
    private PreparedStatement myStatement;
    private double myCurrentSize;
    private boolean myStopped;
    private boolean myBatchSupported;
    private boolean myInited;
    private long myCurrentStatementsCount;

    ImportQueryGenerator(@NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull ImportErrorHandler errorHandler, @NotNull DatabaseSystem system, @NotNull ReaderTask.Input input) throws IOException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ImportQueryGenerator", "<init>"));
        }
        this.myInfo = info;
        this.myDatabaseDialect = dialect;
        this.myManager = ImportManager.of(dialect, system.getDatabaseProductVersion());
        this.mySystem = system;
        this.myTransferQueue = new LinkedTransferQueue();
        this.myHandler = errorHandler;
        this.myReaderTask = new ReaderTask(input, project, this.myTransferQueue);
        this.myReaderThread = new Thread((Runnable)this.myReaderTask, "Import data reader");
        this.myBatchQueries = ContainerUtil.newArrayList();
        this.mySize = input.getSizeOfData();
        this.myCurrentSize = 0.0;
    }

    @NotNull
    List<Query> generate(@NotNull Connection connection, @NotNull TransactionStateHolder holder) throws Exception {
        BatchRecords parameters;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "generate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "generate"));
        }
        this.init(connection, holder);
        if (this.myStatement == null) {
            this.createColumns(connection);
            this.myStatement = connection.prepareStatement(this.getStatement(this.myManager.getLinesPerStatement()));
        }
        if ((parameters = this.receiveParameters()) == BatchRecords.POISON) {
            this.myStopped = true;
            JdbcUtil.closeStatementSafe((Statement)this.myStatement);
            List<Query> list = this.lastCommitQuery(ContainerUtil.newArrayList(), holder);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "generate"));
            }
            return list;
        }
        List<Query> list = this.generateInternal(connection, parameters, holder);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "generate"));
        }
        return list;
    }

    void stop() {
        this.myReaderTask.stop();
        this.myReaderThread.interrupt();
        this.myHandler.stop();
        JdbcUtil.closeStatementSafe((Statement)this.myStatement);
    }

    boolean hasQueries() {
        return !this.myStopped;
    }

    void start() {
        this.myReaderThread.start();
        this.myHandler.start();
    }

    private void createColumns(@NotNull Connection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "createColumns"));
        }
        DdlBuilder builder = this.myDatabaseDialect.sqlSelectAll(ImportManager.createConfiguredBuilder(this.myInfo.getContext()), this.myInfo.getTable(), this.mySystem, null, null, false, 1);
        List<ColumnDescriptor> columns = this.getColumns(connection, builder);
        if (columns == null) {
            return;
        }
        if (columns.size() != this.myInfo.getConsumers().size()) {
            throw new IllegalStateException("Column count is different from expected");
        }
        this.myInfo.setConsumers(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<ColumnDescriptor> getColumns(@NotNull Connection connection, @NotNull DdlBuilder builder) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "getColumns"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ImportQueryGenerator", "getColumns"));
        }
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(builder.getStatement());
            if (resultSet == null) {
                List<ColumnDescriptor> list = null;
                return list;
            }
            List list = ContainerUtil.list((Object[])JdbcEngine.getColumnDescriptors(resultSet, this.myDatabaseDialect));
            return list;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    @NotNull
    private List<Query> generateInternal(@NotNull Connection connection, @NotNull BatchRecords records, @NotNull TransactionStateHolder holder) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "generateInternal"));
        }
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ImportQueryGenerator", "generateInternal"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "generateInternal"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        int linesPerStatement = this.myManager.getLinesPerStatement();
        int linesInBatch = records.getLineCount();
        List<Object[]> allRecords = records.getRecords();
        double sizePerLine = records.getBatchSize() / (double)linesInBatch;
        ArrayList currentStatementRecords = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < linesInBatch; ++i2) {
            if (currentStatementRecords.size() == linesPerStatement) {
                this.flush(currentStatementRecords, result, holder);
                currentStatementRecords = ContainerUtil.newArrayList();
            }
            this.myCurrentSize += sizePerLine;
            currentStatementRecords.add(allRecords.get(i2));
        }
        List<Query> list = this.generateLastQueries(result, currentStatementRecords, connection, holder);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "generateInternal"));
        }
        return list;
    }

    private void handle(@NotNull Object[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/ImportQueryGenerator", "handle"));
        }
        this.myHandler.handle(parameters);
    }

    private void init(@NotNull Connection connection, @NotNull TransactionStateHolder holder) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "init"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "init"));
        }
        if (this.myInited) {
            return;
        }
        this.myInited = true;
        boolean bl = this.myBatchSupported = connection.getMetaData().supportsBatchUpdates() && !this.myManager.isShouldNotUseBatches();
        if (holder.isTransactionSupported()) {
            connection.setAutoCommit(false);
        }
    }

    private void flush(@NotNull List<Object[]> parameters, @NotNull List<Query> result, @NotNull TransactionStateHolder holder) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/ImportQueryGenerator", "flush"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "flush"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "flush"));
        }
        if (this.myBatchSupported) {
            this.indexBatchQuery((PreparedBatchQuery)this.getQuery(parameters, holder), result, holder, parameters.size());
            return;
        }
        this.indexPreparedQuery(this.getQuery(parameters, holder), holder, result, parameters.size());
    }

    @NotNull
    private QueryWithParameters getQuery(@NotNull List<Object[]> currentQueryParameters, @NotNull TransactionStateHolder holder) {
        if (currentQueryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentQueryParameters", "com/intellij/database/dbimport/ImportQueryGenerator", "getQuery"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "getQuery"));
        }
        QueryWithParameters queryWithParameters = this.myBatchSupported ? new PreparedBatchQuery(currentQueryParameters, this.myStatement, this.myDatabaseDialect, (Consumer<Object[]>)((Consumer)this::handle), this.mySystem, this.myInfo, holder, this.myBatchQueries, this.getFraction()) : new PreparedQuery(currentQueryParameters, this.myStatement, this.myDatabaseDialect, (Consumer<Object[]>)((Consumer)this::handle), this.mySystem, this.myInfo, holder, this.getFraction());
        if (queryWithParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "getQuery"));
        }
        return queryWithParameters;
    }

    private void indexPreparedQuery(@NotNull Query query, @NotNull TransactionStateHolder holder, @NotNull List<Query> result, int statements) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/dbimport/ImportQueryGenerator", "indexPreparedQuery"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "indexPreparedQuery"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "indexPreparedQuery"));
        }
        result.add(query);
        this.indexStatementsPerTransaction(result, holder, statements, holder.isTransactionSupported());
    }

    private void indexBatchQuery(@NotNull PreparedBatchQuery query, @NotNull List<Query> result, @NotNull TransactionStateHolder holder, int statements) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/dbimport/ImportQueryGenerator", "indexBatchQuery"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "indexBatchQuery"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "indexBatchQuery"));
        }
        result.add(query);
        this.myBatchQueries.add(query);
        this.indexStatementsPerTransaction(result, holder, statements, false);
    }

    private void indexStatementsPerTransaction(@NotNull List<Query> result, @NotNull TransactionStateHolder holder, int statements, boolean commit) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "indexStatementsPerTransaction"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "indexStatementsPerTransaction"));
        }
        if (!holder.isTransactionSupported()) {
            return;
        }
        this.myCurrentStatementsCount += (long)statements;
        if (!commit) {
            return;
        }
        this.commitQuery(result, holder);
    }

    private double getFraction() {
        return this.myCurrentSize / this.mySize;
    }

    @NotNull
    private List<Query> generateLastQueries(@NotNull List<Query> result, @NotNull List<Object[]> currentStatementParameters, @NotNull Connection connection, @NotNull TransactionStateHolder holder) throws Exception {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        if (currentStatementParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentStatementParameters", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        this.lastBatchQueries(result, holder);
        if (currentStatementParameters.isEmpty()) {
            List<Query> list = this.commitQuery(result, holder);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
            }
            return list;
        }
        String statement = this.getStatement(currentStatementParameters.size());
        PreparedStatement lastStatement = connection.prepareStatement(statement);
        PreparedQuery query = new PreparedQuery(currentStatementParameters, lastStatement, this.myDatabaseDialect, (Consumer<Object[]>)((Consumer)this::handle), this.mySystem, this.myInfo, holder, this.getFraction());
        this.indexPreparedQuery(query, holder, result, currentStatementParameters.size());
        result.add(new CloseStatementQuery(lastStatement));
        List<Query> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        return list;
    }

    @NotNull
    private List<Query> commitQuery(@NotNull List<Query> result, @NotNull TransactionStateHolder holder) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "commitQuery"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "commitQuery"));
        }
        if (!holder.isTransactionSupported() || this.myCurrentStatementsCount < 1000L) {
            List<Query> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "commitQuery"));
            }
            return list;
        }
        result.add(this.getCommitQuery(holder));
        this.myCurrentStatementsCount = 0L;
        List<Query> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "commitQuery"));
        }
        return list;
    }

    @NotNull
    private List<Query> lastCommitQuery(@NotNull List<Query> result, @NotNull TransactionStateHolder holder) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dbimport/ImportQueryGenerator", "lastCommitQuery"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "lastCommitQuery"));
        }
        if (this.myCurrentStatementsCount > 0L && holder.isTransactionSupported()) {
            result.add(new CommitQuery(null, holder));
        }
        List<Query> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "lastCommitQuery"));
        }
        return list;
    }

    @NotNull
    private List<Query> lastBatchQueries(List<Query> result, @NotNull TransactionStateHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "lastBatchQueries"));
        }
        if (this.myBatchQueries.isEmpty()) {
            List<Query> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "lastBatchQueries"));
            }
            return list;
        }
        result.add(new ExecuteBatchQuery(this.myBatchQueries, this.myStatement, holder, this.myInfo, this.myManager));
        this.myBatchQueries = ContainerUtil.newArrayList();
        List<Query> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "lastBatchQueries"));
        }
        return list;
    }

    @NotNull
    private String getStatement(int lines) {
        String string = this.myManager.getInsertStatement(this.myInfo.getContext(), this.myInfo.getTable(), this.myInfo.getConsumersForInsert(), lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "getStatement"));
        }
        return string;
    }

    @NotNull
    private Query getCommitQuery(@NotNull TransactionStateHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator", "getCommitQuery"));
        }
        String lockSql = this.myInfo.shouldLockTable() ? this.myManager.getLockQuery(this.myInfo.getContext(), this.myInfo.getTable()) : null;
        CommitQuery commitQuery = new CommitQuery(lockSql, holder);
        if (commitQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "getCommitQuery"));
        }
        return commitQuery;
    }

    @NotNull
    private BatchRecords receiveParameters() {
        BatchRecords batchRecords;
        try {
            batchRecords = this.myTransferQueue.take();
        }
        catch (InterruptedException e) {
            BatchRecords batchRecords2 = BatchRecords.POISON;
            if (batchRecords2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "receiveParameters"));
            }
            return batchRecords2;
        }
        if (batchRecords == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportQueryGenerator", "receiveParameters"));
        }
        return batchRecords;
    }

    private static class CloseStatementQuery
    implements Query {
        @NotNull
        private final PreparedStatement myStatement;

        CloseStatementQuery(@NotNull PreparedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dbimport/ImportQueryGenerator$CloseStatementQuery", "<init>"));
            }
            this.myStatement = statement;
        }

        @Override
        public void execute(Connection connection, ProgressIndicator indicator) throws Exception {
            JdbcUtil.closeStatementSafe((Statement)this.myStatement);
        }
    }

    private static class CommitQuery
    implements Query {
        @NotNull
        private final TransactionStateHolder myHolder;
        @Nullable
        private final String myLockSql;

        public CommitQuery(@Nullable String lockSql, @NotNull TransactionStateHolder holder) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/ImportQueryGenerator$CommitQuery", "<init>"));
            }
            this.myLockSql = lockSql;
            this.myHolder = holder;
        }

        @Override
        public void execute(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportQueryGenerator$CommitQuery", "execute"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ImportQueryGenerator$CommitQuery", "execute"));
            }
            try {
                connection.commit();
                if (this.myLockSql != null) {
                    DbImplUtil.executeUpdate(connection, this.myLockSql);
                }
            }
            finally {
                this.myHolder.committed(connection);
            }
        }
    }
}

