/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTableEditorWrapper {
    protected final ImportAction.ImportEditorContext myContext;
    private final Map<CsvFormat, ImportDatabaseTableEditor<?>> myMap;
    private final List<TableEditorListener> myListenerList;
    private final DdlPreview myDdlPreview;
    private final TableDialogSettings.Settings mySettings;
    private final String myTableName;
    private final Project myProject;
    private final SqlCodeStyleSettings mySqlSettings;
    protected ImportDatabaseTableEditor<?> myEditor;

    public ImportTableEditorWrapper(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportTableEditorWrapper", "<init>"));
        }
        this.myListenerList = ContainerUtil.newArrayList();
        this.myProject = context.getProject();
        this.myTableName = context.getTableName();
        this.myMap = ContainerUtil.newHashMap();
        this.myContext = context;
        this.myDdlPreview = this.createDdlPreview();
        this.mySettings = this.createSettings();
        this.mySqlSettings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)this.myProject));
        context.getFormats().addFormatChangeListener(this::formatChanged, context.getDisposable());
    }

    @NotNull
    public String getTableName() {
        String string = this.myTableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getTableName"));
        }
        return string;
    }

    @NotNull
    public TableDialogSettings.Settings getSettings() {
        TableDialogSettings.Settings settings = this.mySettings;
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getSettings"));
        }
        return settings;
    }

    @NotNull
    protected TableDialogSettings.Settings createSettings() {
        TableDialogSettings.Settings settings = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE);
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createSettings"));
        }
        return settings;
    }

    @NotNull
    public DdlPreview getDdlPreview() {
        DdlPreview ddlPreview = this.myDdlPreview;
        if (ddlPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getDdlPreview"));
        }
        return ddlPreview;
    }

    @NotNull
    private DdlPreview createDdlPreview() {
        DdlPreview ddlPreview = new DdlPreview(this.myContext, DatabaseDialogsHelper.createAsyncProcessor(this.myProject, "Fetching DDL", this::editorChanged));
        if (ddlPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createDdlPreview"));
        }
        return ddlPreview;
    }

    protected void init() {
        this.changeEditor((CsvFormat)ObjectUtils.assertNotNull((Object)this.myContext.getFormats().getSelectedFormat()));
    }

    public void addEditorListener(@NotNull TableEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ImportTableEditorWrapper", "addEditorListener"));
        }
        this.myListenerList.add(listener);
    }

    private void formatChanged(@NotNull CsvFormatForm source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ImportTableEditorWrapper", "formatChanged"));
        }
        this.changeEditor(source.getFormat());
    }

    private void changeEditor(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportTableEditorWrapper", "changeEditor"));
        }
        TableCsvFormatPreview preview = this.myContext.getPreview();
        preview.setFormat(format);
        if (this.myMap.containsKey(format)) {
            DeTable table = this.myEditor.getTable();
            this.myEditor = this.myMap.get(format);
            this.myEditor.update(table.name, table.comment);
            this.fireEditorChanged(this.myEditor);
        } else {
            this.myEditor = this.createEditor();
            this.myMap.put(format, this.myEditor);
        }
        this.fireEditorChanged(this.myEditor);
    }

    @NotNull
    protected DeTable createTable(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createTable"));
        }
        DeModel oldModel = this.myContext.getModel();
        DeModel newModel = new DeModel(oldModel.getModel(), oldModel.getExportHelper());
        DeTable table = new DeTable(name, this.myContext.getNamespace(), newModel);
        table.name = name;
        table.comment = comment;
        table.columns.addAll(this.createDeColumns(table, newModel));
        newModel.addRoot(table);
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createTable"));
        }
        return deTable;
    }

    @NotNull
    private String getColumnType(@NotNull DataConsumer.Column column, @NotNull List<DataConsumer.Row> rows) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getColumnType"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getColumnType"));
        }
        TypeMerger merger = null;
        ImportManager manager = this.myContext.getManager();
        for (DataConsumer.Row row : rows) {
            String value = (String)column.getValue(row);
            TypeMerger nextMerger = manager.getType(value);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        String string = merger == null ? manager.getStringMerger().getName() : merger.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getColumnType"));
        }
        return string;
    }

    @NotNull
    private List<DeColumn> createDeColumns(@NotNull DeTable table, @NotNull DeModel model) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createDeColumns"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createDeColumns"));
        }
        DataGrid grid = this.myContext.getPreview().getGrid();
        GridModel dataModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List columns = dataModel.getColumns();
        List<DataConsumer.Row> rows = dataModel.getRows();
        ArrayList result = ContainerUtil.newArrayList();
        for (DataConsumer.Column column : columns) {
            DeColumn deColumn = new DeColumn(column.name, table, model);
            deColumn.dataType = this.getColumnType(column, rows);
            result.add(deColumn);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createDeColumns"));
        }
        return arrayList;
    }

    @Nullable
    public ImportDatabaseTableEditor<?> getEditor() {
        return this.myEditor;
    }

    @NotNull
    public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> linkedHashMap = ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "getMapping"));
        }
        return linkedHashMap;
    }

    @NotNull
    private ImportDatabaseTableEditor<?> createEditor() {
        String tableName = this.myEditor == null ? this.myTableName : this.myEditor.getTable().name;
        String tableComment = this.myEditor == null ? null : this.myEditor.getTable().comment;
        DeTable table = this.createTable(tableName, tableComment);
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(this.mySqlSettings));
        TableCsvFormatPreview preview = this.myContext.getPreview();
        GridModel model = preview.getGrid().getDataModel(DataAccessType.DATABASE_DATA);
        List columns = model.getColumns();
        ImportEditorState state = new ImportEditorState(this.myContext, columns);
        ImportDatabaseTableEditor editor = new ImportDatabaseTableEditor(state, this.myContext.getCaps(), tableEditorModel);
        Disposable disposable = this.myContext.getDisposable();
        editor.addListener(this::editorChanged, disposable);
        Disposer.register((Disposable)disposable, editor);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportTableEditorWrapper", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    private void editorChanged() {
        this.myDdlPreview.updatePreview(new ModelTraverserEx(this.mySettings, this.myEditor.getTableModel(), this.myContext.getModel()));
    }

    private void fireEditorChanged(@NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportTableEditorWrapper", "fireEditorChanged"));
        }
        this.editorChanged();
        this.myListenerList.forEach(listener -> {
            if (newEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportTableEditorWrapper", "lambda$fireEditorChanged$0"));
            }
            listener.changed(newEditor);
        });
    }

    public static interface TableEditorListener {
        public void changed(@NotNull DatabaseTableEditor var1);
    }
}

