/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import org.jetbrains.annotations.NotNull;

public class ImportUtil {
    private ImportUtil() {
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull ColumnDescriptor delegate, boolean autogenerated, boolean hasDefault) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor> delegateDescriptor = new AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor>(delegate, autogenerated, hasDefault);
        if (delegateDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return delegateDescriptor;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column, boolean mapped) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        MyDeColumnDescriptor myDeColumnDescriptor = new MyDeColumnDescriptor(column, mapped);
        if (myDeColumnDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportUtil", "createDescriptor"));
        }
        return myDeColumnDescriptor;
    }

    private static class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column, boolean mapped) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$MyDeColumnDescriptor", "<init>"));
            }
            this.myColumn = column;
            this.myMapped = mapped;
        }

        @Override
        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        @Override
        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        @Override
        public int getType() {
            return JdbcUtil.guessJdbcTypeByName((String)this.myColumn.dataType);
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Override
        public String getJavaClassName() {
            return "";
        }

        @Override
        public boolean isAutogenerated() {
            return !this.myMapped && DasUtil.isAutoVal((DasColumn)this.myColumn);
        }

        @Override
        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.getDefault() != null;
        }
    }
}

