/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ExecuteBatchQuery;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.QueryWithParameters;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreparedBatchQuery
extends QueryWithParameters {
    private final List<PreparedBatchQuery> myPreviousBatchQueries;
    private final int myLastQuery;
    private boolean myExecuted;

    PreparedBatchQuery(@NotNull List<Object[]> parameters, @NotNull PreparedStatement preparedStatement, @NotNull DatabaseDialect dialect, @NotNull Consumer<Object[]> errorConsumer, @NotNull DatabaseSystem system, @NotNull ImportInfo info, @NotNull TransactionStateHolder holder, @NotNull List<PreparedBatchQuery> queries, double fraction) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (preparedStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparedStatement", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/PreparedBatchQuery", "<init>"));
        }
        super(parameters, preparedStatement, dialect, errorConsumer, system, info, holder, fraction);
        this.myPreviousBatchQueries = queries;
        this.myLastQuery = queries.size();
    }

    @Override
    void statementCompleted(@NotNull Connection connection, @NotNull ProgressIndicator progressIndicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/PreparedBatchQuery", "statementCompleted"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dbimport/PreparedBatchQuery", "statementCompleted"));
        }
        if (!this.myHolder.canExecuteBatch()) {
            this.myHolder.batchStarted(connection);
        }
        this.myPreparedStatement.addBatch();
        this.myHolder.batchAdded(connection);
    }

    public int executeWithoutBatch(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/PreparedBatchQuery", "executeWithoutBatch"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/PreparedBatchQuery", "executeWithoutBatch"));
        }
        if (this.myExecuted) {
            return 0;
        }
        this.myExecuted = true;
        this.updateIndicatorOnError(indicator);
        try {
            this.completeStatement();
            this.myPreparedStatement.executeUpdate();
            this.myHolder.executed(connection);
        }
        catch (ImportInfo.ConversionException e) {
            return this.executeWithoutMultiLines(connection, indicator);
        }
        catch (AbstractTransactionStateHolder.IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException ex) {
            this.myHolder.onExecuteError(connection);
            return this.executeWithoutMultiLines(connection, indicator);
        }
        return this.myParameters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onError(@NotNull Connection connection, @NotNull ProgressIndicator indicator, @NotNull Exception e) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/PreparedBatchQuery", "onError"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/PreparedBatchQuery", "onError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dbimport/PreparedBatchQuery", "onError"));
        }
        this.myHolder.onAddBatchRecordError(connection);
        try {
            this.myPreparedStatement.clearBatch();
            ExecuteBatchQuery.executeWithoutBatch(connection, this.myPreviousBatchQueries, indicator, this.myHolder, this.myManager, this.myInfo, this.myLastQuery);
            this.executeWithoutBatch(connection, indicator);
            ExecuteBatchQuery.tryCommit(connection, this.myHolder, this.myManager, this.myInfo, 1000);
        }
        finally {
            this.myHolder.batchExecuted(connection);
        }
    }
}

