/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.Query;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class QueryWithParameters
implements Query {
    protected final PreparedStatement myPreparedStatement;
    protected final List<Object[]> myParameters;
    protected final ImportManager myManager;
    protected final ImportInfo myInfo;
    protected final TransactionStateHolder myHolder;
    private final Consumer<Object[]> myErrorConsumer;
    protected final double myFraction;

    QueryWithParameters(@NotNull List<Object[]> parameters, @NotNull PreparedStatement preparedStatement, @NotNull DatabaseDialect dialect, @NotNull Consumer<Object[]> errorConsumer, @NotNull DatabaseSystem system, @NotNull ImportInfo info, @NotNull TransactionStateHolder holder, double fraction) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (preparedStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparedStatement", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/QueryWithParameters", "<init>"));
        }
        this.myParameters = parameters;
        this.myHolder = holder;
        this.myPreparedStatement = preparedStatement;
        this.myManager = ImportManager.of(dialect, system.getDatabaseProductVersion());
        this.myFraction = fraction;
        this.myInfo = info;
        this.myErrorConsumer = errorConsumer;
    }

    @Override
    public void execute(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/QueryWithParameters", "execute"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/QueryWithParameters", "execute"));
        }
        this.updateIndicator(indicator);
        try {
            this.completeStatement();
            this.statementCompleted(connection, indicator);
        }
        catch (AbstractTransactionStateHolder.IllegalTransactionStateException e) {
            throw e;
        }
        catch (Exception e) {
            this.onError(connection, indicator, e);
        }
    }

    final void completeStatement() throws Exception {
        for (Object[] line : this.myParameters) {
            this.myInfo.statementWorker().fillStatement(this.myPreparedStatement, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int executeWithoutMultiLines(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/QueryWithParameters", "executeWithoutMultiLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/QueryWithParameters", "executeWithoutMultiLines"));
        }
        this.updateIndicatorOnError(indicator);
        PreparedStatement statement = connection.prepareStatement(this.myManager.getInsertStatement(this.myInfo.getContext(), this.myInfo.getTable(), this.myInfo.getConsumersForInsert(), 1));
        int result = 0;
        try {
            for (Object[] line : this.myParameters) {
                try {
                    this.myInfo.statementWorker().fillStatement(statement, line);
                    statement.executeUpdate();
                    ++result;
                    this.myHolder.executed(connection);
                }
                catch (ImportInfo.ConversionException e) {
                    this.myErrorConsumer.consume((Object)line);
                }
                catch (AbstractTransactionStateHolder.IllegalTransactionStateException e) {
                    throw e;
                }
                catch (SQLException ex) {
                    this.myHolder.onExecuteError(connection);
                    this.myErrorConsumer.consume((Object)line);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        return result;
    }

    private void updateIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/QueryWithParameters", "updateIndicator"));
        }
        indicator.checkCanceled();
        indicator.setFraction(this.myFraction);
    }

    final void updateIndicatorOnError(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/QueryWithParameters", "updateIndicatorOnError"));
        }
        indicator.checkCanceled();
        if (Double.compare(indicator.getFraction(), this.myFraction) < 0) {
            indicator.setFraction(this.myFraction);
        }
    }

    abstract void statementCompleted(@NotNull Connection var1, @NotNull ProgressIndicator var2) throws Exception;

    abstract void onError(@NotNull Connection var1, @NotNull ProgressIndicator var2, @NotNull Exception var3) throws Exception;
}

