/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.BatchRecords;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReaderTask
implements Runnable {
    private static final String IO_ERROR = "Import failed. Can't access file.";
    private static final String MANY_CHARS_ERROR = "There are very big records in file or file format is incorrect";
    private final Project myProject;
    private final LinkedTransferQueue<BatchRecords> myTransferQueue;
    private final Input myInput;
    private volatile boolean myStopped;

    ReaderTask(@NotNull Input input, @NotNull Project project, @NotNull LinkedTransferQueue<BatchRecords> transferQueue) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        if (transferQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferQueue", "com/intellij/database/dbimport/ReaderTask", "<init>"));
        }
        this.myTransferQueue = transferQueue;
        this.myProject = project;
        this.myInput = input;
    }

    void stop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Input input = this.myInput;){
            BatchRecords records;
            while ((records = input.read()) != null) {
                this.send(records);
            }
        }
        catch (InterruptedException e) {
            this.onStop();
        }
        catch (IOException e) {
            this.onError(IO_ERROR);
        }
        catch (Exception e) {
            this.onError(e.getMessage());
        }
        finally {
            this.poisonQueue();
        }
    }

    private void poisonQueue() {
        if (this.myStopped) {
            return;
        }
        this.send(BatchRecords.POISON);
        this.myStopped = true;
    }

    private void send(@NotNull BatchRecords parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/ReaderTask", "send"));
        }
        try {
            this.myTransferQueue.transfer(parameters);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onStop();
        }
    }

    private void onStop() {
        if (this.myStopped) {
            return;
        }
        this.myTransferQueue.clear();
        this.myTransferQueue.offer(BatchRecords.POISON);
        this.myStopped = true;
    }

    private void onError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/ReaderTask", "onError"));
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myProject);
    }

    public static interface Input
    extends AutoCloseable {
        @Nullable
        public BatchRecords read() throws BigRecordException, InterruptedException, IOException;

        public double getSizeOfData();
    }

    public static class BigRecordException
    extends RuntimeException {
        public BigRecordException() {
            super(ReaderTask.MANY_CHARS_ERROR);
        }
    }
}

