/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.state;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransactionStateHolder
implements TransactionStateHolder {
    private static final Logger LOG = Logger.getInstance(AbstractTransactionStateHolder.class);
    static final String CHECK_CONNECTION = "Check connection and database settings and try again";
    static final String ROLLBACK_ERROR = "Can't rollback changes with error records. Check connection and database settings and try again";
    static final String SAVE_ERROR = "Can't save current transaction state. Check connection and database settings and try again";
    protected final boolean mySupportTransactions;
    private final boolean mySupportSavepoints;
    private final ImportInfo myInfo;
    private final ImportManager myManager;
    int myBatchCount;
    private Savepoint myLastState;

    protected AbstractTransactionStateHolder(@NotNull ImportInfo info, @NotNull ImportManager manager, boolean transactions, boolean supportSavepoints) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "<init>"));
        }
        this.mySupportTransactions = transactions;
        this.mySupportSavepoints = supportSavepoints;
        this.myInfo = info;
        this.myManager = manager;
    }

    @Override
    public void batchExecuted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchExecuted"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void batchAdded(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchAdded"));
        }
        ++this.myBatchCount;
    }

    @Override
    public void onAddBatchRecordError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "onAddBatchRecordError"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void onExecuteBatchError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "onExecuteBatchError"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void batchStarted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchStarted"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public boolean canExecuteBatch() {
        return this.myBatchCount > 0;
    }

    @Override
    public void committed(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "committed"));
        }
        this.myLastState = null;
        this.myBatchCount = 0;
    }

    void checkoutLastState(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "checkoutLastState"));
        }
        this.run((ThrowableRunnable<SQLException>)((ThrowableRunnable)() -> {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "lambda$checkoutLastState$0"));
            }
            this.myLastState = connection.setSavepoint();
        }), SAVE_ERROR);
    }

    void rollbackToLastState(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "rollbackToLastState"));
        }
        this.run((ThrowableRunnable<SQLException>)((ThrowableRunnable)() -> {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "lambda$rollbackToLastState$1"));
            }
            if (this.myLastState == null) {
                connection.rollback();
                return;
            }
            connection.rollback(this.myLastState);
        }), ROLLBACK_ERROR);
    }

    boolean isSupportTransactions() {
        return this.mySupportTransactions;
    }

    boolean isSupportSavepoints() {
        return this.mySupportSavepoints;
    }

    void releaseLastState(@NotNull Connection connection, @NotNull String message) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "releaseLastState"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "releaseLastState"));
        }
        try {
            this.run((ThrowableRunnable<SQLException>)((ThrowableRunnable)() -> {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "lambda$releaseLastState$2"));
                }
                if (this.myLastState != null) {
                    connection.releaseSavepoint(this.myLastState);
                }
            }), message);
        }
        finally {
            this.myLastState = null;
        }
    }

    protected void lock(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "lock"));
        }
        if (!this.myInfo.shouldLockTable()) {
            return;
        }
        String lockSql = this.myManager.getLockQuery(this.myInfo.getContext(), this.myInfo.getTable());
        if (lockSql != null) {
            DbImplUtil.executeUpdate(connection, lockSql);
        }
    }

    void run(@NotNull ThrowableRunnable<SQLException> runnable, @NotNull String message) throws SQLException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "run"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "run"));
        }
        try {
            runnable.run();
        }
        catch (SQLException e) {
            LOG.warn("Batches: " + this.myBatchCount);
            LOG.warn(message);
            LOG.warn((Throwable)e);
            throw new IllegalTransactionStateException(e, message);
        }
    }

    public static class IllegalTransactionStateException
    extends SQLException {
        public IllegalTransactionStateException(Throwable cause, String error) {
            super(error, cause);
        }
    }
}

