/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.state;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DefaultTransactionStateHolder
extends AbstractTransactionStateHolder {
    public DefaultTransactionStateHolder(@NotNull ImportInfo info, @NotNull ImportManager manager, boolean transactions, boolean supportSavepoints) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "<init>"));
        }
        super(info, manager, transactions, supportSavepoints);
    }

    @Override
    public void executed(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "executed"));
        }
        this.releaseLastState(connection, "Can't save current transaction state. Check connection and database settings and try again");
        this.checkoutLastState(connection);
    }

    @Override
    public void onExecuteError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "onExecuteError"));
        }
        this.rollbackToLastState(connection);
        this.lock(connection);
    }

    @Override
    public void onAddBatchRecordError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "onAddBatchRecordError"));
        }
        this.onExecuteBatchError(connection);
    }

    @Override
    public void batchExecuted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "batchExecuted"));
        }
        super.batchExecuted(connection);
        this.releaseLastState(connection, "Can't save current transaction state. Check connection and database settings and try again");
        this.checkoutLastState(connection);
    }

    @Override
    public void onExecuteBatchError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "onExecuteBatchError"));
        }
        if (this.myBatchCount == 0) {
            return;
        }
        super.onExecuteBatchError(connection);
        this.rollbackToLastState(connection);
        this.lock(connection);
    }

    @Override
    public void batchStarted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/DefaultTransactionStateHolder", "batchStarted"));
        }
        super.batchStarted(connection);
        this.releaseLastState(connection, "Can't save current transaction state. Check connection and database settings and try again");
        this.checkoutLastState(connection);
    }

    @Override
    public boolean isTransactionSupported() {
        return this.isSupportSavepoints() && this.isSupportTransactions();
    }
}

