/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.AbstractDb2Dialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.db2.Db2DdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Dialect
extends AbstractDb2Dialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    private String myExplainPlanQuery;

    public Db2Dialect() {
        super(META_MODEL, new TypeHelper.DB2TypeHelper(), new KeywordHelper.Db2Keywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.DB2;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Ibm;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("DB2" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "getDisplayName"));
        }
        return "DB2";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/Db2Dialect", "supportsProduct"));
        }
        return databaseProductName != null && databaseProductName.trim().startsWith("DB2");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumn"));
        }
        boolean autoInc = DasUtil.isAutoVal((DasColumn)column);
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ADD", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        if (autoInc) {
            builder.type("INTEGER");
        } else {
            builder.type((DasTypedObject)column);
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, (autoInc ? "NOT NULL " : "") + "WITH DEFAULT", autoInc ? "0" : column.getDefault());
        builder.newStatement();
        if (autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column).space().keywords("DROP", "DEFAULT").newStatement();
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column).space().keywords("SET");
            this.generated(builder).newStatement();
        }
        if (column.isNotNull() && !autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ADD", "CONSTRAINT").space();
            builder.columnRef((DasObject)column).space();
            builder.keyword("CHECK").space().symbol("(");
            builder.columnRef((DasObject)column).space();
            builder.keyword("IS NOT NULL").symbol(")");
            builder.newStatement();
        }
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            this.sqlAlterColumnComment(builder, column);
            builder.newStatement();
        }
        Db2Dialect.reorgTable(builder, column.getTable());
        if (autoInc) {
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keyword("SET").space();
            builder.columnRef((DasObject)column).space().plain("=").space().keyword("DEFAULT").newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public SearchPath tryToLoadSearchPath(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/Db2Dialect", "tryToLoadSearchPath"));
        }
        String s = DbImplUtil.concatStringResults(connection, this, "values (current_schema)", 1, DbImplUtil.ConcatenationProps.LINES);
        return SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Arrays.asList("", s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/Db2Dialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dialects/Db2Dialect", "getNameForKind"));
        }
        return kind == ObjectKind.PACKAGE ? "MODULE" : super.getNameForKind(kind);
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/Db2Dialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlDefineColumn"));
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoVal((DasColumn)column) ? this.generated(builder) : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlDropSchema"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dialects/Db2Dialect", "sqlDropSchema"));
        }
        DdlBuilder ddlBuilder = super.sqlDropSchema(builder, namespace).space().keyword("RESTRICT");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlDropSchema"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "generated"));
        }
        DdlBuilder ddlBuilder = builder.space().keywords("GENERATED", "ALWAYS", "AS", "IDENTITY").plain("(").keywords("START", "WITH").space().literal("1").space().keywords("INCREMENT", "BY").space().literal("1").plain(")");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "generated"));
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new Db2DdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnComment"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull());
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnComment"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnNullable"));
        }
        Db2Dialect.getColumnNullableAlterSQL(builder, column, !column.isNotNull());
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, column.getTable());
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnNullable"));
        }
        return ddlBuilder;
    }

    private static DdlBuilder reorgTable(DdlBuilder builder, DasTable table) {
        builder.keyword("CALL SYSPROC").symbol(".").keyword("ADMIN_CMD").symbol("(");
        builder.symbol("'").plain("REORG TABLE ").qualifiedRef((DasObject)table).symbol("'").symbol(")");
        builder.newStatement();
        return builder;
    }

    @NotNull
    private static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean nullable) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "getColumnNullableAlterSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "getColumnNullableAlterSQL"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword("ALTER COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("SET").space();
        builder.keyword(nullable ? "NULL" : "NOT NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "getColumnNullableAlterSQL"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnType"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnType"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnType"));
        }
        super.sqlAlterColumnType(builder, from, to);
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, from.getTable());
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnType"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnDefault"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAlterColumnDefault"));
        }
        return ddlBuilder;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumnAutoIncrement"));
        }
        String tableName = column.getTable().getName();
        String columnName = column.getName();
        String sequenceName = tableName.toUpperCase(Locale.ENGLISH) + "_" + columnName.toUpperCase(Locale.ENGLISH) + "_SEQ";
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column, sequenceName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/Db2Dialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/Db2Dialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/Db2Dialect", "sqlAddUniqueConstraint"));
        }
        for (DasColumn column : columns) {
            if (column.isNotNull()) continue;
            Db2Dialect.getColumnNullableAlterSQL(builder, column, false).newStatement();
            Db2Dialect.reorgTable(builder, table);
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns);
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, table);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache, cycle ? "CYCLE" : "NO CYCLE");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlAlterSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/Db2Dialect", "sqlDropSequence"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlDropSequence"));
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/Db2Dialect", "sqlViewDefinition"));
        }
        return Pair.create((Object)("SELECT TEXT FROM SYSCAT.VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(VIEWNAME) = '" + element.getName().toUpperCase(Locale.ENGLISH) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/Db2Dialect", "sqlProcedureDefinition"));
        }
        StringBuilder createViewSql = new StringBuilder();
        DasRoutine.Kind type = element.getRoutineKind();
        createViewSql.append("SELECT TEXT FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA='");
        createViewSql.append(DasUtil.getSchema((DasObject)element));
        createViewSql.append("' AND UPPER(ROUTINENAME) = '");
        createViewSql.append(element.getName().toUpperCase(Locale.ENGLISH));
        createViewSql.append("' AND ROUTINETYPE = '");
        createViewSql.append(type == DasRoutine.Kind.FUNCTION ? "F" : "P");
        createViewSql.append("'");
        Pair pair = Pair.create((Object)createViewSql.toString(), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/Db2Dialect", "sqlSequenceInformation"));
        }
        builder.keyword("SELECT").space();
        boolean first = true;
        for (String part : new String[]{"NEXTCACHEFIRSTVALUE", "MAXVALUE", "MINVALUE", "CACHE", "INCREMENT", "CYCLE"}) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.ref(null, part);
        }
        builder.space();
        builder.keyword("FROM").space().ref(null, "SYSCAT.SEQUENCES").space();
        builder.keyword("WHERE").space();
        if (DasUtil.getSchema((DasObject)sequence) != null) {
            builder.ref(null, "SEQSCHEMA").space().symbol("=").space().plain("upper").symbol("(").literal("'" + DasUtil.getSchema((DasObject)sequence) + "'").symbol(")").space().keyword("AND").space();
        }
        builder.ref(null, "SEQNAME").symbol("=").space().symbol("'").ref((DasObject)sequence, sequence.getName()).symbol("'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlSequenceInformation"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull Connection connection) throws Exception {
        int token;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/Db2Dialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/Db2Dialect", "tryToLoadTableDefinition"));
        }
        CallableStatement statement = connection.prepareCall("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        try {
            statement.setString(1, QNameUtil.getQualifiedName((DasObject)table));
            statement.registerOutParameter(2, 4);
            statement.executeUpdate();
            token = statement.getInt(2);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        String string = DbImplUtil.concatStringResults(connection, this, "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + token, 1, DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/Db2Dialect", "isValidPlainIdentifier"));
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    private void ensureScriptLoaded() {
        if (this.myExplainPlanQuery == null) {
            try {
                URL resource = Db2Dialect.class.getClassLoader().getResource("resources/db2.explain_last.sql");
                if (resource != null) {
                    this.myExplainPlanQuery = FileUtil.loadFile((File)new File(resource.toURI()));
                    return;
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.myExplainPlanQuery = "";
        }
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/Db2Dialect", "sqlExplainPlan"));
        }
        this.ensureScriptLoaded();
        if (this.myExplainPlanQuery.isEmpty()) {
            throw new UnsupportedOperationException("explain_last script not found");
        }
        builder.keywords("explain", "plan").space().keyword("for").space().plain(statement).newStatement().plain(this.myExplainPlanQuery);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return true;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/Db2Dialect", "appendRowId"));
        }
        String ridCall = String.format("RID(%s) as \"RID(%s)\"", "t", "t");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal(ridCall);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/Db2Dialect", "appendRowId"));
        }
        return ddlBuilder;
    }
}

