/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNames {
    private static final Pattern SCALE_OPT = Pattern.compile("\\[([^\\[\\]]*)\\$s([^\\[\\]]*)\\]");
    private final MultiMap<String, Integer> myTypeNames = MultiMap.createSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final TIntObjectHashMap<MyMultiMap> myTypeMap = new TIntObjectHashMap();

    protected Collection<String> get(int jdbcType) {
        return this.getImpl(jdbcType, false).get((Object)Integer.MAX_VALUE);
    }

    private MultiMap<Integer, String> getImpl(int jdbcType, boolean createIfMissing) {
        MyMultiMap map = (MyMultiMap)((Object)this.myTypeMap.get(jdbcType));
        if (map == null && createIfMissing) {
            map = new MyMultiMap();
            this.myTypeMap.put(jdbcType, (Object)map);
        }
        return map == null ? MultiMap.EMPTY : map;
    }

    @Nullable
    public String get(int jdbcType, int size, int precision, int scale) {
        MultiMap map = (MultiMap)this.myTypeMap.get(jdbcType);
        if (map != null && map.size() > 0) {
            for (Map.Entry o : map.entrySet()) {
                if (size > (Integer)o.getKey()) continue;
                return TypeNames.replace((String)ContainerUtil.iterateAndGetLastItem((Iterable)((Iterable)o.getValue())), size, precision, scale);
            }
        }
        return TypeNames.replace((String)ContainerUtil.iterateAndGetLastItem(this.get(jdbcType)), size, precision, scale);
    }

    @Nullable
    private static String replace(String type, int size, int precision, int scale) {
        type = TypeNames.replaceOnceOrOpt(type, "$s", SCALE_OPT, scale);
        type = TypeNames.replaceOnce(type, "$l", size);
        return TypeNames.replaceOnce(type, "$p", precision);
    }

    public void put(int jdbcType, int capacity, String value) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value).typeName, (Object)jdbcType);
        MyMultiMap map = (MyMultiMap)((Object)this.myTypeMap.get(jdbcType));
        if (map == null) {
            map = new MyMultiMap();
            this.myTypeMap.put(jdbcType, (Object)map);
        }
        map.putValue(capacity, value);
    }

    public void put(int jdbcType, String value) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value).typeName, (Object)jdbcType);
        this.getImpl(jdbcType, true).putValue((Object)Integer.MAX_VALUE, (Object)value);
    }

    @NotNull
    public String getType(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        int minSize = Integer.MAX_VALUE;
        String minName = name;
        for (Integer jdbcType : this.myTypeNames.get((Object)name)) {
            MultiMap map = (MultiMap)this.myTypeMap.get(jdbcType.intValue());
            for (Map.Entry e : map.entrySet()) {
                int upperBound = (Integer)e.getKey();
                if (length > 0 && length > upperBound || upperBound > minSize) continue;
                for (String s : (Collection)e.getValue()) {
                    String replace = TypeNames.replace(s, length, precision, scale);
                    if (replace == null || !TypeNames.isSamePrefix(name, replace)) continue;
                    minName = replace;
                    minSize = upperBound;
                }
            }
        }
        String string = minName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        return string;
    }

    @Nullable
    static String replaceOnce(@Nullable String template, @NotNull String placeholder, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnce"));
        }
        if (template == null) {
            return null;
        }
        if (template.contains(placeholder) && replacement < 0) {
            return null;
        }
        return template.replace(placeholder, String.valueOf(replacement));
    }

    @Nullable
    static String replaceOnceOrOpt(@Nullable String template, @NotNull String placeholder, @NotNull Pattern pattern, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (template == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(template);
        if (!matcher.find()) {
            return TypeNames.replaceOnce(template, placeholder, replacement);
        }
        return matcher.replaceFirst(replacement <= 0 ? "" : "$1" + Matcher.quoteReplacement(String.valueOf(replacement)) + "$2");
    }

    private static boolean isSamePrefix(@NotNull String typeName, @NotNull String replaced) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/dialects/TypeNames", "isSamePrefix"));
        }
        if (replaced == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaced", "com/intellij/database/dialects/TypeNames", "isSamePrefix"));
        }
        if (!replaced.startsWith(typeName)) {
            return false;
        }
        if (replaced.length() == typeName.length()) {
            return true;
        }
        return replaced.charAt(typeName.length()) == '(';
    }

    public int findTypeCode(@NotNull String spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/intellij/database/dialects/TypeNames", "findTypeCode"));
        }
        DataType dataType = DataTypeFactory.of(spec);
        int length = dataType.getLength();
        int def = 1111;
        for (Integer jdbcType : this.myTypeNames.get((Object)dataType.typeName)) {
            MultiMap map = (MultiMap)this.myTypeMap.get(jdbcType.intValue());
            for (Map.Entry e : map.entrySet()) {
                if (length > 0 && length > (Integer)e.getKey()) continue;
                for (String s : (Collection)e.getValue()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)s, (CharSequence)spec)) continue;
                    return jdbcType;
                }
                if ((Integer)e.getKey() == Integer.MAX_VALUE) {
                    def = jdbcType;
                    continue;
                }
                return jdbcType;
            }
        }
        return def;
    }

    private static class MyMultiMap
    extends MultiMap<Integer, String> {
        private MyMultiMap() {
        }

        @NotNull
        protected Collection<String> createCollection() {
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames$MyMultiMap", "createCollection"));
            }
            return linkedHashSet;
        }

        @NotNull
        protected Map<Integer, Collection<String>> createMap() {
            TreeMap<Integer, Collection<String>> treeMap = new TreeMap<Integer, Collection<String>>();
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames$MyMultiMap", "createMap"));
            }
            return treeMap;
        }
    }
}

