/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpinnerAction
extends DumbAwareAction
implements CustomComponentAction {
    protected JSpinner myField;

    protected SpinnerAction(@NotNull SpinnerModel model, String text, String description, Icon icon) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/diff/SpinnerAction", "<init>"));
        }
        super(text, description, icon);
        this.myField = new JSpinner(model);
        this.myField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerAction.this.actionPerformed(null);
            }
        });
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public void actionPerformed(@Nullable AnActionEvent e) {
        Object value = this.getValue();
        if (!Comparing.equal((Object)value, (Object)this.myField.getModel().getValue())) {
            this.setValue(this.myField.getModel().getValue());
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Object value = this.getValue();
        if (!Comparing.equal((Object)value, (Object)this.myField.getModel().getValue())) {
            this.myField.getModel().setValue(this.getValue());
        }
        this.myField.setEnabled(e.getPresentation().isEnabled());
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(presentation.getText());
        label.setOpaque(true);
        label.setBackground(this.myField.getBackground());
        this.myField.setOpaque(true);
        panel.add((Component)this.myField, "East");
        panel.add((Component)label, "West");
        this.myField.setToolTipText(presentation.getDescription());
        label.setToolTipText(presentation.getDescription());
        this.myField.setOpaque(true);
        panel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return panel;
    }
}

