/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.argument;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.MysqlArguments;
import com.intellij.database.dump.dbdump.PgArguments;
import com.intellij.database.dump.dbdump.argument.StringDumpArgument;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StringDumpArgumentImpl implements StringDumpArgument
{
    PG_DATABASE("Database", PgArguments.DB_NAME){

        @Override
        @NotNull
        public String getPrefix() {
            String string = DbDumpUtil.extractParameterizable(PgArguments.DB_NAME);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getPrefix"));
            }
            return string;
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getUnquoter"));
            }
            return function;
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getComponentValue"));
            }
            return cd.contains(PgArguments.DB_NAME) ? (current.isArgument() ? DbDumpUtil.cutParameter(text, current, next) : null) : current.getText();
        }

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "isMyLexeme"));
            }
            return cd.contains(PgArguments.DB_NAME) && super.isMyLexeme(text, current, next, cd) || current.isParameter() && !cd.checkedOut(this);
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getStringsFromElements"));
            }
            List<String> list = DbDumpUtil.fromElementsToSeparated(elements, (Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$1", "getStringsFromElements"));
            }
            return list;
        }
    }
    ,
    PG_TABLE("Tables", PgArguments.TABLE){

        @Override
        @NotNull
        public String getPrefix() {
            String string = DbDumpUtil.extractParameterizable(PgArguments.TABLE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getPrefix"));
            }
            return string;
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = s -> s;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = s -> s;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getUnquoter"));
            }
            return function;
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getComponentValue"));
            }
            return DbDumpUtil.cutParameter(text, current, next);
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getStringsFromElements"));
            }
            List<String> list = DbDumpUtil.getTablesNames(elements);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$2", "getStringsFromElements"));
            }
            return list;
        }
    }
    ,
    PG_SCHEMA("Schemas", PgArguments.SCHEMA){

        @Override
        @NotNull
        public String getPrefix() {
            String string = DbDumpUtil.extractParameterizable(PgArguments.SCHEMA);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getPrefix"));
            }
            return string;
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::pgQuote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = s -> StringUtil.unquoteString((String)StringUtil.unquoteString((String)s));
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getUnquoter"));
            }
            return function;
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getComponentValue"));
            }
            return DbDumpUtil.cutParameter(text, current, next);
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getStringsFromElements"));
            }
            List<String> list = DbDumpUtil.fromElementsToSeparated(elements, (Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$3", "getStringsFromElements"));
            }
            return list;
        }
    }
    ,
    MYSQL_DATABASES("Databases", new String[0]){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getUnquoter"));
            }
            return function;
        }

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "isMyLexeme"));
            }
            return current.isParameter() && (!cd.checkedOut(this) || !StringDumpArgumentImpl.isOneDatabase(cd));
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getComponentValue"));
            }
            return current.getText();
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getStringsFromElements"));
            }
            List<String> list = DbDumpUtil.fromElementsToSeparated(elements, (Condition<DbElement>)DasUtil.byClass(DbNamespaceImpl.class));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$4", "getStringsFromElements"));
            }
            return list;
        }
    }
    ,
    MYSQL_TABLES("Tables", new String[0]){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getUnquoter"));
            }
            return function;
        }

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "isMyLexeme"));
            }
            return current.isParameter() && StringDumpArgumentImpl.isOneDatabase(cd) && cd.checkedOut(this);
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getComponentValue"));
            }
            return current.getText();
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getStringsFromElements"));
            }
            List<String> list = DbDumpUtil.fromElementsToSeparated(elements, (Condition<DbElement>)DasUtil.byClass(DbTable.class));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$5", "getStringsFromElements"));
            }
            return list;
        }
    }
    ,
    MYSQL_PATH("Out path", MysqlArguments.RESULT_FILE){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getUnquoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public String getPrefix() {
            String string = DbDumpUtil.extractParameterizable(MysqlArguments.RESULT_FILE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getPrefix"));
            }
            return string;
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$6", "getComponentValue"));
            }
            return DbDumpUtil.cutParameter(text, current, next);
        }
    }
    ,
    PG_PATH("Out path", PgArguments.OUT_PATH){

        @Override
        @NotNull
        public String getPrefix() {
            String string = DbDumpUtil.extractParameterizable(PgArguments.OUT_PATH);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getPrefix"));
            }
            return string;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getUnquoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbDumpUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getQuoter"));
            }
            return function;
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl$7", "getComponentValue"));
            }
            return DbDumpUtil.cutParameter(text, current, next);
        }
    };

    private final String[] myOptions;
    private final String myUiName;

    private StringDumpArgumentImpl(String uiName, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "<init>"));
        }
        this.myOptions = options;
        this.myUiName = uiName;
    }

    @Override
    @NotNull
    public String getPrefix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getPrefix"));
        }
        return "";
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "isMyLexeme"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "isMyLexeme"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "isMyLexeme"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "isMyLexeme"));
        }
        return ArrayUtil.find((Object[])this.myOptions, (Object)current.getText()) != -1;
    }

    @Override
    @NotNull
    public Function<String, String> getQuoter() {
        Function<String, String> function = s -> s;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getQuoter"));
        }
        return function;
    }

    @Override
    @NotNull
    public Function<String, String> getUnquoter() {
        Function<String, String> function = s -> s;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getUnquoter"));
        }
        return function;
    }

    @Override
    @NotNull
    public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getStringsFromElements"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getStringsFromElements"));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getStringsFromElements"));
        }
        return list;
    }

    @Override
    @NotNull
    public String[] getArguments() {
        if (this.myOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getArguments"));
        }
        return this.myOptions;
    }

    @Override
    @NotNull
    public String getUiName() {
        String string = this.myUiName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getUiName"));
        }
        return string;
    }

    @NotNull
    public String[] getOptions() {
        if (this.myOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "getOptions"));
        }
        return this.myOptions;
    }

    private static boolean isOneDatabase(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/StringDumpArgumentImpl", "isOneDatabase"));
        }
        return !cd.contains(MysqlArguments.DATABASES) || cd.getLexemeIndex("--tables") > cd.getLexemeIndex(MysqlArguments.DATABASES);
    }
}

