/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableFileEditor
extends TableEditorBase
implements NavigatableFileEditor,
DataProvider,
DocumentReferenceProvider {
    private final VirtualFile myFile;
    private final EditorTableResultPanel myResultPanel;
    private final JPanel myRootPanel;

    public DatabaseTableFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseTableFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseTableFileEditor", "<init>"));
        }
        super(project);
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myFile = file;
        DatabaseTableGridDataHookUp hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this);
        this.myResultPanel = new EditorTableResultPanel(project, hookUp){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = "editor:" + DatabaseTableFileEditor.this.getFile().getPresentableName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$1", "getDisplayName"));
                }
                return string;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myResultPanel);
        DataGridUtil.setupProgressIndicatingAuditor(this.myResultPanel);
        DeferredLoader.installOn(this.myResultPanel);
        DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this);
        DataGridUtil.addGridHeaderComponent(this.myResultPanel, this.myFile);
        this.myRootPanel.add((Component)this.myResultPanel.getComponent(), "Center");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor");
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        EditorTableResultPanel editorTableResultPanel = this.myResultPanel;
        if (editorTableResultPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor", "getDataGrid"));
        }
        return editorTableResultPanel;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.table.editor";
        }
        return null;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/database/editor/DatabaseTableFileEditor", "canNavigateTo"));
        }
        return navigatable instanceof DatabaseOpenFileDescriptor;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/database/editor/DatabaseTableFileEditor", "navigateTo"));
        }
        if (!(navigatable instanceof DatabaseOpenFileDescriptor)) {
            return;
        }
        DeferredLoader.doWhenLoaded(this.myResultPanel, () -> {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/database/editor/DatabaseTableFileEditor", "lambda$navigateTo$0"));
            }
            ((DatabaseOpenFileDescriptor)navigatable).navigateTo(this.myResultPanel);
        });
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/database/editor/DatabaseTableFileEditor", "getState"));
        }
        if (level == FileEditorStateLevel.FULL) {
            State state = new State();
            this.updateColumnAttributes(state.columnAttributes);
            this.updateFilterState(state.filter);
            State state2 = state;
            if (state2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor", "getState"));
            }
            return state2;
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor", "getState"));
        }
        return fileEditorState;
    }

    private void updateFilterState(@NotNull State.Filter filterState) {
        if (filterState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterState", "com/intellij/database/editor/DatabaseTableFileEditor", "updateFilterState"));
        }
        filterState.enabled = this.myResultPanel.isFilteringEnabled();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        filterState.applied = this.isDragging() && model != null && model.isFilterApplied();
        filterState.text = model == null ? "" : model.getFilterText();
        filterState.history.clear();
        filterState.history.addAll(this.myResultPanel.getFiltersHistory());
    }

    private void updateColumnAttributes(@NotNull List<State.Column> columnAttributes) {
        if (columnAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnAttributes", "com/intellij/database/editor/DatabaseTableFileEditor", "updateColumnAttributes"));
        }
        columnAttributes.clear();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA);
        for (ModelIndex columnIdx : model.getColumnIndices().asIterable()) {
            DataConsumer.Column column = model.getColumn(columnIdx);
            String columnName = column != null ? column.name : null;
            boolean enabled = this.myResultPanel.isColumnEnabled(columnIdx);
            Language contentLanguage = this.myResultPanel.getContentLanguage(columnIdx);
            if (columnName == null || enabled && contentLanguage == Language.ANY) continue;
            State.Column attributes = new State.Column();
            attributes.name = columnName;
            attributes.enabled = enabled;
            attributes.languageId = contentLanguage.getID();
            columnAttributes.add(attributes);
        }
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/editor/DatabaseTableFileEditor", "setState"));
        }
        State s = (State)ObjectUtils.tryCast((Object)state, State.class);
        if (s != null) {
            this.applyColumnAttributes(s.columnAttributes);
            this.applyFilterState(s.filter);
        }
    }

    private void applyColumnAttributes(@Nullable List<State.Column> columnAttributes) {
        if (ContainerUtil.isEmpty(columnAttributes)) {
            return;
        }
        Map props = ContainerUtilRt.newHashMap((int)columnAttributes.size());
        for (State.Column attributes : columnAttributes) {
            Language contentLanguage = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)attributes.languageId), (Object)Language.ANY);
            props.put(attributes.name, new EditorTableResultPanel.InitialColumnProperties(attributes.enabled, contentLanguage));
        }
        if (!props.isEmpty()) {
            this.myResultPanel.setInitialColumnProperties(props);
        }
    }

    private void applyFilterState(@Nullable State.Filter filterState) {
        if (filterState == null) {
            return;
        }
        List<Object> filterHistory = filterState.history != null ? filterState.history : ContainerUtil.newArrayList();
        this.myResultPanel.setFiltersHistory(filterHistory);
        if (this.myResultPanel.isFilteringEnabled() != filterState.enabled) {
            this.myResultPanel.toggleFiltering();
        }
        if (!this.isDragging()) {
            return;
        }
        if (filterState.applied) {
            String item = (String)ContainerUtil.getFirstItem((List)filterHistory);
            this.myResultPanel.setFilterText(item == null ? "" : item, -1);
            this.myResultPanel.applyFilter();
            return;
        }
        this.myResultPanel.setFilterText(filterState.text, -1);
    }

    private boolean isDragging() {
        return Boolean.TRUE.equals(FileEditorManagerImpl.CLOSING_TO_REOPEN.get((UserDataHolder)this.myFile));
    }

    private static class DeferredLoader
    extends Activatable.Adapter
    implements ModificationTrackerListener<DbPsiFacade>,
    Disposable {
        private static final Map<DatabaseTableGridDataHookUp, DeferredLoader> LOADERS = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        private final DatabaseTableGridDataHookUp myHookUp;
        private final List<DataGrid> myGrids;
        private final ActionCallback myInitialLoadCallback;
        private LoadingState myState;

        private DeferredLoader(@NotNull DatabaseTableGridDataHookUp hookUp) {
            if (hookUp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "<init>"));
            }
            this.myGrids = new WeakList();
            this.myInitialLoadCallback = new ActionCallback();
            this.myState = LoadingState.NONE;
            this.myHookUp = hookUp;
            Disposer.register((Disposable)this.myHookUp, (Disposable)this);
        }

        public static void installOn(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "installOn"));
            }
            DatabaseTableGridDataHookUp hookUp = DeferredLoader.getTableHookUp(grid);
            DeferredLoader loader = LOADERS.get(hookUp);
            if (loader == null) {
                loader = new DeferredLoader(hookUp);
                LOADERS.put(hookUp, loader);
            }
            loader.addGrid(grid);
        }

        public static void doWhenLoaded(@NotNull DataGrid grid, @NotNull Runnable action) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "doWhenLoaded"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "doWhenLoaded"));
            }
            DeferredLoader loader = LOADERS.get(DeferredLoader.getTableHookUp(grid));
            ActionCallback callback = loader == null ? ActionCallback.DONE : loader.myInitialLoadCallback;
            callback.doWhenDone((Runnable)new DoWhenLoadedActionWrapper(grid, action));
        }

        @NotNull
        private static DatabaseTableGridDataHookUp getTableHookUp(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "getTableHookUp"));
            }
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)grid.getDataHookup();
            if (databaseTableGridDataHookUp == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "getTableHookUp"));
            }
            return databaseTableGridDataHookUp;
        }

        private void addGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader", "addGrid"));
            }
            this.myGrids.add(grid);
            if (this.myState == LoadingState.NONE) {
                Disposer.register((Disposable)grid, (Disposable)new UiNotifyConnector.Once((Component)grid.getComponent(), (Activatable)this));
            }
        }

        public void showNotify() {
            if (this.myState != LoadingState.NONE) {
                return;
            }
            this.myState = LoadingState.INITIATED;
            for (DataGrid grid : this.myGrids) {
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }
            DbPsiFacade psiFacade = DbPsiFacade.getInstance((Project)this.myHookUp.getProject());
            psiFacade.addModificationTrackerListener((ModificationTrackerListener)this, (Disposable)this);
            this.modificationCountChanged(psiFacade);
        }

        public void modificationCountChanged(DbPsiFacade source) {
            DbElement element;
            VirtualFile file = this.myHookUp.getFile();
            DbElement dbElement = element = file.isValid() ? DbImplUtil.findElement(this.myHookUp.getProject(), file) : null;
            if (element == null) {
                return;
            }
            if (this.myState != LoadingState.COMPLETED && DatabaseEditorHelper.isTableDataAvailable(element)) {
                this.myState = LoadingState.COMPLETED;
                this.loadTable();
            }
        }

        private void loadTable() {
            final GridRequestSource<DataConsumer.Row, DataConsumer.Column> initialLoadSource = GridRequestSource.create((Grid)JBIterable.from(this.myGrids).first(), null);
            Disposable initialLoadDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)initialLoadDisposable);
            this.myHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){
                private String myErrorMessage;

                @Override
                public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1", "error"));
                    }
                    if (initialLoadSource == source) {
                        this.myErrorMessage = message;
                    }
                }

                @Override
                public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1", "updateCountReceived"));
                    }
                }

                @Override
                public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1", "requestFinished"));
                    }
                    if (initialLoadSource == source) {
                        if (!success) {
                            myInitialLoadCallback.reject(this.myErrorMessage);
                        } else {
                            myInitialLoadCallback.setDone();
                        }
                        Disposer.dispose((Disposable)this);
                    }
                }
            }, initialLoadDisposable);
            this.tweakSearchPath();
            this.myHookUp.getLoader().loadFirstPage(initialLoadSource);
        }

        private void tweakSearchPath() {
            DatabaseDialectEx dialect = this.myHookUp.getDatabaseDialect();
            DasObject schema = DasUtil.getParentOfKind((DasObject)this.myHookUp.getDatabaseTable(), (ObjectKind)ObjectKind.SCHEMA, (boolean)false);
            DasObject object = DbImplUtil.getSearchPathObject(dialect, schema);
            if (dialect.getFamilyId().isPostgres() || !(schema instanceof DasNamespace) || object == null) {
                return;
            }
            SearchPath path = SearchPath.of(ObjectPath.of(object));
            this.myHookUp.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this.myHookUp, path, false));
        }

        public void dispose() {
            LOADERS.remove(this.myHookUp);
        }

        private static class DoWhenLoadedActionWrapper
        implements Runnable,
        Disposable {
            private Runnable myAction;

            public DoWhenLoadedActionWrapper(@NotNull DataGrid grid, @NotNull Runnable action) {
                if (grid == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper", "<init>"));
                }
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper", "<init>"));
                }
                this.myAction = action;
                Disposer.register((Disposable)grid, (Disposable)this);
            }

            public void dispose() {
                this.myAction = null;
            }

            @Override
            public void run() {
                try {
                    if (this.myAction != null) {
                        this.myAction.run();
                    }
                }
                finally {
                    this.myAction = null;
                    Disposer.dispose((Disposable)this);
                }
            }
        }

        static enum LoadingState {
            NONE,
            INITIATED,
            COMPLETED;

        }
    }

    static class State
    implements FileEditorState,
    Serializable {
        @Property(surroundWithTag=false)
        public Filter filter = new Filter();
        @Tag(value="column-attributes")
        @AbstractCollection(surroundWithTag=false, elementTypes={Column.class})
        public List<Column> columnAttributes = ContainerUtil.newArrayList();

        State() {
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        @Tag(value="column")
        static class Column
        implements Serializable {
            @Attribute(value="name")
            public String name = "";
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Attribute(value="languageId")
            public String languageId = Language.ANY.getID();

            Column() {
            }
        }

        @Tag(value="filtering")
        static class Filter
        implements Serializable {
            @Attribute(value="enabled")
            public boolean enabled = false;
            @Attribute(value="applied")
            public boolean applied = false;
            @Attribute(value="text")
            public String text = "";
            @Property(surroundWithTag=false)
            @AbstractCollection(surroundWithTag=false, elementTag="filter", elementValueAttribute="text", elementTypes={String.class})
            public List<String> history = ContainerUtil.newArrayList();

            Filter() {
            }
        }
    }
}

