/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FormatBasedExtractor
extends TranspositionAwareDefaultExtractor<DatabaseSettings.StdState> {
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("[A-Z]{2,}");
    private final CsvFormat myFormat;

    public FormatBasedExtractor(@NotNull CsvFormat format, @NotNull ObjectFormatter formatter) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/FormatBasedExtractor", "<init>"));
        }
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/extractors/FormatBasedExtractor", "<init>"));
        }
        super(new DatabaseSettings.StdState(), formatter);
        this.myFormat = format;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        Matcher m = FILE_EXTENSION_PATTERN.matcher(this.myFormat.name);
        String ext = m.find() ? m.group() : null;
        String string = StringUtil.isNotEmpty((String)ext) ? ext.toLowerCase(Locale.ENGLISH) : super.getFileExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatBasedExtractor", "getFileExtension"));
        }
        return string;
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, final DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns){
            private final CsvFormatter myFormatter;
            {
                super(FormatBasedExtractor.this, output, dialect2, forceSkipHeader, transpose, allColumns, selectedColumnIndices);
                this.myFormatter = new CsvFormatter(FormatBasedExtractor.this.myFormat);
            }

            @Override
            protected void doAppendData(List<DataConsumer.Row> rows) {
                ArrayList columns = ContainerUtil.newArrayList();
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    ContainerUtil.addIfNotNull((Collection)columns, (Object)columnsMap.get(selectedColumn));
                }
                Object object = rows.iterator();
                while (object.hasNext()) {
                    DataConsumer.Row row = (DataConsumer.Row)object.next();
                    List values = ContainerUtil.map((Collection)columns, column -> FormatBasedExtractor.this.getValueAsString(row, (DataConsumer.Column)column, dialect, false));
                    if (this.myFormatter.requiresRowNumbers()) {
                        values = ContainerUtil.prepend((List)values, (Object[])new Object[]{this.getRowNumber(row)});
                    }
                    this.myOutput.append(this.myFormatter.formatRecord(values));
                    this.myOutput.append(this.myFormatter.recordSeparator());
                }
            }

            @Override
            protected void doAppendHeader(boolean appendNewLine) {
                if (((FormatBasedExtractor)FormatBasedExtractor.this).myFormat.headerRecord == null) {
                    return;
                }
                ArrayList columnNames = ContainerUtil.newArrayList();
                if (this.myFormatter.requiresRowNumbers()) {
                    columnNames.add(this.getRowNumbersColumn().name);
                }
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    columnNames.add(column.name);
                }
                this.myOutput.append(this.myFormatter.formatHeader(columnNames));
                this.myOutput.append(this.myFormatter.recordSeparator());
            }
        };
    }
}

