/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.db2.Db2;
import com.intellij.database.model.derby.Derby;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.sqlite.Sqlite;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a0\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000f\u001a@\u0010\u0010\u001a\u0004\u0018\u0001H\b\"\n\b\u0000\u0010\b\u0018\u0001*\u00020\u0011*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u0014\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018\u001a\u0015\u0010\u0019\u001a\u00020\u001a*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0018H\u0086\u0004\u001a+\u0010\u001c\u001a\u00020\f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0001\"\u00020\f\u00a2\u0006\u0002\u0010!\"!\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\n\n\u0002\u0010\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\""}, d2={"allRdbms", "", "Lorg/jetbrains/dekaf/Rdbms;", "kotlin.jvm.PlatformType", "getAllRdbms", "()[Lorg/jetbrains/dekaf/Rdbms;", "[Lorg/jetbrains/dekaf/Rdbms;", "findMajor", "E", "Lcom/intellij/database/model/basic/BasicMajorObject;", "Lcom/intellij/database/model/basic/BasicSchema;", "majorKind", "Lcom/intellij/database/model/ObjectKind;", "majorId", "", "(Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/model/ObjectKind;J)Lcom/intellij/database/model/basic/BasicMajorObject;", "findMinor", "Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "minorKind", "minorId", "(Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/model/ObjectKind;JLcom/intellij/database/model/ObjectKind;J)Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "findReferencingForeignKeys", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/model/basic/BasicTable;", "refsTo", "", "table", "toKind", "", "codes", "", "kinds", "(CLjava/lang/String;[Lcom/intellij/database/model/ObjectKind;)Lcom/intellij/database/model/ObjectKind;", "database-model-impl"})
@JvmName(name="ModelFun")
public final class ModelFun {
    @NotNull
    private static final Rdbms[] allRdbms;

    private static final <E extends BasicMajorObject> E findMajor(@NotNull BasicSchema $receiver, ObjectKind majorKind, long majorId) {
        Family<? extends BasicElement> family = $receiver.familyOf(majorKind);
        if (family == null) {
            return (E)((BasicMajorObject)null);
        }
        Family<? extends BasicElement> majorFamily = family;
        BasicIdentifiedElement basicIdentifiedElement = majorFamily instanceof IdentifyingFamily ? ((IdentifyingFamily)majorFamily).getByObjectId(majorId) : (BasicIdentifiedElement)null;
        if (basicIdentifiedElement == null) {
            return (E)((BasicMajorObject)null);
        }
        BasicIdentifiedElement majorObject = basicIdentifiedElement;
        Intrinsics.reifiedOperationMarker((int)3, (String)"E");
        return (E)(majorObject instanceof BasicMajorObject ? (BasicMajorObject)((Object)majorObject) : (BasicMajorObject)null);
    }

    private static final <E extends BasicIdentifiedElement> E findMinor(@NotNull BasicSchema $receiver, ObjectKind majorKind, long majorId, ObjectKind minorKind, long minorId) {
        Family<? extends BasicElement> family = $receiver.familyOf(majorKind);
        if (family == null) {
            return (E)((BasicIdentifiedElement)null);
        }
        Family<? extends BasicElement> majorFamily = family;
        BasicIdentifiedElement basicIdentifiedElement = majorFamily instanceof IdentifyingFamily ? ((IdentifyingFamily)majorFamily).getByObjectId(majorId) : (BasicIdentifiedElement)null;
        if (basicIdentifiedElement == null) {
            return (E)((BasicIdentifiedElement)null);
        }
        BasicIdentifiedElement majorObject = basicIdentifiedElement;
        Family<? extends BasicElement> family2 = majorObject.familyOf(minorKind);
        if (family2 == null) {
            return (E)((BasicIdentifiedElement)null);
        }
        Family<? extends BasicElement> minorFamily = family2;
        BasicIdentifiedElement basicIdentifiedElement2 = minorFamily instanceof IdentifyingFamily ? ((IdentifyingFamily)minorFamily).getByObjectId(minorId) : (BasicIdentifiedElement)null;
        if (basicIdentifiedElement2 == null) {
            return (E)((BasicIdentifiedElement)null);
        }
        BasicIdentifiedElement minorObject = basicIdentifiedElement2;
        Intrinsics.reifiedOperationMarker((int)3, (String)"E");
        return (E)(minorObject instanceof BasicIdentifiedElement ? minorObject : (BasicIdentifiedElement)null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ObjectKind toKind(char $receiver, @NotNull String codes, ObjectKind ... kinds) {
        Intrinsics.checkParameterIsNotNull((Object)codes, (String)"codes");
        Intrinsics.checkParameterIsNotNull((Object)kinds, (String)"kinds");
        int n = Math.min(codes.length(), ((Object[])kinds).length);
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                if ($receiver == codes.charAt((int)i2)) {
                    return kinds[i2];
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        ObjectKind objectKind = ObjectKind.NONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.NONE");
        return objectKind;
    }

    @NotNull
    public static final JBIterable<BasicForeignKey> findReferencingForeignKeys(@NotNull BasicTable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicSchema basicSchema = $receiver.getSchema();
        if (basicSchema == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty()");
            return jBIterable;
        }
        BasicSchema schema = basicSchema;
        Family family = schema.getParentFamily();
        Iterable schemata = family != null ? (Iterable)family : (Iterable)SetsKt.setOf((Object)schema);
        JBIterable jBIterable = JBIterable.from((Iterable)schemata).flatten((Function)findReferencingForeignKeys.1.INSTANCE).filter(BasicTable.class).flatten((Function)findReferencingForeignKeys.2.INSTANCE).filter((Condition)new Condition<BasicForeignKey>($receiver){
            final /* synthetic */ BasicTable receiver$0;

            public final boolean value(BasicForeignKey f) {
                return ModelFun.refsTo(f, this.receiver$0);
            }
            {
                this.receiver$0 = basicTable;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(schemata\u2026ilter{f -> f refsTo this}");
        return jBIterable;
    }

    public static final boolean refsTo(@NotNull BasicForeignKey $receiver, @NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        BasicLikeTable basicLikeTable = $receiver.getTable();
        if (!(basicLikeTable instanceof BasicTable)) {
            basicLikeTable = null;
        }
        BasicTable basicTable = (BasicTable)basicLikeTable;
        if (basicTable == null) {
            return false;
        }
        BasicTable fkTable = basicTable;
        String rsn = $receiver.getRefSchemaName();
        if (rsn == null && Intrinsics.areEqual((Object)fkTable.getSchema(), (Object)table.getSchema()) ^ true) {
            return false;
        }
        if (rsn != null && Intrinsics.areEqual((Object)rsn, (Object)table.getSchemaName()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)$receiver.getRefTableName(), (Object)table.getName());
    }

    @NotNull
    public static final Rdbms[] getAllRdbms() {
        return allRdbms;
    }

    static {
        Rdbms[] elements$iv = new Rdbms[]{Oracle.RDBMS, Mssql.RDBMS, Sybase.RDBMS, Postgres.RDBMS, Mysql.RDBMS, H2db.RDBMS, HsqlDB.RDBMS, Db2.RDBMS, Derby.RDBMS, Sqlite.RDBMS, UnknownDatabase.RDBMS};
        allRdbms = (Rdbms[])((Object[])elements$iv);
    }
}

