/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.db2.Db2Constraint;
import com.intellij.database.model.db2.Db2Schema;
import com.intellij.database.model.db2.Db2Table;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2ForeignKey
extends Db2Constraint,
BasicForeignKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public Db2Table getTable();

    @Override
    @Nullable
    default public Db2Table getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public Db2Table getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingFamily<@NotNull ? extends Db2ForeignKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public Db2Schema getSchema() {
        Db2Table table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getColNames"));
        }
        return list;
    }

    @Override
    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getRefColNames"));
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> refColNames;
        String refKeyName;
        String refTableName;
        String refSchemaName;
        List<String> colNames;
        String comment;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/db2/Db2ForeignKey", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if ((refSchemaName = this.getRefSchemaName()) != null) {
            consumer.accept("RefSchemaName", PropertyConverter.export(refSchemaName));
        }
        if ((refTableName = this.getRefTableName()) != null) {
            consumer.accept("RefTableName", PropertyConverter.export(refTableName));
        }
        if ((refKeyName = this.getRefKeyName()) != null) {
            consumer.accept("RefKeyName", PropertyConverter.export(refKeyName));
        }
        if (!(refColNames = this.getRefColNames()).isEmpty()) {
            consumer.accept("RefColNames", PropertyConverter.exportListOfString(refColNames));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "Comment", "ColNames", "RefSchemaName", "RefTableName", "RefKeyName", "RefColNames");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ForeignKey", "getPropertyNames"));
        }
        return list;
    }
}

